
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Contains optional attributes that can occur only in /OTA_AirLowFareSearchRQ/POS/Source.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExtendedSourceAttributeGroup">
 *   &lt;xs:attribute type="xs:string" name="AgentCity"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Carrier"/>
 *   &lt;xs:attribute type="xs:string" name="MainTravelAgencyPCC"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HomePCC"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ExtendedSourceAttributeGroup implements Serializable
{
    private String agentCity;
    private String carrier;
    private String mainTravelAgencyPCC;
    private String homePCC;

    /** 
     * Get the 'AgentCity' attribute value. Agent city
     * 
     * @return value
     */
    public String getAgentCity() {
        return agentCity;
    }

    /** 
     * Set the 'AgentCity' attribute value. Agent city
     * 
     * @param agentCity
     */
    public void setAgentCity(String agentCity) {
        this.agentCity = agentCity;
    }

    /** 
     * Get the 'Carrier' attribute value. Carrier
     * 
     * @return value
     */
    public String getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' attribute value. Carrier
     * 
     * @param carrier
     */
    public void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'MainTravelAgencyPCC' attribute value. Main travel agency PCC
     * 
     * @return value
     */
    public String getMainTravelAgencyPCC() {
        return mainTravelAgencyPCC;
    }

    /** 
     * Set the 'MainTravelAgencyPCC' attribute value. Main travel agency PCC
     * 
     * @param mainTravelAgencyPCC
     */
    public void setMainTravelAgencyPCC(String mainTravelAgencyPCC) {
        this.mainTravelAgencyPCC = mainTravelAgencyPCC;
    }

    /** 
     * Get the 'HomePCC' attribute value. Home PCC
     * 
     * @return value
     */
    public String getHomePCC() {
        return homePCC;
    }

    /** 
     * Set the 'HomePCC' attribute value. Home PCC
     * 
     * @param homePCC
     */
    public void setHomePCC(String homePCC) {
        this.homePCC = homePCC;
    }
}
