
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Fare Component Breakdown
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentBreakdownType">
 *   &lt;xs:attribute type="xs:unsignedShort" use="optional" name="FareComponentReferenceID"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="FareComponentCommission"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="EarnedFareComponentCommission"/>
 *   &lt;xs:attribute type="xs:unsignedLong" use="optional" name="MethodID"/>
 *   &lt;xs:attribute type="xs:unsignedLong" use="optional" name="RuleID"/>
 *   &lt;xs:attribute type="xs:unsignedLong" use="optional" name="RuleFamilyID"/>
 *   &lt;xs:attribute type="xs:unsignedLong" use="optional" name="ContractID"/>
 *   &lt;xs:attribute type="xs:unsignedLong" use="optional" name="ContractFamilyID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareComponentBreakdownType implements Serializable
{
    private String fareComponentReferenceID;
    private BigDecimal fareComponentCommission;
    private BigDecimal earnedFareComponentCommission;
    private String methodID;
    private String ruleID;
    private String ruleFamilyID;
    private String contractID;
    private String contractFamilyID;

    /** 
     * Get the 'FareComponentReferenceID' attribute value.
     * 
     * @return value
     */
    public String getFareComponentReferenceID() {
        return fareComponentReferenceID;
    }

    /** 
     * Set the 'FareComponentReferenceID' attribute value.
     * 
     * @param fareComponentReferenceID
     */
    public void setFareComponentReferenceID(String fareComponentReferenceID) {
        this.fareComponentReferenceID = fareComponentReferenceID;
    }

    /** 
     * Get the 'FareComponentCommission' attribute value. Commission Amount per Fare Component
     * 
     * @return value
     */
    public BigDecimal getFareComponentCommission() {
        return fareComponentCommission;
    }

    /** 
     * Set the 'FareComponentCommission' attribute value. Commission Amount per Fare Component
     * 
     * @param fareComponentCommission
     */
    public void setFareComponentCommission(BigDecimal fareComponentCommission) {
        this.fareComponentCommission = fareComponentCommission;
    }

    /** 
     * Get the 'EarnedFareComponentCommission' attribute value. Earned Commission Amount per Fare Component
     * 
     * @return value
     */
    public BigDecimal getEarnedFareComponentCommission() {
        return earnedFareComponentCommission;
    }

    /** 
     * Set the 'EarnedFareComponentCommission' attribute value. Earned Commission Amount per Fare Component
     * 
     * @param earnedFareComponentCommission
     */
    public void setEarnedFareComponentCommission(
            BigDecimal earnedFareComponentCommission) {
        this.earnedFareComponentCommission = earnedFareComponentCommission;
    }

    /** 
     * Get the 'MethodID' attribute value. Commission Method ID
     * 
     * @return value
     */
    public String getMethodID() {
        return methodID;
    }

    /** 
     * Set the 'MethodID' attribute value. Commission Method ID
     * 
     * @param methodID
     */
    public void setMethodID(String methodID) {
        this.methodID = methodID;
    }

    /** 
     * Get the 'RuleID' attribute value. Commission Rule ID
     * 
     * @return value
     */
    public String getRuleID() {
        return ruleID;
    }

    /** 
     * Set the 'RuleID' attribute value. Commission Rule ID
     * 
     * @param ruleID
     */
    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    /** 
     * Get the 'RuleFamilyID' attribute value. Commission Rule Family ID
     * 
     * @return value
     */
    public String getRuleFamilyID() {
        return ruleFamilyID;
    }

    /** 
     * Set the 'RuleFamilyID' attribute value. Commission Rule Family ID
     * 
     * @param ruleFamilyID
     */
    public void setRuleFamilyID(String ruleFamilyID) {
        this.ruleFamilyID = ruleFamilyID;
    }

    /** 
     * Get the 'ContractID' attribute value. Commission Contract ID
     * 
     * @return value
     */
    public String getContractID() {
        return contractID;
    }

    /** 
     * Set the 'ContractID' attribute value. Commission Contract ID
     * 
     * @param contractID
     */
    public void setContractID(String contractID) {
        this.contractID = contractID;
    }

    /** 
     * Get the 'ContractFamilyID' attribute value. Commission Contract Family ID
     * 
     * @return value
     */
    public String getContractFamilyID() {
        return contractFamilyID;
    }

    /** 
     * Set the 'ContractFamilyID' attribute value. Commission Contract Family ID
     * 
     * @param contractFamilyID
     */
    public void setContractFamilyID(String contractFamilyID) {
        this.contractFamilyID = contractFamilyID;
    }
}
