
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo_TPA_ExtensionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="SeatsRemaining" minOccurs="0">
 *       &lt;!-- Reference to inner class SeatsRemaining -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Cabin" minOccurs="0">
 *       &lt;!-- Reference to inner class Cabin -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FlightAmenities" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FlightAmenities -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareNote" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FareNote -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Meal" minOccurs="0">
 *       &lt;!-- Reference to inner class Meal -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Rule" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Rule -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareInfoTPAExtensionsType implements Serializable
{
    private SeatsRemaining seatsRemaining;
    private Cabin cabin;
    private List<FlightAmenities> flightAmenityList = new ArrayList<FlightAmenities>();
    private List<FareNote> fareNoteList = new ArrayList<FareNote>();
    private Meal meal;
    private List<Rule> ruleList = new ArrayList<Rule>();

    /** 
     * Get the 'SeatsRemaining' element value.
     * 
     * @return value
     */
    public SeatsRemaining getSeatsRemaining() {
        return seatsRemaining;
    }

    /** 
     * Set the 'SeatsRemaining' element value.
     * 
     * @param seatsRemaining
     */
    public void setSeatsRemaining(SeatsRemaining seatsRemaining) {
        this.seatsRemaining = seatsRemaining;
    }

    /** 
     * Get the 'Cabin' element value.
     * 
     * @return value
     */
    public Cabin getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' element value.
     * 
     * @param cabin
     */
    public void setCabin(Cabin cabin) {
        this.cabin = cabin;
    }

    /** 
     * Get the list of 'FlightAmenities' element items.
     * 
     * @return list
     */
    public List<FlightAmenities> getFlightAmenityList() {
        return flightAmenityList;
    }

    /** 
     * Set the list of 'FlightAmenities' element items.
     * 
     * @param list
     */
    public void setFlightAmenityList(List<FlightAmenities> list) {
        flightAmenityList = list;
    }

    /** 
     * Get the list of 'FareNote' element items.
     * 
     * @return list
     */
    public List<FareNote> getFareNoteList() {
        return fareNoteList;
    }

    /** 
     * Set the list of 'FareNote' element items.
     * 
     * @param list
     */
    public void setFareNoteList(List<FareNote> list) {
        fareNoteList = list;
    }

    /** 
     * Get the 'Meal' element value.
     * 
     * @return value
     */
    public Meal getMeal() {
        return meal;
    }

    /** 
     * Set the 'Meal' element value.
     * 
     * @param meal
     */
    public void setMeal(Meal meal) {
        this.meal = meal;
    }

    /** 
     * Get the list of 'Rule' element items.
     * 
     * @return list
     */
    public List<Rule> getRuleList() {
        return ruleList;
    }

    /** 
     * Set the list of 'Rule' element items.
     * 
     * @param list
     */
    public void setRuleList(List<Rule> list) {
        ruleList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatsRemaining" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:int" name="Number"/>
     *     &lt;xs:attribute type="xs:boolean" name="BelowMin"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SeatsRemaining implements Serializable
    {
        private Integer number;
        private Boolean belowMin;

        /** 
         * Get the 'Number' attribute value.
         * 
         * @return value
         */
        public Integer getNumber() {
            return number;
        }

        /** 
         * Set the 'Number' attribute value.
         * 
         * @param number
         */
        public void setNumber(Integer number) {
            this.number = number;
        }

        /** 
         * Get the 'BelowMin' attribute value.
         * 
         * @return value
         */
        public Boolean getBelowMin() {
            return belowMin;
        }

        /** 
         * Set the 'BelowMin' attribute value.
         * 
         * @param belowMin
         */
        public void setBelowMin(Boolean belowMin) {
            this.belowMin = belowMin;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cabin" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" default="Economy" name="Cabin"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Cabin implements Serializable
    {
        private String cabin;

        /** 
         * Get the 'Cabin' attribute value.
         * 
         * @return value
         */
        public String getCabin() {
            return cabin;
        }

        /** 
         * Set the 'Cabin' attribute value.
         * 
         * @param cabin
         */
        public void setCabin(String cabin) {
            this.cabin = cabin;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightAmenities" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="Subsegment"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="BeverageRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="EntertainmentRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="FoodRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="LayoutRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="PowerRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="SeatRef"/>
     *     &lt;xs:attribute type="xs:integer" use="optional" name="WifiRef"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightAmenities implements Serializable
    {
        private String subsegment;
        private BigInteger beverageRef;
        private BigInteger entertainmentRef;
        private BigInteger foodRef;
        private BigInteger layoutRef;
        private BigInteger powerRef;
        private BigInteger seatRef;
        private BigInteger wifiRef;

        /** 
         * Get the 'Subsegment' attribute value. 1-based number of the flight "subsegment" the referred amenity applies to. "Subsegment" is a portion of flight separated by a hidden stop. This attribute is omitted for flights without hidden stops. 
         * 
         * @return value
         */
        public String getSubsegment() {
            return subsegment;
        }

        /** 
         * Set the 'Subsegment' attribute value. 1-based number of the flight "subsegment" the referred amenity applies to. "Subsegment" is a portion of flight separated by a hidden stop. This attribute is omitted for flights without hidden stops. 
         * 
         * @param subsegment
         */
        public void setSubsegment(String subsegment) {
            this.subsegment = subsegment;
        }

        /** 
         * Get the 'BeverageRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getBeverageRef() {
            return beverageRef;
        }

        /** 
         * Set the 'BeverageRef' attribute value.
         * 
         * @param beverageRef
         */
        public void setBeverageRef(BigInteger beverageRef) {
            this.beverageRef = beverageRef;
        }

        /** 
         * Get the 'EntertainmentRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getEntertainmentRef() {
            return entertainmentRef;
        }

        /** 
         * Set the 'EntertainmentRef' attribute value.
         * 
         * @param entertainmentRef
         */
        public void setEntertainmentRef(BigInteger entertainmentRef) {
            this.entertainmentRef = entertainmentRef;
        }

        /** 
         * Get the 'FoodRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getFoodRef() {
            return foodRef;
        }

        /** 
         * Set the 'FoodRef' attribute value.
         * 
         * @param foodRef
         */
        public void setFoodRef(BigInteger foodRef) {
            this.foodRef = foodRef;
        }

        /** 
         * Get the 'LayoutRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getLayoutRef() {
            return layoutRef;
        }

        /** 
         * Set the 'LayoutRef' attribute value.
         * 
         * @param layoutRef
         */
        public void setLayoutRef(BigInteger layoutRef) {
            this.layoutRef = layoutRef;
        }

        /** 
         * Get the 'PowerRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getPowerRef() {
            return powerRef;
        }

        /** 
         * Set the 'PowerRef' attribute value.
         * 
         * @param powerRef
         */
        public void setPowerRef(BigInteger powerRef) {
            this.powerRef = powerRef;
        }

        /** 
         * Get the 'SeatRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getSeatRef() {
            return seatRef;
        }

        /** 
         * Set the 'SeatRef' attribute value.
         * 
         * @param seatRef
         */
        public void setSeatRef(BigInteger seatRef) {
            this.seatRef = seatRef;
        }

        /** 
         * Get the 'WifiRef' attribute value.
         * 
         * @return value
         */
        public BigInteger getWifiRef() {
            return wifiRef;
        }

        /** 
         * Set the 'WifiRef' attribute value.
         * 
         * @param wifiRef
         */
        public void setWifiRef(BigInteger wifiRef) {
            this.wifiRef = wifiRef;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareNote" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="optional" name="FareTypeName"/>
     *     &lt;xs:attribute type="xs:int" name="PriorityLevel"/>
     *     &lt;xs:attribute type="xs:string" name="ContentID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareNote implements Serializable
    {
        private String fareTypeName;
        private Integer priorityLevel;
        private String contentID;

        /** 
         * Get the 'FareTypeName' attribute value.
         * 
         * @return value
         */
        public String getFareTypeName() {
            return fareTypeName;
        }

        /** 
         * Set the 'FareTypeName' attribute value.
         * 
         * @param fareTypeName
         */
        public void setFareTypeName(String fareTypeName) {
            this.fareTypeName = fareTypeName;
        }

        /** 
         * Get the 'PriorityLevel' attribute value.
         * 
         * @return value
         */
        public Integer getPriorityLevel() {
            return priorityLevel;
        }

        /** 
         * Set the 'PriorityLevel' attribute value.
         * 
         * @param priorityLevel
         */
        public void setPriorityLevel(Integer priorityLevel) {
            this.priorityLevel = priorityLevel;
        }

        /** 
         * Get the 'ContentID' attribute value.
         * 
         * @return value
         */
        public String getContentID() {
            return contentID;
        }

        /** 
         * Set the 'ContentID' attribute value.
         * 
         * @param contentID
         */
        public void setContentID(String contentID) {
            this.contentID = contentID;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Meal" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Code"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Meal implements Serializable
    {
        private String code;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Rule" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" name="Type"/>
     *     &lt;xs:attribute type="xs:int" name="ID"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Rule implements Serializable
    {
        private String type;
        private Integer ID;

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public String getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(String type) {
            this.type = type;
        }

        /** 
         * Get the 'ID' attribute value.
         * 
         * @return value
         */
        public Integer getID() {
            return ID;
        }

        /** 
         * Set the 'ID' attribute value.
         * 
         * @param ID
         */
        public void setID(Integer ID) {
            this.ID = ID;
        }
    }
}
