
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Rules for this priced option. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="FareReference"/>
 *     &lt;xs:element type="ns:RuleInfoType" name="RuleInfo"/>
 *     &lt;xs:element type="ns:CompanyNameType" name="MarketingAirline" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:ResponseLocationType" name="DepartureAirport"/>
 *     &lt;xs:element type="ns:ResponseLocationType" name="ArrivalAirport"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:NegotiatedFareAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareInfoType implements Serializable
{
    private String departureDate;
    private String fareReference;
    private RuleInfoType ruleInfo;
    private List<CompanyNameType> marketingAirlineList = new ArrayList<CompanyNameType>();
    private ResponseLocationType departureAirport;
    private ResponseLocationType arrivalAirport;
    private NegotiatedFareAttributes negotiatedFareAttributes;

    /** 
     * Get the 'DepartureDate' element value. Departure Date for this priced fare. 
     * 
     * @return value
     */
    public String getDepartureDate() {
        return departureDate;
    }

    /** 
     * Set the 'DepartureDate' element value. Departure Date for this priced fare. 
     * 
     * @param departureDate
     */
    public void setDepartureDate(String departureDate) {
        this.departureDate = departureDate;
    }

    /** 
     * Get the 'FareReference' element value. FareReferenceCode can be used for either the Fare Basis Code or the Fare Class Code. 
     * 
     * @return value
     */
    public String getFareReference() {
        return fareReference;
    }

    /** 
     * Set the 'FareReference' element value. FareReferenceCode can be used for either the Fare Basis Code or the Fare Class Code. 
     * 
     * @param fareReference
     */
    public void setFareReference(String fareReference) {
        this.fareReference = fareReference;
    }

    /** 
     * Get the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
     * 
     * @return value
     */
    public RuleInfoType getRuleInfo() {
        return ruleInfo;
    }

    /** 
     * Set the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
     * 
     * @param ruleInfo
     */
    public void setRuleInfo(RuleInfoType ruleInfo) {
        this.ruleInfo = ruleInfo;
    }

    /** 
     * Get the list of 'MarketingAirline' element items. The marketing airline.
     * 
     * @return list
     */
    public List<CompanyNameType> getMarketingAirlineList() {
        return marketingAirlineList;
    }

    /** 
     * Set the list of 'MarketingAirline' element items. The marketing airline.
     * 
     * @param list
     */
    public void setMarketingAirlineList(List<CompanyNameType> list) {
        marketingAirlineList = list;
    }

    /** 
     * Get the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @return value
     */
    public ResponseLocationType getDepartureAirport() {
        return departureAirport;
    }

    /** 
     * Set the 'DepartureAirport' element value. Departure point of flight segment.
     * 
     * @param departureAirport
     */
    public void setDepartureAirport(ResponseLocationType departureAirport) {
        this.departureAirport = departureAirport;
    }

    /** 
     * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @return value
     */
    public ResponseLocationType getArrivalAirport() {
        return arrivalAirport;
    }

    /** 
     * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
     * 
     * @param arrivalAirport
     */
    public void setArrivalAirport(ResponseLocationType arrivalAirport) {
        this.arrivalAirport = arrivalAirport;
    }

    /** 
     * Get the 'NegotiatedFareAttributes' attributeGroup value.
     * 
     * @return value
     */
    public NegotiatedFareAttributes getNegotiatedFareAttributes() {
        return negotiatedFareAttributes;
    }

    /** 
     * Set the 'NegotiatedFareAttributes' attributeGroup value.
     * 
     * @param negotiatedFareAttributes
     */
    public void setNegotiatedFareAttributes(
            NegotiatedFareAttributes negotiatedFareAttributes) {
        this.negotiatedFareAttributes = negotiatedFareAttributes;
    }
}
