
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Attribute collection providing fare source and type attrivutes
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareSourceAndTypeAttributes">
 *   &lt;xs:attribute type="xs:string" use="optional" name="PricingSource"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PricingSubSource"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="FareReturned"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FareStatus"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="CachedItin"/>
 *   &lt;xs:attribute type="xs:string" name="CachePartition"/>
 *   &lt;xs:attribute type="xs:integer" name="CachePartitionPriority"/>
 *   &lt;xs:attribute type="xs:string" name="CacheVersion"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="TimeToLive"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="HoursSinceCreation"/>
 *   &lt;xs:attribute type="xs:boolean" default="false" name="AlternateCityOption"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="BrandsOnAnyMarket"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Revalidated"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FareSourceAndTypeAttributes implements Serializable
{
    private String pricingSource;
    private String pricingSubSource;
    private String pseudoCityCode;
    private String brandID;
    private Boolean fareReturned;
    private String fareStatus;
    private Boolean cachedItin;
    private String cachePartition;
    private BigInteger cachePartitionPriority;
    private String cacheVersion;
    private BigInteger timeToLive;
    private BigInteger hoursSinceCreation;
    private Boolean alternateCityOption;
    private Boolean brandsOnAnyMarket;
    private Boolean revalidated;

    /** 
     * Get the 'PricingSource' attribute value. Used to indicate whether the pricing is public or private
     * 
     * @return value
     */
    public String getPricingSource() {
        return pricingSource;
    }

    /** 
     * Set the 'PricingSource' attribute value. Used to indicate whether the pricing is public or private
     * 
     * @param pricingSource
     */
    public void setPricingSource(String pricingSource) {
        this.pricingSource = pricingSource;
    }

    /** 
     * Get the 'PricingSubSource' attribute value. Pricing sub source.
     * 
     * @return value
     */
    public String getPricingSubSource() {
        return pricingSubSource;
    }

    /** 
     * Set the 'PricingSubSource' attribute value. Pricing sub source.
     * 
     * @param pricingSubSource
     */
    public void setPricingSubSource(String pricingSubSource) {
        this.pricingSubSource = pricingSubSource;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value. (MultiPCC) Information about Pseudo City Code for wich the fare was produced.
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value. (MultiPCC) Information about Pseudo City Code for wich the fare was produced.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'BrandID' attribute value. Used to indicate brand code (e.g. SS for SuperSaver) or type of Fare (e.g. Sale Fare or Full Coach and so on...)
     * 
     * @return value
     */
    public String getBrandID() {
        return brandID;
    }

    /** 
     * Set the 'BrandID' attribute value. Used to indicate brand code (e.g. SS for SuperSaver) or type of Fare (e.g. Sale Fare or Full Coach and so on...)
     * 
     * @param brandID
     */
    public void setBrandID(String brandID) {
        this.brandID = brandID;
    }

    /** 
     * Get the 'FareReturned' attribute value. Boolean to indicate if a fare returned for the BrandID or not (true if fare is returned and false if no fare returned)
     * 
     * @return value
     */
    public Boolean getFareReturned() {
        return fareReturned;
    }

    /** 
     * Set the 'FareReturned' attribute value. Boolean to indicate if a fare returned for the BrandID or not (true if fare is returned and false if no fare returned)
     * 
     * @param fareReturned
     */
    public void setFareReturned(Boolean fareReturned) {
        this.fareReturned = fareReturned;
    }

    /** 
     * Get the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable".
     * 
     * @return value
     */
    public String getFareStatus() {
        return fareStatus;
    }

    /** 
     * Set the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable".
     * 
     * @param fareStatus
     */
    public void setFareStatus(String fareStatus) {
        this.fareStatus = fareStatus;
    }

    /** 
     * Get the 'CachedItin' attribute value. Indicates whether the itin is from Cache. If true, it is from Cache.
     * 
     * @return value
     */
    public Boolean getCachedItin() {
        return cachedItin;
    }

    /** 
     * Set the 'CachedItin' attribute value. Indicates whether the itin is from Cache. If true, it is from Cache.
     * 
     * @param cachedItin
     */
    public void setCachedItin(Boolean cachedItin) {
        this.cachedItin = cachedItin;
    }

    /** 
     * Get the 'CachePartition' attribute value. Indicates source partition of cached itin
     * 
     * @return value
     */
    public String getCachePartition() {
        return cachePartition;
    }

    /** 
     * Set the 'CachePartition' attribute value. Indicates source partition of cached itin
     * 
     * @param cachePartition
     */
    public void setCachePartition(String cachePartition) {
        this.cachePartition = cachePartition;
    }

    /** 
     * Get the 'CachePartitionPriority' attribute value. Indicates source partition priority of cached itin
     * 
     * @return value
     */
    public BigInteger getCachePartitionPriority() {
        return cachePartitionPriority;
    }

    /** 
     * Set the 'CachePartitionPriority' attribute value. Indicates source partition priority of cached itin
     * 
     * @param cachePartitionPriority
     */
    public void setCachePartitionPriority(BigInteger cachePartitionPriority) {
        this.cachePartitionPriority = cachePartitionPriority;
    }

    /** 
     * Get the 'CacheVersion' attribute value. Indicates source version of cached itin
     * 
     * @return value
     */
    public String getCacheVersion() {
        return cacheVersion;
    }

    /** 
     * Set the 'CacheVersion' attribute value. Indicates source version of cached itin
     * 
     * @param cacheVersion
     */
    public void setCacheVersion(String cacheVersion) {
        this.cacheVersion = cacheVersion;
    }

    /** 
     * Get the 'TimeToLive' attribute value. Time to live in cache (in minutes).
     * 
     * @return value
     */
    public BigInteger getTimeToLive() {
        return timeToLive;
    }

    /** 
     * Set the 'TimeToLive' attribute value. Time to live in cache (in minutes).
     * 
     * @param timeToLive
     */
    public void setTimeToLive(BigInteger timeToLive) {
        this.timeToLive = timeToLive;
    }

    /** 
     * Get the 'HoursSinceCreation' attribute value. Hours since option was created and stored in cache (in hours).
     * 
     * @return value
     */
    public BigInteger getHoursSinceCreation() {
        return hoursSinceCreation;
    }

    /** 
     * Set the 'HoursSinceCreation' attribute value. Hours since option was created and stored in cache (in hours).
     * 
     * @param hoursSinceCreation
     */
    public void setHoursSinceCreation(BigInteger hoursSinceCreation) {
        this.hoursSinceCreation = hoursSinceCreation;
    }

    /** 
     * Get the 'AlternateCityOption' attribute value. Indicates that this option is alternate dates option.
     * 
     * @return value
     */
    public Boolean getAlternateCityOption() {
        return alternateCityOption;
    }

    /** 
     * Set the 'AlternateCityOption' attribute value. Indicates that this option is alternate dates option.
     * 
     * @param alternateCityOption
     */
    public void setAlternateCityOption(Boolean alternateCityOption) {
        this.alternateCityOption = alternateCityOption;
    }

    /** 
     * Get the 'BrandsOnAnyMarket' attribute value. True if itin has any brand on any fare market
     * 
     * @return value
     */
    public Boolean getBrandsOnAnyMarket() {
        return brandsOnAnyMarket;
    }

    /** 
     * Set the 'BrandsOnAnyMarket' attribute value. True if itin has any brand on any fare market
     * 
     * @param brandsOnAnyMarket
     */
    public void setBrandsOnAnyMarket(Boolean brandsOnAnyMarket) {
        this.brandsOnAnyMarket = brandsOnAnyMarket;
    }

    /** 
     * Get the 'Revalidated' attribute value. True if itin has been revalidated in WPNI verification flow
     * 
     * @return value
     */
    public Boolean getRevalidated() {
        return revalidated;
    }

    /** 
     * Set the 'Revalidated' attribute value. True if itin has been revalidated in WPNI verification flow
     * 
     * @param revalidated
     */
    public void setRevalidated(Boolean revalidated) {
        this.revalidated = revalidated;
    }
}
