
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Holds a base fare, tax, total and currency information on a price
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="BaseFare">
 *       &lt;xs:complexType>
 *         &lt;xs:complexContent>
 *           &lt;xs:extension base="ns:CurrencyAmountType">
 *             &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAdjustment"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:complexContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountType" name="NonRefundableBaseFare" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyAmountType" name="FareConstruction" minOccurs="0"/>
 *     &lt;xs:element name="EquivFare" minOccurs="0">
 *       &lt;!-- Reference to inner class EquivFare -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountType" name="CreditCardFee" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyAmountType" name="BookingFee" minOccurs="0"/>
 *     &lt;xs:element name="Taxes" minOccurs="0">
 *       &lt;!-- Reference to inner class Taxes -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Fees" minOccurs="0">
 *       &lt;!-- Reference to inner class Fees -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="OBFees" minOccurs="0">
 *       &lt;!-- Reference to inner class OBFees -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:RateOfExchangeType" name="RateOfExchange" minOccurs="0"/>
 *     &lt;xs:element type="ns:CurrencyConversionsType" name="CurrencyConversions" minOccurs="0"/>
 *     &lt;xs:element name="TotalFare">
 *       &lt;xs:complexType>
 *         &lt;xs:complexContent>
 *           &lt;xs:extension base="ns:CurrencyAmountType">
 *             &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAdjustment"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:complexContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="ReissueInfoList" minOccurs="0">
 *       &lt;!-- Reference to inner class ReissueInfoList -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="PenaltiesInfo" minOccurs="0">
 *       &lt;!-- Reference to inner class PenaltiesInfo -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:CurrencyAmountType" name="NoMarkupBaseFare" minOccurs="0"/>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:NegotiatedFareAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FareType implements Serializable
{
    private CurrencyAmountType baseFareCurrencyAmountType;
    private BigDecimal baseFareAmountAdjustment;
    private CurrencyAmountType nonRefundableBaseFare;
    private CurrencyAmountType fareConstruction;
    private EquivFare equivFare;
    private CurrencyAmountType creditCardFee;
    private CurrencyAmountType bookingFee;
    private Taxes taxes;
    private Fees fees;
    private OBFees OBFees1;
    private RateOfExchangeType rateOfExchange;
    private CurrencyConversionsType currencyConversions;
    private CurrencyAmountType totalFareCurrencyAmountType;
    private BigDecimal totalFareAmountAdjustment;
    private ReissueInfoList reissueInfoList;
    private PenaltiesInfo penaltiesInfo;
    private CurrencyAmountType noMarkupBaseFare;
    private TPAExtensions TPAExtensions1;
    private NegotiatedFareAttributes negotiatedFareAttributes;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public CurrencyAmountType getBaseFareCurrencyAmountType() {
        return baseFareCurrencyAmountType;
    }

    /** 
     * Set the extension value.
     * 
     * @param baseFareCurrencyAmountType
     */
    public void setBaseFareCurrencyAmountType(
            CurrencyAmountType baseFareCurrencyAmountType) {
        this.baseFareCurrencyAmountType = baseFareCurrencyAmountType;
    }

    /** 
     * Get the 'AmountAdjustment' attribute value. Element of Price Adjustment project
     * 
     * @return value
     */
    public BigDecimal getBaseFareAmountAdjustment() {
        return baseFareAmountAdjustment;
    }

    /** 
     * Set the 'AmountAdjustment' attribute value. Element of Price Adjustment project
     * 
     * @param baseFareAmountAdjustment
     */
    public void setBaseFareAmountAdjustment(BigDecimal baseFareAmountAdjustment) {
        this.baseFareAmountAdjustment = baseFareAmountAdjustment;
    }

    /** 
     * Get the 'NonRefundableBaseFare' element value. Non-refundable base fare amount
     * 
     * @return value
     */
    public CurrencyAmountType getNonRefundableBaseFare() {
        return nonRefundableBaseFare;
    }

    /** 
     * Set the 'NonRefundableBaseFare' element value. Non-refundable base fare amount
     * 
     * @param nonRefundableBaseFare
     */
    public void setNonRefundableBaseFare(
            CurrencyAmountType nonRefundableBaseFare) {
        this.nonRefundableBaseFare = nonRefundableBaseFare;
    }

    /** 
     * Get the 'FareConstruction' element value. Fare construction total amount.
     * 
     * @return value
     */
    public CurrencyAmountType getFareConstruction() {
        return fareConstruction;
    }

    /** 
     * Set the 'FareConstruction' element value. Fare construction total amount.
     * 
     * @param fareConstruction
     */
    public void setFareConstruction(CurrencyAmountType fareConstruction) {
        this.fareConstruction = fareConstruction;
    }

    /** 
     * Get the 'EquivFare' element value.
     * 
     * @return value
     */
    public EquivFare getEquivFare() {
        return equivFare;
    }

    /** 
     * Set the 'EquivFare' element value.
     * 
     * @param equivFare
     */
    public void setEquivFare(EquivFare equivFare) {
        this.equivFare = equivFare;
    }

    /** 
     * Get the 'CreditCardFee' element value. Credit card fee. Returned only if non-zero value
     * 
     * @return value
     */
    public CurrencyAmountType getCreditCardFee() {
        return creditCardFee;
    }

    /** 
     * Set the 'CreditCardFee' element value. Credit card fee. Returned only if non-zero value
     * 
     * @param creditCardFee
     */
    public void setCreditCardFee(CurrencyAmountType creditCardFee) {
        this.creditCardFee = creditCardFee;
    }

    /** 
     * Get the 'BookingFee' element value. Booking fee. Returned only if non-zero value
     * 
     * @return value
     */
    public CurrencyAmountType getBookingFee() {
        return bookingFee;
    }

    /** 
     * Set the 'BookingFee' element value. Booking fee. Returned only if non-zero value
     * 
     * @param bookingFee
     */
    public void setBookingFee(CurrencyAmountType bookingFee) {
        this.bookingFee = bookingFee;
    }

    /** 
     * Get the 'Taxes' element value.
     * 
     * @return value
     */
    public Taxes getTaxes() {
        return taxes;
    }

    /** 
     * Set the 'Taxes' element value.
     * 
     * @param taxes
     */
    public void setTaxes(Taxes taxes) {
        this.taxes = taxes;
    }

    /** 
     * Get the 'Fees' element value.
     * 
     * @return value
     */
    public Fees getFees() {
        return fees;
    }

    /** 
     * Set the 'Fees' element value.
     * 
     * @param fees
     */
    public void setFees(Fees fees) {
        this.fees = fees;
    }

    /** 
     * Get the 'OBFees' element value.
     * 
     * @return value
     */
    public OBFees getOBFees1() {
        return OBFees1;
    }

    /** 
     * Set the 'OBFees' element value.
     * 
     * @param OBFees1
     */
    public void setOBFees1(OBFees OBFees1) {
        this.OBFees1 = OBFees1;
    }

    /** 
     * Get the 'RateOfExchange' element value.
     * 
     * @return value
     */
    public RateOfExchangeType getRateOfExchange() {
        return rateOfExchange;
    }

    /** 
     * Set the 'RateOfExchange' element value.
     * 
     * @param rateOfExchange
     */
    public void setRateOfExchange(RateOfExchangeType rateOfExchange) {
        this.rateOfExchange = rateOfExchange;
    }

    /** 
     * Get the 'CurrencyConversions' element value.
     * 
     * @return value
     */
    public CurrencyConversionsType getCurrencyConversions() {
        return currencyConversions;
    }

    /** 
     * Set the 'CurrencyConversions' element value.
     * 
     * @param currencyConversions
     */
    public void setCurrencyConversions(
            CurrencyConversionsType currencyConversions) {
        this.currencyConversions = currencyConversions;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public CurrencyAmountType getTotalFareCurrencyAmountType() {
        return totalFareCurrencyAmountType;
    }

    /** 
     * Set the extension value.
     * 
     * @param totalFareCurrencyAmountType
     */
    public void setTotalFareCurrencyAmountType(
            CurrencyAmountType totalFareCurrencyAmountType) {
        this.totalFareCurrencyAmountType = totalFareCurrencyAmountType;
    }

    /** 
     * Get the 'AmountAdjustment' attribute value. Element of Price Adjustment project
     * 
     * @return value
     */
    public BigDecimal getTotalFareAmountAdjustment() {
        return totalFareAmountAdjustment;
    }

    /** 
     * Set the 'AmountAdjustment' attribute value. Element of Price Adjustment project
     * 
     * @param totalFareAmountAdjustment
     */
    public void setTotalFareAmountAdjustment(
            BigDecimal totalFareAmountAdjustment) {
        this.totalFareAmountAdjustment = totalFareAmountAdjustment;
    }

    /** 
     * Get the 'ReissueInfoList' element value.
     * 
     * @return value
     */
    public ReissueInfoList getReissueInfoList() {
        return reissueInfoList;
    }

    /** 
     * Set the 'ReissueInfoList' element value.
     * 
     * @param reissueInfoList
     */
    public void setReissueInfoList(ReissueInfoList reissueInfoList) {
        this.reissueInfoList = reissueInfoList;
    }

    /** 
     * Get the 'PenaltiesInfo' element value.
     * 
     * @return value
     */
    public PenaltiesInfo getPenaltiesInfo() {
        return penaltiesInfo;
    }

    /** 
     * Set the 'PenaltiesInfo' element value.
     * 
     * @param penaltiesInfo
     */
    public void setPenaltiesInfo(PenaltiesInfo penaltiesInfo) {
        this.penaltiesInfo = penaltiesInfo;
    }

    /** 
     * Get the 'NoMarkupBaseFare' element value. Price of the inventory excluding taxes, fees and markups
     * 
     * @return value
     */
    public CurrencyAmountType getNoMarkupBaseFare() {
        return noMarkupBaseFare;
    }

    /** 
     * Set the 'NoMarkupBaseFare' element value. Price of the inventory excluding taxes, fees and markups
     * 
     * @param noMarkupBaseFare
     */
    public void setNoMarkupBaseFare(CurrencyAmountType noMarkupBaseFare) {
        this.noMarkupBaseFare = noMarkupBaseFare;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'NegotiatedFareAttributes' attributeGroup value.
     * 
     * @return value
     */
    public NegotiatedFareAttributes getNegotiatedFareAttributes() {
        return negotiatedFareAttributes;
    }

    /** 
     * Set the 'NegotiatedFareAttributes' attributeGroup value.
     * 
     * @param negotiatedFareAttributes
     */
    public void setNegotiatedFareAttributes(
            NegotiatedFareAttributes negotiatedFareAttributes) {
        this.negotiatedFareAttributes = negotiatedFareAttributes;
    }
    /** 
     * Price of the inventory excluding taxes and fees in the payable currency.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:CurrencyAmountType">
     *         &lt;xs:attribute type="xs:decimal" use="optional" name="EffectivePriceDeviation"/>
     *         &lt;xs:attribute use="optional" name="EffectiveDeviationType">
     *           &lt;xs:simpleType>
     *             &lt;!-- Reference to inner class EffectiveDeviationType -->
     *           &lt;/xs:simpleType>
     *         &lt;/xs:attribute>
     *         &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAdjustment"/>
     *         &lt;xs:attribute type="xs:decimal" use="optional" name="EffectivePriceDeviationAdjustment"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class EquivFare extends CurrencyAmountType implements
        Serializable
    {
        private BigDecimal effectivePriceDeviation;
        private EffectiveDeviationType effectiveDeviationType;
        private BigDecimal amountAdjustment;
        private BigDecimal effectivePriceDeviationAdjustment;

        /** 
         * Get the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
         * 
         * @return value
         */
        public BigDecimal getEffectivePriceDeviation() {
            return effectivePriceDeviation;
        }

        /** 
         * Set the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
         * 
         * @param effectivePriceDeviation
         */
        public void setEffectivePriceDeviation(
                BigDecimal effectivePriceDeviation) {
            this.effectivePriceDeviation = effectivePriceDeviation;
        }

        /** 
         * Get the 'EffectiveDeviationType' attribute value. Effective Deviation Type
         * 
         * @return value
         */
        public EffectiveDeviationType getEffectiveDeviationType() {
            return effectiveDeviationType;
        }

        /** 
         * Set the 'EffectiveDeviationType' attribute value. Effective Deviation Type
         * 
         * @param effectiveDeviationType
         */
        public void setEffectiveDeviationType(
                EffectiveDeviationType effectiveDeviationType) {
            this.effectiveDeviationType = effectiveDeviationType;
        }

        /** 
         * Get the 'AmountAdjustment' attribute value. Element of Price Adjustment project
         * 
         * @return value
         */
        public BigDecimal getAmountAdjustment() {
            return amountAdjustment;
        }

        /** 
         * Set the 'AmountAdjustment' attribute value. Element of Price Adjustment project
         * 
         * @param amountAdjustment
         */
        public void setAmountAdjustment(BigDecimal amountAdjustment) {
            this.amountAdjustment = amountAdjustment;
        }

        /** 
         * Get the 'EffectivePriceDeviationAdjustment' attribute value. Element of Price Adjustment project
         * 
         * @return value
         */
        public BigDecimal getEffectivePriceDeviationAdjustment() {
            return effectivePriceDeviationAdjustment;
        }

        /** 
         * Set the 'EffectivePriceDeviationAdjustment' attribute value. Element of Price Adjustment project
         * 
         * @param effectivePriceDeviationAdjustment
         */
        public void setEffectivePriceDeviationAdjustment(
                BigDecimal effectivePriceDeviationAdjustment) {
            this.effectivePriceDeviationAdjustment = effectivePriceDeviationAdjustment;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="P"/>
         *     &lt;xs:enumeration value="A"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum EffectiveDeviationType implements Serializable {
            /** 
             * Percentage
             */
            P, /** 
                * Amout
                */
            A
        }
    }
    /** 
     * This is a collection of Taxes
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareComponentsTaxes" minOccurs="0">
     *         &lt;!-- Reference to inner class FareComponentsTaxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LegsTaxes" minOccurs="0">
     *         &lt;!-- Reference to inner class LegsTaxes -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Tax" minOccurs="0" maxOccurs="99">
     *         &lt;!-- Reference to inner class Tax -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:AirTaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="TotalTax" minOccurs="0">
     *         &lt;!-- Reference to inner class TotalTax -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Taxes implements Serializable
    {
        private FareComponentsTaxes fareComponentsTaxes;
        private LegsTaxes legsTaxes;
        private List<Tax> taxList = new ArrayList<Tax>();
        private List<AirTaxSummaryType> taxSummaryList = new ArrayList<AirTaxSummaryType>();
        private TotalTax totalTax;

        /** 
         * Get the 'FareComponentsTaxes' element value.
         * 
         * @return value
         */
        public FareComponentsTaxes getFareComponentsTaxes() {
            return fareComponentsTaxes;
        }

        /** 
         * Set the 'FareComponentsTaxes' element value.
         * 
         * @param fareComponentsTaxes
         */
        public void setFareComponentsTaxes(
                FareComponentsTaxes fareComponentsTaxes) {
            this.fareComponentsTaxes = fareComponentsTaxes;
        }

        /** 
         * Get the 'LegsTaxes' element value.
         * 
         * @return value
         */
        public LegsTaxes getLegsTaxes() {
            return legsTaxes;
        }

        /** 
         * Set the 'LegsTaxes' element value.
         * 
         * @param legsTaxes
         */
        public void setLegsTaxes(LegsTaxes legsTaxes) {
            this.legsTaxes = legsTaxes;
        }

        /** 
         * Get the list of 'Tax' element items.
         * 
         * @return list
         */
        public List<Tax> getTaxList() {
            return taxList;
        }

        /** 
         * Set the list of 'Tax' element items.
         * 
         * @param list
         */
        public void setTaxList(List<Tax> list) {
            taxList = list;
        }

        /** 
         * Get the list of 'TaxSummary' element items. Tax Summary Information
         * 
         * @return list
         */
        public List<AirTaxSummaryType> getTaxSummaryList() {
            return taxSummaryList;
        }

        /** 
         * Set the list of 'TaxSummary' element items. Tax Summary Information
         * 
         * @param list
         */
        public void setTaxSummaryList(List<AirTaxSummaryType> list) {
            taxSummaryList = list;
        }

        /** 
         * Get the 'TotalTax' element value.
         * 
         * @return value
         */
        public TotalTax getTotalTax() {
            return totalTax;
        }

        /** 
         * Set the 'TotalTax' element value.
         * 
         * @param totalTax
         */
        public void setTotalTax(TotalTax totalTax) {
            this.totalTax = totalTax;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponentsTaxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:FareComponentTaxesType" name="FareComponentTaxes" maxOccurs="99"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareComponentsTaxes implements Serializable
        {
            private List<FareComponentTaxesType> fareComponentTaxeList = new ArrayList<FareComponentTaxesType>();

            /** 
             * Get the list of 'FareComponentTaxes' element items.
             * 
             * @return list
             */
            public List<FareComponentTaxesType> getFareComponentTaxeList() {
                return fareComponentTaxeList;
            }

            /** 
             * Set the list of 'FareComponentTaxes' element items.
             * 
             * @param list
             */
            public void setFareComponentTaxeList(
                    List<FareComponentTaxesType> list) {
                fareComponentTaxeList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LegsTaxes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="LegTaxes" maxOccurs="99">
         *         &lt;!-- Reference to inner class LegTaxes -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LegsTaxes implements Serializable
        {
            private List<LegTaxes> legTaxeList = new ArrayList<LegTaxes>();

            /** 
             * Get the list of 'LegTaxes' element items.
             * 
             * @return list
             */
            public List<LegTaxes> getLegTaxeList() {
                return legTaxeList;
            }

            /** 
             * Set the list of 'LegTaxes' element items.
             * 
             * @param list
             */
            public void setLegTaxeList(List<LegTaxes> list) {
                legTaxeList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LegTaxes" maxOccurs="99">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:AirTaxType" name="Tax" maxOccurs="99"/>
             *       &lt;xs:element type="ns:AirTaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="unbounded"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" use="optional" name="Number"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class LegTaxes implements Serializable
            {
                private List<AirTaxType> taxList = new ArrayList<AirTaxType>();
                private List<AirTaxSummaryType> taxSummaryList = new ArrayList<AirTaxSummaryType>();
                private Integer number;

                /** 
                 * Get the list of 'Tax' element items. Any individual tax applied to the fare
                 * 
                 * @return list
                 */
                public List<AirTaxType> getTaxList() {
                    return taxList;
                }

                /** 
                 * Set the list of 'Tax' element items. Any individual tax applied to the fare
                 * 
                 * @param list
                 */
                public void setTaxList(List<AirTaxType> list) {
                    taxList = list;
                }

                /** 
                 * Get the list of 'TaxSummary' element items. Tax Summary Information
                 * 
                 * @return list
                 */
                public List<AirTaxSummaryType> getTaxSummaryList() {
                    return taxSummaryList;
                }

                /** 
                 * Set the list of 'TaxSummary' element items. Tax Summary Information
                 * 
                 * @param list
                 */
                public void setTaxSummaryList(List<AirTaxSummaryType> list) {
                    taxSummaryList = list;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public Integer getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(Integer number) {
                    this.number = number;
                }
            }
        }
        /** 
         * Any individual tax applied to the fare
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Tax" minOccurs="0" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:AirTaxType">
         *         &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAdjustment"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Tax extends AirTaxType implements Serializable
        {
            private BigDecimal amountAdjustment;

            /** 
             * Get the 'AmountAdjustment' attribute value. Element of Price Adjustment project
             * 
             * @return value
             */
            public BigDecimal getAmountAdjustment() {
                return amountAdjustment;
            }

            /** 
             * Set the 'AmountAdjustment' attribute value. Element of Price Adjustment project
             * 
             * @param amountAdjustment
             */
            public void setAmountAdjustment(BigDecimal amountAdjustment) {
                this.amountAdjustment = amountAdjustment;
            }
        }
        /** 
         * Total (summary) of taxes applied to the fare
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalTax" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:CurrencyAmountType">
         *         &lt;xs:attribute type="xs:decimal" use="optional" name="AmountAdjustment"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TotalTax extends CurrencyAmountType implements
            Serializable
        {
            private BigDecimal amountAdjustment;

            /** 
             * Get the 'AmountAdjustment' attribute value. Element of Price Adjustment project
             * 
             * @return value
             */
            public BigDecimal getAmountAdjustment() {
                return amountAdjustment;
            }

            /** 
             * Set the 'AmountAdjustment' attribute value. Element of Price Adjustment project
             * 
             * @param amountAdjustment
             */
            public void setAmountAdjustment(BigDecimal amountAdjustment) {
                this.amountAdjustment = amountAdjustment;
            }
        }
    }
    /** 
     * This is a collection of Fees
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Fees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:AirFeeType" name="Fee" maxOccurs="9"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Fees implements Serializable
    {
        private List<AirFeeType> feeList = new ArrayList<AirFeeType>();

        /** 
         * Get the list of 'Fee' element items. Any additional fee incurred by the passenger but not shown on the ticket.  
         * 
         * @return list
         */
        public List<AirFeeType> getFeeList() {
            return feeList;
        }

        /** 
         * Set the list of 'Fee' element items. Any additional fee incurred by the passenger but not shown on the ticket.  
         * 
         * @param list
         */
        public void setFeeList(List<AirFeeType> list) {
            feeList = list;
        }
    }
    /** 
     * This is a collection of ob Fees
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OBFees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:OBFeeType" name="OBFee" minOccurs="0" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:decimal" use="optional" name="TTypeAmount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OBFees implements Serializable
    {
        private List<OBFeeType> OBFeeList = new ArrayList<OBFeeType>();
        private BigDecimal TTypeAmount;

        /** 
         * Get the list of 'OBFee' element items. OB fees
         * 
         * @return list
         */
        public List<OBFeeType> getOBFeeList() {
            return OBFeeList;
        }

        /** 
         * Set the list of 'OBFee' element items. OB fees
         * 
         * @param list
         */
        public void setOBFeeList(List<OBFeeType> list) {
            OBFeeList = list;
        }

        /** 
         * Get the 'TTypeAmount' attribute value. Total T-type OB Fee
         * 
         * @return value
         */
        public BigDecimal getTTypeAmount() {
            return TTypeAmount;
        }

        /** 
         * Set the 'TTypeAmount' attribute value. Total T-type OB Fee
         * 
         * @param TTypeAmount
         */
        public void setTTypeAmount(BigDecimal TTypeAmount) {
            this.TTypeAmount = TTypeAmount;
        }
    }
    /** 
     * Reissue information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueInfoList" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:ReissueInfoType" name="ReissueInfo" maxOccurs="unbounded"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ReissueInfoList implements Serializable
    {
        private List<ReissueInfoType> reissueInfoList = new ArrayList<ReissueInfoType>();

        /** 
         * Get the list of 'ReissueInfo' element items. Reissue Info
         * 
         * @return list
         */
        public List<ReissueInfoType> getReissueInfoList() {
            return reissueInfoList;
        }

        /** 
         * Set the list of 'ReissueInfo' element items. Reissue Info
         * 
         * @param list
         */
        public void setReissueInfoList(List<ReissueInfoType> list) {
            reissueInfoList = list;
        }
    }
    /** 
     * Penalties information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PenaltiesInfo" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Penalty" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Penalty -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PenaltiesInfo implements Serializable
    {
        private List<Penalty> penaltyList = new ArrayList<Penalty>();

        /** 
         * Get the list of 'Penalty' element items.
         * 
         * @return list
         */
        public List<Penalty> getPenaltyList() {
            return penaltyList;
        }

        /** 
         * Set the list of 'Penalty' element items.
         * 
         * @param list
         */
        public void setPenaltyList(List<Penalty> list) {
            penaltyList = list;
        }
        /** 
         * Penalty Info
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Penalty" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Cat16TextOnly" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Cat16TextOnly -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute use="optional" name="Type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute use="optional" name="Applicability">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Applicability -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Refundable"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Changeable"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ConditionsApply"/>
         *     &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Cat16Info"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Penalty implements Serializable
        {
            private List<Cat16TextOnly> cat16TextOnlyList = new ArrayList<Cat16TextOnly>();
            private Type type;
            private Applicability applicability;
            private Boolean refundable;
            private Boolean changeable;
            private Boolean conditionsApply;
            private CurrencyAmountGroup currencyAmountGroup;
            private Boolean cat16Info;

            /** 
             * Get the list of 'Cat16TextOnly' element items.
             * 
             * @return list
             */
            public List<Cat16TextOnly> getCat16TextOnlyList() {
                return cat16TextOnlyList;
            }

            /** 
             * Set the list of 'Cat16TextOnly' element items.
             * 
             * @param list
             */
            public void setCat16TextOnlyList(List<Cat16TextOnly> list) {
                cat16TextOnlyList = list;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }

            /** 
             * Get the 'Applicability' attribute value.
             * 
             * @return value
             */
            public Applicability getApplicability() {
                return applicability;
            }

            /** 
             * Set the 'Applicability' attribute value.
             * 
             * @param applicability
             */
            public void setApplicability(Applicability applicability) {
                this.applicability = applicability;
            }

            /** 
             * Get the 'Refundable' attribute value.
             * 
             * @return value
             */
            public Boolean getRefundable() {
                return refundable;
            }

            /** 
             * Set the 'Refundable' attribute value.
             * 
             * @param refundable
             */
            public void setRefundable(Boolean refundable) {
                this.refundable = refundable;
            }

            /** 
             * Get the 'Changeable' attribute value.
             * 
             * @return value
             */
            public Boolean getChangeable() {
                return changeable;
            }

            /** 
             * Set the 'Changeable' attribute value.
             * 
             * @param changeable
             */
            public void setChangeable(Boolean changeable) {
                this.changeable = changeable;
            }

            /** 
             * Get the 'ConditionsApply' attribute value.
             * 
             * @return value
             */
            public Boolean getConditionsApply() {
                return conditionsApply;
            }

            /** 
             * Set the 'ConditionsApply' attribute value.
             * 
             * @param conditionsApply
             */
            public void setConditionsApply(Boolean conditionsApply) {
                this.conditionsApply = conditionsApply;
            }

            /** 
             * Get the 'CurrencyAmountGroup' attributeGroup value. The penalty charge defined a fee in terms of its amount, currency and decimal laces.
             * 
             * @return value
             */
            public CurrencyAmountGroup getCurrencyAmountGroup() {
                return currencyAmountGroup;
            }

            /** 
             * Set the 'CurrencyAmountGroup' attributeGroup value. The penalty charge defined a fee in terms of its amount, currency and decimal laces.
             * 
             * @param currencyAmountGroup
             */
            public void setCurrencyAmountGroup(
                    CurrencyAmountGroup currencyAmountGroup) {
                this.currencyAmountGroup = currencyAmountGroup;
            }

            /** 
             * Get the 'Cat16Info' attribute value.
             * 
             * @return value
             */
            public Boolean getCat16Info() {
                return cat16Info;
            }

            /** 
             * Set the 'Cat16Info' attribute value.
             * 
             * @param cat16Info
             */
            public void setCat16Info(Boolean cat16Info) {
                this.cat16Info = cat16Info;
            }
            /** 
             * Missing Data
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Cat16TextOnly" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="FareBasisCode"/>
             *     &lt;xs:attribute type="xs:integer" use="required" name="FareComponentID"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Cat16TextOnly implements Serializable
            {
                private String fareBasisCode;
                private BigInteger fareComponentID;

                /** 
                 * Get the 'FareBasisCode' attribute value. Fare basis code
                 * 
                 * @return value
                 */
                public String getFareBasisCode() {
                    return fareBasisCode;
                }

                /** 
                 * Set the 'FareBasisCode' attribute value. Fare basis code
                 * 
                 * @param fareBasisCode
                 */
                public void setFareBasisCode(String fareBasisCode) {
                    this.fareBasisCode = fareBasisCode;
                }

                /** 
                 * Get the 'FareComponentID' attribute value. Fare component Id
                 * 
                 * @return value
                 */
                public BigInteger getFareComponentID() {
                    return fareComponentID;
                }

                /** 
                 * Set the 'FareComponentID' attribute value. Fare component Id
                 * 
                 * @param fareComponentID
                 */
                public void setFareComponentID(BigInteger fareComponentID) {
                    this.fareComponentID = fareComponentID;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="Refund"/>
             *     &lt;xs:enumeration value="Exchange"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                REFUND("Refund"), EXCHANGE("Exchange");
                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Type convert(String value) {
                    for (Type inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="After"/>
             *     &lt;xs:enumeration value="Before"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Applicability implements Serializable {
                AFTER("After"), BEFORE("Before");
                private final String value;

                private Applicability(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Applicability convert(String value) {
                    for (Applicability inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:SurchargesType" name="Surcharges" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="Legs" minOccurs="0">
     *         &lt;!-- Reference to inner class Legs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareComponents" minOccurs="0">
     *         &lt;!-- Reference to inner class FareComponents -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FareMessagesType" name="Messages" minOccurs="0"/>
     *       &lt;xs:element type="ns:BaggageInformationListType" name="BaggageInformationList" minOccurs="0"/>
     *       &lt;xs:element name="SellingFareDataList" minOccurs="0">
     *         &lt;!-- Reference to inner class SellingFareDataList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CommissionData" minOccurs="0">
     *         &lt;!-- Reference to inner class CommissionData -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:PointsRedemptionType" name="PointsRedemption" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element name="SeatSelectionList" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class SeatSelectionList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PriorityBoardingList" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class PriorityBoardingList -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private List<SurchargesType> surchargeList = new ArrayList<SurchargesType>();
        private Legs legs;
        private FareComponents fareComponents;
        private FareMessagesType messages;
        private BaggageInformationListType baggageInformationList;
        private SellingFareDataList sellingFareDataList;
        private CommissionData commissionData;
        private PointsRedemptionType pointsRedemption;
        private SeatSelectionList seatSelectionList;
        private PriorityBoardingList priorityBoardingList;

        /** 
         * Get the list of 'Surcharges' element items. Surcharge information
         * 
         * @return list
         */
        public List<SurchargesType> getSurchargeList() {
            return surchargeList;
        }

        /** 
         * Set the list of 'Surcharges' element items. Surcharge information
         * 
         * @param list
         */
        public void setSurchargeList(List<SurchargesType> list) {
            surchargeList = list;
        }

        /** 
         * Get the 'Legs' element value.
         * 
         * @return value
         */
        public Legs getLegs() {
            return legs;
        }

        /** 
         * Set the 'Legs' element value.
         * 
         * @param legs
         */
        public void setLegs(Legs legs) {
            this.legs = legs;
        }

        /** 
         * Get the 'FareComponents' element value.
         * 
         * @return value
         */
        public FareComponents getFareComponents() {
            return fareComponents;
        }

        /** 
         * Set the 'FareComponents' element value.
         * 
         * @param fareComponents
         */
        public void setFareComponents(FareComponents fareComponents) {
            this.fareComponents = fareComponents;
        }

        /** 
         * Get the 'Messages' element value.
         * 
         * @return value
         */
        public FareMessagesType getMessages() {
            return messages;
        }

        /** 
         * Set the 'Messages' element value.
         * 
         * @param messages
         */
        public void setMessages(FareMessagesType messages) {
            this.messages = messages;
        }

        /** 
         * Get the 'BaggageInformationList' element value.
         * 
         * @return value
         */
        public BaggageInformationListType getBaggageInformationList() {
            return baggageInformationList;
        }

        /** 
         * Set the 'BaggageInformationList' element value.
         * 
         * @param baggageInformationList
         */
        public void setBaggageInformationList(
                BaggageInformationListType baggageInformationList) {
            this.baggageInformationList = baggageInformationList;
        }

        /** 
         * Get the 'SellingFareDataList' element value.
         * 
         * @return value
         */
        public SellingFareDataList getSellingFareDataList() {
            return sellingFareDataList;
        }

        /** 
         * Set the 'SellingFareDataList' element value.
         * 
         * @param sellingFareDataList
         */
        public void setSellingFareDataList(
                SellingFareDataList sellingFareDataList) {
            this.sellingFareDataList = sellingFareDataList;
        }

        /** 
         * Get the 'CommissionData' element value.
         * 
         * @return value
         */
        public CommissionData getCommissionData() {
            return commissionData;
        }

        /** 
         * Set the 'CommissionData' element value.
         * 
         * @param commissionData
         */
        public void setCommissionData(CommissionData commissionData) {
            this.commissionData = commissionData;
        }

        /** 
         * Get the 'PointsRedemption' element value.
         * 
         * @return value
         */
        public PointsRedemptionType getPointsRedemption() {
            return pointsRedemption;
        }

        /** 
         * Set the 'PointsRedemption' element value.
         * 
         * @param pointsRedemption
         */
        public void setPointsRedemption(PointsRedemptionType pointsRedemption) {
            this.pointsRedemption = pointsRedemption;
        }

        /** 
         * Get the 'SeatSelectionList' element value.
         * 
         * @return value
         */
        public SeatSelectionList getSeatSelectionList() {
            return seatSelectionList;
        }

        /** 
         * Set the 'SeatSelectionList' element value.
         * 
         * @param seatSelectionList
         */
        public void setSeatSelectionList(SeatSelectionList seatSelectionList) {
            this.seatSelectionList = seatSelectionList;
        }

        /** 
         * Get the 'PriorityBoardingList' element value.
         * 
         * @return value
         */
        public PriorityBoardingList getPriorityBoardingList() {
            return priorityBoardingList;
        }

        /** 
         * Set the 'PriorityBoardingList' element value.
         * 
         * @param priorityBoardingList
         */
        public void setPriorityBoardingList(
                PriorityBoardingList priorityBoardingList) {
            this.priorityBoardingList = priorityBoardingList;
        }
        /** 
         * This is a collection of Leg Information
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Legs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Leg" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Leg -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Legs implements Serializable
        {
            private List<Leg> legList = new ArrayList<Leg>();

            /** 
             * Get the list of 'Leg' element items.
             * 
             * @return list
             */
            public List<Leg> getLegList() {
                return legList;
            }

            /** 
             * Set the list of 'Leg' element items.
             * 
             * @param list
             */
            public void setLegList(List<Leg> list) {
                legList = list;
            }
            /** 
             * Leg Information
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Leg" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="BaseFare">
             *         &lt;xs:complexType>
             *           &lt;xs:complexContent>
             *             &lt;xs:extension base="ns:CurrencyAmountType">
             *               &lt;xs:attribute type="xs:decimal" use="optional" name="AdjustedAmount"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:complexContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="EquivFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;!-- Reference to inner class Taxes -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalFare">
             *         &lt;xs:complexType>
             *           &lt;xs:complexContent>
             *             &lt;xs:extension base="ns:CurrencyAmountType">
             *               &lt;xs:attribute type="xs:decimal" use="optional" name="AdjustedAmount"/>
             *             &lt;/xs:extension>
             *           &lt;/xs:complexContent>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element name="TotalMileage" minOccurs="0">
             *         &lt;!-- Reference to inner class TotalMileage -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:PointsRedemptionType" name="PointsRedemption" minOccurs="0" maxOccurs="1"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" use="optional" name="Number"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="FareStatus"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Leg implements Serializable
            {
                private CurrencyAmountType baseFareCurrencyAmountType;
                private BigDecimal baseFareAdjustedAmount;
                private EquivFare equivFare;
                private Taxes taxes;
                private CurrencyAmountType totalFareCurrencyAmountType;
                private BigDecimal totalFareAdjustedAmount;
                private TotalMileage totalMileage;
                private PointsRedemptionType pointsRedemption;
                private Integer number;
                private String fareStatus;

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public CurrencyAmountType getBaseFareCurrencyAmountType() {
                    return baseFareCurrencyAmountType;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param baseFareCurrencyAmountType
                 */
                public void setBaseFareCurrencyAmountType(
                        CurrencyAmountType baseFareCurrencyAmountType) {
                    this.baseFareCurrencyAmountType = baseFareCurrencyAmountType;
                }

                /** 
                 * Get the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                 * 
                 * @return value
                 */
                public BigDecimal getBaseFareAdjustedAmount() {
                    return baseFareAdjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                 * 
                 * @param baseFareAdjustedAmount
                 */
                public void setBaseFareAdjustedAmount(
                        BigDecimal baseFareAdjustedAmount) {
                    this.baseFareAdjustedAmount = baseFareAdjustedAmount;
                }

                /** 
                 * Get the 'EquivFare' element value.
                 * 
                 * @return value
                 */
                public EquivFare getEquivFare() {
                    return equivFare;
                }

                /** 
                 * Set the 'EquivFare' element value.
                 * 
                 * @param equivFare
                 */
                public void setEquivFare(EquivFare equivFare) {
                    this.equivFare = equivFare;
                }

                /** 
                 * Get the 'Taxes' element value.
                 * 
                 * @return value
                 */
                public Taxes getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Taxes' element value.
                 * 
                 * @param taxes
                 */
                public void setTaxes(Taxes taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the extension value.
                 * 
                 * @return value
                 */
                public CurrencyAmountType getTotalFareCurrencyAmountType() {
                    return totalFareCurrencyAmountType;
                }

                /** 
                 * Set the extension value.
                 * 
                 * @param totalFareCurrencyAmountType
                 */
                public void setTotalFareCurrencyAmountType(
                        CurrencyAmountType totalFareCurrencyAmountType) {
                    this.totalFareCurrencyAmountType = totalFareCurrencyAmountType;
                }

                /** 
                 * Get the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                 * 
                 * @return value
                 */
                public BigDecimal getTotalFareAdjustedAmount() {
                    return totalFareAdjustedAmount;
                }

                /** 
                 * Set the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                 * 
                 * @param totalFareAdjustedAmount
                 */
                public void setTotalFareAdjustedAmount(
                        BigDecimal totalFareAdjustedAmount) {
                    this.totalFareAdjustedAmount = totalFareAdjustedAmount;
                }

                /** 
                 * Get the 'TotalMileage' element value.
                 * 
                 * @return value
                 */
                public TotalMileage getTotalMileage() {
                    return totalMileage;
                }

                /** 
                 * Set the 'TotalMileage' element value.
                 * 
                 * @param totalMileage
                 */
                public void setTotalMileage(TotalMileage totalMileage) {
                    this.totalMileage = totalMileage;
                }

                /** 
                 * Get the 'PointsRedemption' element value.
                 * 
                 * @return value
                 */
                public PointsRedemptionType getPointsRedemption() {
                    return pointsRedemption;
                }

                /** 
                 * Set the 'PointsRedemption' element value.
                 * 
                 * @param pointsRedemption
                 */
                public void setPointsRedemption(
                        PointsRedemptionType pointsRedemption) {
                    this.pointsRedemption = pointsRedemption;
                }

                /** 
                 * Get the 'Number' attribute value.
                 * 
                 * @return value
                 */
                public Integer getNumber() {
                    return number;
                }

                /** 
                 * Set the 'Number' attribute value.
                 * 
                 * @param number
                 */
                public void setNumber(Integer number) {
                    this.number = number;
                }

                /** 
                 * Get the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status.
                 * 
                 * @return value
                 */
                public String getFareStatus() {
                    return fareStatus;
                }

                /** 
                 * Set the 'FareStatus' attribute value. Detailed reason why fare could not be returned (when FareReturned="false"). "A" means "Class is not available", "O" - "Class is not offered", "F" - "No fare found or applicable", "N" - unknown status.
                 * 
                 * @param fareStatus
                 */
                public void setFareStatus(String fareStatus) {
                    this.fareStatus = fareStatus;
                }
                /** 
                 * Price of the inventory excluding taxes and fees in the payable currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:complexContent>
                 *       &lt;xs:extension base="ns:CurrencyAmountType">
                 *         &lt;xs:attribute type="xs:decimal" use="optional" name="AdjustedAmount"/>
                 *         &lt;xs:attribute type="xs:decimal" use="optional" name="EffectivePriceDeviation"/>
                 *         &lt;xs:attribute type="xs:decimal" use="optional" name="AdjustedEffectivePriceDeviation"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:complexContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivFare extends CurrencyAmountType
                    implements Serializable
                {
                    private BigDecimal adjustedAmount;
                    private BigDecimal effectivePriceDeviation;
                    private BigDecimal adjustedEffectivePriceDeviation;

                    /** 
                     * Get the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                     * 
                     * @return value
                     */
                    public BigDecimal getAdjustedAmount() {
                        return adjustedAmount;
                    }

                    /** 
                     * Set the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                     * 
                     * @param adjustedAmount
                     */
                    public void setAdjustedAmount(BigDecimal adjustedAmount) {
                        this.adjustedAmount = adjustedAmount;
                    }

                    /** 
                     * Get the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
                     * 
                     * @return value
                     */
                    public BigDecimal getEffectivePriceDeviation() {
                        return effectivePriceDeviation;
                    }

                    /** 
                     * Set the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
                     * 
                     * @param effectivePriceDeviation
                     */
                    public void setEffectivePriceDeviation(
                            BigDecimal effectivePriceDeviation) {
                        this.effectivePriceDeviation = effectivePriceDeviation;
                    }

                    /** 
                     * Get the 'AdjustedEffectivePriceDeviation' attribute value. Element of Price Adjustment project
                     * 
                     * @return value
                     */
                    public BigDecimal getAdjustedEffectivePriceDeviation() {
                        return adjustedEffectivePriceDeviation;
                    }

                    /** 
                     * Set the 'AdjustedEffectivePriceDeviation' attribute value. Element of Price Adjustment project
                     * 
                     * @param adjustedEffectivePriceDeviation
                     */
                    public void setAdjustedEffectivePriceDeviation(
                            BigDecimal adjustedEffectivePriceDeviation) {
                        this.adjustedEffectivePriceDeviation = adjustedEffectivePriceDeviation;
                    }
                }
                /** 
                 * This is a collection of Taxes
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Taxes" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:sequence>
                 *       &lt;xs:element name="Tax">
                 *         &lt;xs:complexType>
                 *           &lt;xs:complexContent>
                 *             &lt;xs:extension base="ns:AirTaxType">
                 *               &lt;xs:attribute type="xs:decimal" use="optional" name="AdjustedAmount"/>
                 *             &lt;/xs:extension>
                 *           &lt;/xs:complexContent>
                 *         &lt;/xs:complexType>
                 *       &lt;/xs:element>
                 *     &lt;/xs:sequence>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Taxes implements Serializable
                {
                    private AirTaxType taxAirTaxType;
                    private BigDecimal taxAdjustedAmount;

                    /** 
                     * Get the extension value.
                     * 
                     * @return value
                     */
                    public AirTaxType getTaxAirTaxType() {
                        return taxAirTaxType;
                    }

                    /** 
                     * Set the extension value.
                     * 
                     * @param taxAirTaxType
                     */
                    public void setTaxAirTaxType(AirTaxType taxAirTaxType) {
                        this.taxAirTaxType = taxAirTaxType;
                    }

                    /** 
                     * Get the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                     * 
                     * @return value
                     */
                    public BigDecimal getTaxAdjustedAmount() {
                        return taxAdjustedAmount;
                    }

                    /** 
                     * Set the 'AdjustedAmount' attribute value. Element of Price Adjustment project
                     * 
                     * @param taxAdjustedAmount
                     */
                    public void setTaxAdjustedAmount(
                            BigDecimal taxAdjustedAmount) {
                        this.taxAdjustedAmount = taxAdjustedAmount;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalMileage" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Amount"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TotalMileage implements Serializable
                {
                    private String amount;

                    /** 
                     * Get the 'Amount' attribute value.
                     * 
                     * @return value
                     */
                    public String getAmount() {
                        return amount;
                    }

                    /** 
                     * Set the 'Amount' attribute value.
                     * 
                     * @param amount
                     */
                    public void setAmount(String amount) {
                        this.amount = amount;
                    }
                }
            }
        }
        /** 
         * A collection of additional information for each Fare Component
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponents" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="FareComponent" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class FareComponent -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareComponents implements Serializable
        {
            private List<FareComponent> fareComponentList = new ArrayList<FareComponent>();

            /** 
             * Get the list of 'FareComponent' element items.
             * 
             * @return list
             */
            public List<FareComponent> getFareComponentList() {
                return fareComponentList;
            }

            /** 
             * Set the list of 'FareComponent' element items.
             * 
             * @param list
             */
            public void setFareComponentList(List<FareComponent> list) {
                fareComponentList = list;
            }
            /** 
             * Subtotal pricing summary for Fare Component.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareComponent" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element type="ns:CurrencyAmountType" name="BaseFare" minOccurs="0"/>
             *       &lt;xs:element name="EquivFare" minOccurs="0">
             *         &lt;!-- Reference to inner class EquivFare -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="Taxes" minOccurs="0">
             *         &lt;xs:complexType>
             *           &lt;xs:sequence>
             *             &lt;xs:element type="ns:AirTaxType" name="Tax"/>
             *           &lt;/xs:sequence>
             *         &lt;/xs:complexType>
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:CurrencyAmountType" name="TotalFare" minOccurs="0"/>
             *       &lt;xs:element name="Segment" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="HandlingMarkupDetail" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class HandlingMarkupDetail -->
             *       &lt;/xs:element>
             *       &lt;xs:element name="FareRetailerRule" minOccurs="0" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class FareRetailerRule -->
             *       &lt;/xs:element>
             *       &lt;xs:element type="ns:BrandFeatureRefType" name="BrandFeatureRef" minOccurs="0" maxOccurs="unbounded"/>
             *       &lt;xs:element type="ns:PointsRedemptionType" name="PointsRedemption" minOccurs="0" maxOccurs="1"/>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" name="ProgramID"/>
             *     &lt;xs:attribute type="xs:string" name="ProgramCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="ProgramDescription"/>
             *     &lt;xs:attribute type="xs:string" name="ProgramSystemCode"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="BrandID"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="BrandName"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class FareComponent implements Serializable
            {
                private CurrencyAmountType baseFare;
                private EquivFare equivFare;
                private AirTaxType taxes;
                private CurrencyAmountType totalFare;
                private List<Segment> segmentList = new ArrayList<Segment>();
                private List<HandlingMarkupDetail> handlingMarkupDetailList = new ArrayList<HandlingMarkupDetail>();
                private List<FareRetailerRule> fareRetailerRuleList = new ArrayList<FareRetailerRule>();
                private List<BrandFeatureRefType> brandFeatureRefList = new ArrayList<BrandFeatureRefType>();
                private PointsRedemptionType pointsRedemption;
                private String programID;
                private String programCode;
                private String programDescription;
                private String programSystemCode;
                private String brandID;
                private String brandName;

                /** 
                 * Get the 'BaseFare' element value. Price of the inventory excluding taxes and fees.
                 * 
                 * @return value
                 */
                public CurrencyAmountType getBaseFare() {
                    return baseFare;
                }

                /** 
                 * Set the 'BaseFare' element value. Price of the inventory excluding taxes and fees.
                 * 
                 * @param baseFare
                 */
                public void setBaseFare(CurrencyAmountType baseFare) {
                    this.baseFare = baseFare;
                }

                /** 
                 * Get the 'EquivFare' element value.
                 * 
                 * @return value
                 */
                public EquivFare getEquivFare() {
                    return equivFare;
                }

                /** 
                 * Set the 'EquivFare' element value.
                 * 
                 * @param equivFare
                 */
                public void setEquivFare(EquivFare equivFare) {
                    this.equivFare = equivFare;
                }

                /** 
                 * Get the 'Tax' element value. Any individual tax applied to the fare
                 * 
                 * @return value
                 */
                public AirTaxType getTaxes() {
                    return taxes;
                }

                /** 
                 * Set the 'Tax' element value. Any individual tax applied to the fare
                 * 
                 * @param taxes
                 */
                public void setTaxes(AirTaxType taxes) {
                    this.taxes = taxes;
                }

                /** 
                 * Get the 'TotalFare' element value. The total price that the passenger would pay (includes fare, taxes, fees)
                 * 
                 * @return value
                 */
                public CurrencyAmountType getTotalFare() {
                    return totalFare;
                }

                /** 
                 * Set the 'TotalFare' element value. The total price that the passenger would pay (includes fare, taxes, fees)
                 * 
                 * @param totalFare
                 */
                public void setTotalFare(CurrencyAmountType totalFare) {
                    this.totalFare = totalFare;
                }

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the list of 'HandlingMarkupDetail' element items.
                 * 
                 * @return list
                 */
                public List<HandlingMarkupDetail> getHandlingMarkupDetailList() {
                    return handlingMarkupDetailList;
                }

                /** 
                 * Set the list of 'HandlingMarkupDetail' element items.
                 * 
                 * @param list
                 */
                public void setHandlingMarkupDetailList(
                        List<HandlingMarkupDetail> list) {
                    handlingMarkupDetailList = list;
                }

                /** 
                 * Get the list of 'FareRetailerRule' element items.
                 * 
                 * @return list
                 */
                public List<FareRetailerRule> getFareRetailerRuleList() {
                    return fareRetailerRuleList;
                }

                /** 
                 * Set the list of 'FareRetailerRule' element items.
                 * 
                 * @param list
                 */
                public void setFareRetailerRuleList(List<FareRetailerRule> list) {
                    fareRetailerRuleList = list;
                }

                /** 
                 * Get the list of 'BrandFeatureRef' element items. References to brand feature items in the final list
                 * 
                 * @return list
                 */
                public List<BrandFeatureRefType> getBrandFeatureRefList() {
                    return brandFeatureRefList;
                }

                /** 
                 * Set the list of 'BrandFeatureRef' element items. References to brand feature items in the final list
                 * 
                 * @param list
                 */
                public void setBrandFeatureRefList(
                        List<BrandFeatureRefType> list) {
                    brandFeatureRefList = list;
                }

                /** 
                 * Get the 'PointsRedemption' element value.
                 * 
                 * @return value
                 */
                public PointsRedemptionType getPointsRedemption() {
                    return pointsRedemption;
                }

                /** 
                 * Set the 'PointsRedemption' element value.
                 * 
                 * @param pointsRedemption
                 */
                public void setPointsRedemption(
                        PointsRedemptionType pointsRedemption) {
                    this.pointsRedemption = pointsRedemption;
                }

                /** 
                 * Get the 'ProgramID' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramID() {
                    return programID;
                }

                /** 
                 * Set the 'ProgramID' attribute value.
                 * 
                 * @param programID
                 */
                public void setProgramID(String programID) {
                    this.programID = programID;
                }

                /** 
                 * Get the 'ProgramCode' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramCode() {
                    return programCode;
                }

                /** 
                 * Set the 'ProgramCode' attribute value.
                 * 
                 * @param programCode
                 */
                public void setProgramCode(String programCode) {
                    this.programCode = programCode;
                }

                /** 
                 * Get the 'ProgramDescription' attribute value. Used to indicate program description
                 * 
                 * @return value
                 */
                public String getProgramDescription() {
                    return programDescription;
                }

                /** 
                 * Set the 'ProgramDescription' attribute value. Used to indicate program description
                 * 
                 * @param programDescription
                 */
                public void setProgramDescription(String programDescription) {
                    this.programDescription = programDescription;
                }

                /** 
                 * Get the 'ProgramSystemCode' attribute value.
                 * 
                 * @return value
                 */
                public String getProgramSystemCode() {
                    return programSystemCode;
                }

                /** 
                 * Set the 'ProgramSystemCode' attribute value.
                 * 
                 * @param programSystemCode
                 */
                public void setProgramSystemCode(String programSystemCode) {
                    this.programSystemCode = programSystemCode;
                }

                /** 
                 * Get the 'BrandID' attribute value. Used to indicate brand code
                 * 
                 * @return value
                 */
                public String getBrandID() {
                    return brandID;
                }

                /** 
                 * Set the 'BrandID' attribute value. Used to indicate brand code
                 * 
                 * @param brandID
                 */
                public void setBrandID(String brandID) {
                    this.brandID = brandID;
                }

                /** 
                 * Get the 'BrandName' attribute value. Used to indicate brand name
                 * 
                 * @return value
                 */
                public String getBrandName() {
                    return brandName;
                }

                /** 
                 * Set the 'BrandName' attribute value. Used to indicate brand name
                 * 
                 * @param brandName
                 */
                public void setBrandName(String brandName) {
                    this.brandName = brandName;
                }
                /** 
                 * Price of the inventory excluding taxes and fees in the payable currency.
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquivFare" minOccurs="0">
                 *   &lt;xs:complexType>
                 *     &lt;xs:complexContent>
                 *       &lt;xs:extension base="ns:CurrencyAmountType">
                 *         &lt;xs:attribute type="xs:decimal" use="optional" name="EffectivePriceDeviation"/>
                 *       &lt;/xs:extension>
                 *     &lt;/xs:complexContent>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class EquivFare extends CurrencyAmountType
                    implements Serializable
                {
                    private BigDecimal effectivePriceDeviation;

                    /** 
                     * Get the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
                     * 
                     * @return value
                     */
                    public BigDecimal getEffectivePriceDeviation() {
                        return effectivePriceDeviation;
                    }

                    /** 
                     * Set the 'EffectivePriceDeviation' attribute value. Effective Price Deviation
                     * 
                     * @param effectivePriceDeviation
                     */
                    public void setEffectivePriceDeviation(
                            BigDecimal effectivePriceDeviation) {
                        this.effectivePriceDeviation = effectivePriceDeviation;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:int" use="required" name="LegIndex"/>
                 *     &lt;xs:attribute type="xs:int" use="required" name="FlightIndex"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private Integer legIndex;
                    private Integer flightIndex;

                    /** 
                     * Get the 'LegIndex' attribute value. Refers to OriginDestinationOption of current itinerary
                     * 
                     * @return value
                     */
                    public Integer getLegIndex() {
                        return legIndex;
                    }

                    /** 
                     * Set the 'LegIndex' attribute value. Refers to OriginDestinationOption of current itinerary
                     * 
                     * @param legIndex
                     */
                    public void setLegIndex(Integer legIndex) {
                        this.legIndex = legIndex;
                    }

                    /** 
                     * Get the 'FlightIndex' attribute value. Refers to FlightSegment within OriginDestinationOption of current itinerary
                     * 
                     * @return value
                     */
                    public Integer getFlightIndex() {
                        return flightIndex;
                    }

                    /** 
                     * Set the 'FlightIndex' attribute value. Refers to FlightSegment within OriginDestinationOption of current itinerary
                     * 
                     * @param flightIndex
                     */
                    public void setFlightIndex(Integer flightIndex) {
                        this.flightIndex = flightIndex;
                    }
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="HandlingMarkupDetail" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupHandlingFeeAppID"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupTypeCode"/>
                 *     &lt;xs:attribute type="xs:decimal" use="optional" name="FareAmountAfterMarkup"/>
                 *     &lt;xs:attribute type="xs:decimal" use="optional" name="MarkupAmount"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="AmountCurrency"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="MarkupRuleSourcePCC"/>
                 *     &lt;xs:attribute type="xs:unsignedLong" use="optional" name="MarkupRuleItemNumber"/>
                 *     &lt;xs:attribute type="xs:string" use="optional" name="RetailerRuleQualifier"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class HandlingMarkupDetail implements
                    Serializable
                {
                    private String markupHandlingFeeAppID;
                    private String markupTypeCode;
                    private BigDecimal fareAmountAfterMarkup;
                    private BigDecimal markupAmount;
                    private String amountCurrency;
                    private String markupRuleSourcePCC;
                    private String markupRuleItemNumber;
                    private String retailerRuleQualifier;

                    /** 
                     * Get the 'MarkupHandlingFeeAppID' attribute value. Markup/Handling fee Application ID
                     * 
                     * @return value
                     */
                    public String getMarkupHandlingFeeAppID() {
                        return markupHandlingFeeAppID;
                    }

                    /** 
                     * Set the 'MarkupHandlingFeeAppID' attribute value. Markup/Handling fee Application ID
                     * 
                     * @param markupHandlingFeeAppID
                     */
                    public void setMarkupHandlingFeeAppID(
                            String markupHandlingFeeAppID) {
                        this.markupHandlingFeeAppID = markupHandlingFeeAppID;
                    }

                    /** 
                     * Get the 'MarkupTypeCode' attribute value. Markup type code, reserved for future extension
                     * 
                     * @return value
                     */
                    public String getMarkupTypeCode() {
                        return markupTypeCode;
                    }

                    /** 
                     * Set the 'MarkupTypeCode' attribute value. Markup type code, reserved for future extension
                     * 
                     * @param markupTypeCode
                     */
                    public void setMarkupTypeCode(String markupTypeCode) {
                        this.markupTypeCode = markupTypeCode;
                    }

                    /** 
                     * Get the 'FareAmountAfterMarkup' attribute value. Fare Amount after markup
                     * 
                     * @return value
                     */
                    public BigDecimal getFareAmountAfterMarkup() {
                        return fareAmountAfterMarkup;
                    }

                    /** 
                     * Set the 'FareAmountAfterMarkup' attribute value. Fare Amount after markup
                     * 
                     * @param fareAmountAfterMarkup
                     */
                    public void setFareAmountAfterMarkup(
                            BigDecimal fareAmountAfterMarkup) {
                        this.fareAmountAfterMarkup = fareAmountAfterMarkup;
                    }

                    /** 
                     * Get the 'MarkupAmount' attribute value. Markup Amount
                     * 
                     * @return value
                     */
                    public BigDecimal getMarkupAmount() {
                        return markupAmount;
                    }

                    /** 
                     * Set the 'MarkupAmount' attribute value. Markup Amount
                     * 
                     * @param markupAmount
                     */
                    public void setMarkupAmount(BigDecimal markupAmount) {
                        this.markupAmount = markupAmount;
                    }

                    /** 
                     * Get the 'AmountCurrency' attribute value. Markup currency
                     * 
                     * @return value
                     */
                    public String getAmountCurrency() {
                        return amountCurrency;
                    }

                    /** 
                     * Set the 'AmountCurrency' attribute value. Markup currency
                     * 
                     * @param amountCurrency
                     */
                    public void setAmountCurrency(String amountCurrency) {
                        this.amountCurrency = amountCurrency;
                    }

                    /** 
                     * Get the 'MarkupRuleSourcePCC' attribute value. Markup Rule Source PCC
                     * 
                     * @return value
                     */
                    public String getMarkupRuleSourcePCC() {
                        return markupRuleSourcePCC;
                    }

                    /** 
                     * Set the 'MarkupRuleSourcePCC' attribute value. Markup Rule Source PCC
                     * 
                     * @param markupRuleSourcePCC
                     */
                    public void setMarkupRuleSourcePCC(
                            String markupRuleSourcePCC) {
                        this.markupRuleSourcePCC = markupRuleSourcePCC;
                    }

                    /** 
                     * Get the 'MarkupRuleItemNumber' attribute value. Markup Rule Item Number
                     * 
                     * @return value
                     */
                    public String getMarkupRuleItemNumber() {
                        return markupRuleItemNumber;
                    }

                    /** 
                     * Set the 'MarkupRuleItemNumber' attribute value. Markup Rule Item Number
                     * 
                     * @param markupRuleItemNumber
                     */
                    public void setMarkupRuleItemNumber(
                            String markupRuleItemNumber) {
                        this.markupRuleItemNumber = markupRuleItemNumber;
                    }

                    /** 
                     * Get the 'RetailerRuleQualifier' attribute value. Retailer Rule Qualifier
                     * 
                     * @return value
                     */
                    public String getRetailerRuleQualifier() {
                        return retailerRuleQualifier;
                    }

                    /** 
                     * Set the 'RetailerRuleQualifier' attribute value. Retailer Rule Qualifier
                     * 
                     * @param retailerRuleQualifier
                     */
                    public void setRetailerRuleQualifier(
                            String retailerRuleQualifier) {
                        this.retailerRuleQualifier = retailerRuleQualifier;
                    }
                }
                /** 
                 * Matched General Retailer Rule Code or Adjusted Selling Level Retailer Rule Code
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRetailerRule" minOccurs="0" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="TransactionType"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class FareRetailerRule implements Serializable
                {
                    private String transactionType;
                    private String code;

                    /** 
                     * Get the 'TransactionType' attribute value. General or AdjustedSellingLevel
                     * 
                     * @return value
                     */
                    public String getTransactionType() {
                        return transactionType;
                    }

                    /** 
                     * Set the 'TransactionType' attribute value. General or AdjustedSellingLevel
                     * 
                     * @param transactionType
                     */
                    public void setTransactionType(String transactionType) {
                        this.transactionType = transactionType;
                    }

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareDataList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:SellingFareDataType" name="SellingFareData" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SellingFareDataList implements Serializable
        {
            private List<SellingFareDataType> sellingFareDataList = new ArrayList<SellingFareDataType>();

            /** 
             * Get the list of 'SellingFareData' element items.
             * 
             * @return list
             */
            public List<SellingFareDataType> getSellingFareDataList() {
                return sellingFareDataList;
            }

            /** 
             * Set the list of 'SellingFareData' element items.
             * 
             * @param list
             */
            public void setSellingFareDataList(List<SellingFareDataType> list) {
                sellingFareDataList = list;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionData" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:VCCInformationType" name="VCCInformation" minOccurs="0" maxOccurs="23"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Cat35CommissionPercentage"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Cat35CommissionAmount"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="Cat35MarkupAmount"/>
         *     &lt;xs:attribute type="xs:decimal" use="optional" name="CommissionAmountInEquivalent"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="CommissionSource"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CommissionData implements Serializable
        {
            private List<VCCInformationType> VCCInformationList = new ArrayList<VCCInformationType>();
            private BigDecimal cat35CommissionPercentage;
            private BigDecimal cat35CommissionAmount;
            private BigDecimal cat35MarkupAmount;
            private BigDecimal commissionAmountInEquivalent;
            private String commissionSource;

            /** 
             * Get the list of 'VCCInformation' element items.
             * 
             * @return list
             */
            public List<VCCInformationType> getVCCInformationList() {
                return VCCInformationList;
            }

            /** 
             * Set the list of 'VCCInformation' element items.
             * 
             * @param list
             */
            public void setVCCInformationList(List<VCCInformationType> list) {
                VCCInformationList = list;
            }

            /** 
             * Get the 'Cat35CommissionPercentage' attribute value. Cat 35 Commission Percentage
             * 
             * @return value
             */
            public BigDecimal getCat35CommissionPercentage() {
                return cat35CommissionPercentage;
            }

            /** 
             * Set the 'Cat35CommissionPercentage' attribute value. Cat 35 Commission Percentage
             * 
             * @param cat35CommissionPercentage
             */
            public void setCat35CommissionPercentage(
                    BigDecimal cat35CommissionPercentage) {
                this.cat35CommissionPercentage = cat35CommissionPercentage;
            }

            /** 
             * Get the 'Cat35CommissionAmount' attribute value. Cat 35 Commission Amount
             * 
             * @return value
             */
            public BigDecimal getCat35CommissionAmount() {
                return cat35CommissionAmount;
            }

            /** 
             * Set the 'Cat35CommissionAmount' attribute value. Cat 35 Commission Amount
             * 
             * @param cat35CommissionAmount
             */
            public void setCat35CommissionAmount(
                    BigDecimal cat35CommissionAmount) {
                this.cat35CommissionAmount = cat35CommissionAmount;
            }

            /** 
             * Get the 'Cat35MarkupAmount' attribute value. Cat 35 Markup Amount in equivalent amount currency
             * 
             * @return value
             */
            public BigDecimal getCat35MarkupAmount() {
                return cat35MarkupAmount;
            }

            /** 
             * Set the 'Cat35MarkupAmount' attribute value. Cat 35 Markup Amount in equivalent amount currency
             * 
             * @param cat35MarkupAmount
             */
            public void setCat35MarkupAmount(BigDecimal cat35MarkupAmount) {
                this.cat35MarkupAmount = cat35MarkupAmount;
            }

            /** 
             * Get the 'CommissionAmountInEquivalent' attribute value. Commission Amount in equivalent amount currency
             * 
             * @return value
             */
            public BigDecimal getCommissionAmountInEquivalent() {
                return commissionAmountInEquivalent;
            }

            /** 
             * Set the 'CommissionAmountInEquivalent' attribute value. Commission Amount in equivalent amount currency
             * 
             * @param commissionAmountInEquivalent
             */
            public void setCommissionAmountInEquivalent(
                    BigDecimal commissionAmountInEquivalent) {
                this.commissionAmountInEquivalent = commissionAmountInEquivalent;
            }

            /** 
             * Get the 'CommissionSource' attribute value. Commission Source [value C for Cat 35, A for AMC, M for Manual]
             * 
             * @return value
             */
            public String getCommissionSource() {
                return commissionSource;
            }

            /** 
             * Set the 'CommissionSource' attribute value. Commission Source [value C for Cat 35, A for AMC, M for Manual]
             * 
             * @param commissionSource
             */
            public void setCommissionSource(String commissionSource) {
                this.commissionSource = commissionSource;
            }
        }
        /** 
         * Seat Selection Information List
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatSelectionList" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SeatSelection" minOccurs="1" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class SeatSelection -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SeatSelectionList implements Serializable
        {
            private List<SeatSelection> seatSelectionList = new ArrayList<SeatSelection>();

            /** 
             * Get the list of 'SeatSelection' element items.
             * 
             * @return list
             */
            public List<SeatSelection> getSeatSelectionList() {
                return seatSelectionList;
            }

            /** 
             * Set the list of 'SeatSelection' element items.
             * 
             * @param list
             */
            public void setSeatSelectionList(List<SeatSelection> list) {
                seatSelectionList = list;
            }
            /** 
             * Info if seat selection is free, chargeable or it is not applicable
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatSelection" minOccurs="1" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Segment" minOccurs="1" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SeatSelection implements Serializable
            {
                private List<Segment> segmentList = new ArrayList<Segment>();
                private String type;

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the 'Type' attribute value. One-letter code applies: F - Free (No charge);  C - Charge;  N - Not applicable
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. One-letter code applies: F - Free (No charge);  C - Charge;  N - Not applicable
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="ID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger ID;

                    /** 
                     * Get the 'ID' attribute value. Segment reference for seat selection type
                     * 
                     * @return value
                     */
                    public BigInteger getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' attribute value. Segment reference for seat selection type
                     * 
                     * @param ID
                     */
                    public void setID(BigInteger ID) {
                        this.ID = ID;
                    }
                }
            }
        }
        /** 
         * Priority Boarding Information List
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriorityBoardingList" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="PriorityBoarding" minOccurs="1" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class PriorityBoarding -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PriorityBoardingList implements Serializable
        {
            private List<PriorityBoarding> priorityBoardingList = new ArrayList<PriorityBoarding>();

            /** 
             * Get the list of 'PriorityBoarding' element items.
             * 
             * @return list
             */
            public List<PriorityBoarding> getPriorityBoardingList() {
                return priorityBoardingList;
            }

            /** 
             * Set the list of 'PriorityBoarding' element items.
             * 
             * @param list
             */
            public void setPriorityBoardingList(List<PriorityBoarding> list) {
                priorityBoardingList = list;
            }
            /** 
             * Info if priority boarding is free, chargeable or it is not applicable
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriorityBoarding" minOccurs="1" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Segment" minOccurs="1" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Segment -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="Type"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class PriorityBoarding implements Serializable
            {
                private List<Segment> segmentList = new ArrayList<Segment>();
                private String type;

                /** 
                 * Get the list of 'Segment' element items.
                 * 
                 * @return list
                 */
                public List<Segment> getSegmentList() {
                    return segmentList;
                }

                /** 
                 * Set the list of 'Segment' element items.
                 * 
                 * @param list
                 */
                public void setSegmentList(List<Segment> list) {
                    segmentList = list;
                }

                /** 
                 * Get the 'Type' attribute value. One-letter code applies: F - Free (No charge);  C - Charge;  N - Not applicable
                 * 
                 * @return value
                 */
                public String getType() {
                    return type;
                }

                /** 
                 * Set the 'Type' attribute value. One-letter code applies: F - Free (No charge);  C - Charge;  N - Not applicable
                 * 
                 * @param type
                 */
                public void setType(String type) {
                    this.type = type;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Segment" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:integer" use="required" name="ID"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Segment implements Serializable
                {
                    private BigInteger ID;

                    /** 
                     * Get the 'ID' attribute value. Segment reference for priority boarding type
                     * 
                     * @return value
                     */
                    public BigInteger getID() {
                        return ID;
                    }

                    /** 
                     * Set the 'ID' attribute value. Segment reference for priority boarding type
                     * 
                     * @param ID
                     */
                    public void setID(BigInteger ID) {
                        this.ID = ID;
                    }
                }
            }
        }
    }
}
