
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlexibleFaresType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="FareParameters" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FareParameters -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlexibleFaresType implements Serializable
{
    private List<FareParameters> fareParameterList = new ArrayList<FareParameters>();

    /** 
     * Get the list of 'FareParameters' element items.
     * 
     * @return list
     */
    public List<FareParameters> getFareParameterList() {
        return fareParameterList;
    }

    /** 
     * Set the list of 'FareParameters' element items.
     * 
     * @param list
     */
    public void setFareParameterList(List<FareParameters> list) {
        fareParameterList = list;
    }
    /** 
     * This element specifies parameters for desired fare.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareParameters" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ExcludeRestricted" minOccurs="0">
     *         &lt;!-- Reference to inner class ExcludeRestricted -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ResTicketing" minOccurs="0">
     *         &lt;!-- Reference to inner class ResTicketing -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MinMaxStay" minOccurs="0">
     *         &lt;!-- Reference to inner class MinMaxStay -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="RefundPenalty" minOccurs="0">
     *         &lt;!-- Reference to inner class RefundPenalty -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PublicFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PublicFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PrivateFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PrivateFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Cabin" minOccurs="0">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="ns:CabinType" use="required" name="Type"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="NegotiatedFaresOnly" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class NegotiatedFaresOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="XOFares" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class XOFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UsePassengerFares" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class UsePassengerFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UseNegotiatedFares" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class UseNegotiatedFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:PassengerTypeQuantityType" name="PassengerTypeQuantity" minOccurs="0" maxOccurs="4"/>
     *       &lt;xs:element type="ns:JumpCabinLogicType" name="JumpCabinLogic" minOccurs="0"/>
     *       &lt;xs:element type="ns:KeepSameCabinType" name="KeepSameCabin" minOccurs="0"/>
     *       &lt;xs:element type="ns:AvoidCabinDowngradeType" name="AvoidCabinDowngrade" minOccurs="0"/>
     *       &lt;xs:element type="ns:VoluntaryChangesSMPType" name="VoluntaryChanges" minOccurs="0"/>
     *       &lt;xs:choice maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Choice -->
     *       &lt;/xs:choice>
     *       &lt;xs:element type="ns:ClassOfServiceElemType" name="ClassOfService" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:FareBasisType" name="FareBasis" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:FareTypePrefType" name="FareType" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:BrandedFareIndicatorsBase" name="BrandedFareIndicators" minOccurs="0"/>
     *       &lt;xs:element type="ns:BaggageType" name="Baggage" minOccurs="0"/>
     *       &lt;xs:element type="ns:FreeSeatSelectionType" name="SeatSelection" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="ns:FreePriorityBoardingType" name="PriorityBoarding" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="ns:SeatComfortPrefType" name="Seats" minOccurs="0"/>
     *       &lt;xs:element name="Leg" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Leg -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareParameters implements Serializable
    {
        private ExcludeRestricted excludeRestricted;
        private ResTicketing resTicketing;
        private MinMaxStay minMaxStay;
        private RefundPenalty refundPenalty;
        private PublicFare publicFare;
        private PrivateFare privateFare;
        private CabinType cabin;
        private NegotiatedFaresOnly negotiatedFaresOnly;
        private XOFares XOFares1;
        private UsePassengerFares usePassengerFares;
        private UseNegotiatedFares useNegotiatedFares;
        private List<PassengerTypeQuantityType> passengerTypeQuantityList = new ArrayList<PassengerTypeQuantityType>();
        private JumpCabinLogicType jumpCabinLogic;
        private KeepSameCabinType keepSameCabin;
        private AvoidCabinDowngradeType avoidCabinDowngrade;
        private VoluntaryChangesSMPType voluntaryChanges;
        private List<Choice> choiceList = new ArrayList<Choice>();
        private List<ClassOfServiceElemType> classOfServiceList = new ArrayList<ClassOfServiceElemType>();
        private List<FareBasisType> fareBasiList = new ArrayList<FareBasisType>();
        private List<FareTypePrefType> fareTypeList = new ArrayList<FareTypePrefType>();
        private BrandedFareIndicatorsBase brandedFareIndicators;
        private BaggageType baggage;
        private FreeSeatSelectionType seatSelection;
        private FreePriorityBoardingType priorityBoarding;
        private SeatComfortPrefType seats;
        private List<Leg> legList = new ArrayList<Leg>();

        /** 
         * Get the 'ExcludeRestricted' element value.
         * 
         * @return value
         */
        public ExcludeRestricted getExcludeRestricted() {
            return excludeRestricted;
        }

        /** 
         * Set the 'ExcludeRestricted' element value.
         * 
         * @param excludeRestricted
         */
        public void setExcludeRestricted(ExcludeRestricted excludeRestricted) {
            this.excludeRestricted = excludeRestricted;
        }

        /** 
         * Get the 'ResTicketing' element value.
         * 
         * @return value
         */
        public ResTicketing getResTicketing() {
            return resTicketing;
        }

        /** 
         * Set the 'ResTicketing' element value.
         * 
         * @param resTicketing
         */
        public void setResTicketing(ResTicketing resTicketing) {
            this.resTicketing = resTicketing;
        }

        /** 
         * Get the 'MinMaxStay' element value.
         * 
         * @return value
         */
        public MinMaxStay getMinMaxStay() {
            return minMaxStay;
        }

        /** 
         * Set the 'MinMaxStay' element value.
         * 
         * @param minMaxStay
         */
        public void setMinMaxStay(MinMaxStay minMaxStay) {
            this.minMaxStay = minMaxStay;
        }

        /** 
         * Get the 'RefundPenalty' element value.
         * 
         * @return value
         */
        public RefundPenalty getRefundPenalty() {
            return refundPenalty;
        }

        /** 
         * Set the 'RefundPenalty' element value.
         * 
         * @param refundPenalty
         */
        public void setRefundPenalty(RefundPenalty refundPenalty) {
            this.refundPenalty = refundPenalty;
        }

        /** 
         * Get the 'PublicFare' element value.
         * 
         * @return value
         */
        public PublicFare getPublicFare() {
            return publicFare;
        }

        /** 
         * Set the 'PublicFare' element value.
         * 
         * @param publicFare
         */
        public void setPublicFare(PublicFare publicFare) {
            this.publicFare = publicFare;
        }

        /** 
         * Get the 'PrivateFare' element value.
         * 
         * @return value
         */
        public PrivateFare getPrivateFare() {
            return privateFare;
        }

        /** 
         * Set the 'PrivateFare' element value.
         * 
         * @param privateFare
         */
        public void setPrivateFare(PrivateFare privateFare) {
            this.privateFare = privateFare;
        }

        /** 
         * Get the 'Type' attribute value. This element specifies preffered cabin type.
         * 
         * @return value
         */
        public CabinType getCabin() {
            return cabin;
        }

        /** 
         * Set the 'Type' attribute value. This element specifies preffered cabin type.
         * 
         * @param cabin
         */
        public void setCabin(CabinType cabin) {
            this.cabin = cabin;
        }

        /** 
         * Get the 'NegotiatedFaresOnly' element value.
         * 
         * @return value
         */
        public NegotiatedFaresOnly getNegotiatedFaresOnly() {
            return negotiatedFaresOnly;
        }

        /** 
         * Set the 'NegotiatedFaresOnly' element value.
         * 
         * @param negotiatedFaresOnly
         */
        public void setNegotiatedFaresOnly(
                NegotiatedFaresOnly negotiatedFaresOnly) {
            this.negotiatedFaresOnly = negotiatedFaresOnly;
        }

        /** 
         * Get the 'XOFares' element value.
         * 
         * @return value
         */
        public XOFares getXOFares1() {
            return XOFares1;
        }

        /** 
         * Set the 'XOFares' element value.
         * 
         * @param XOFares1
         */
        public void setXOFares1(XOFares XOFares1) {
            this.XOFares1 = XOFares1;
        }

        /** 
         * Get the 'UsePassengerFares' element value.
         * 
         * @return value
         */
        public UsePassengerFares getUsePassengerFares() {
            return usePassengerFares;
        }

        /** 
         * Set the 'UsePassengerFares' element value.
         * 
         * @param usePassengerFares
         */
        public void setUsePassengerFares(UsePassengerFares usePassengerFares) {
            this.usePassengerFares = usePassengerFares;
        }

        /** 
         * Get the 'UseNegotiatedFares' element value.
         * 
         * @return value
         */
        public UseNegotiatedFares getUseNegotiatedFares() {
            return useNegotiatedFares;
        }

        /** 
         * Set the 'UseNegotiatedFares' element value.
         * 
         * @param useNegotiatedFares
         */
        public void setUseNegotiatedFares(UseNegotiatedFares useNegotiatedFares) {
            this.useNegotiatedFares = useNegotiatedFares;
        }

        /** 
         * Get the list of 'PassengerTypeQuantity' element items. Define information on the number of passengers of a specific type.
         * 
         * @return list
         */
        public List<PassengerTypeQuantityType> getPassengerTypeQuantityList() {
            return passengerTypeQuantityList;
        }

        /** 
         * Set the list of 'PassengerTypeQuantity' element items. Define information on the number of passengers of a specific type.
         * 
         * @param list
         */
        public void setPassengerTypeQuantityList(
                List<PassengerTypeQuantityType> list) {
            passengerTypeQuantityList = list;
        }

        /** 
         * Get the 'JumpCabinLogic' element value.
         * 
         * @return value
         */
        public JumpCabinLogicType getJumpCabinLogic() {
            return jumpCabinLogic;
        }

        /** 
         * Set the 'JumpCabinLogic' element value.
         * 
         * @param jumpCabinLogic
         */
        public void setJumpCabinLogic(JumpCabinLogicType jumpCabinLogic) {
            this.jumpCabinLogic = jumpCabinLogic;
        }

        /** 
         * Get the 'KeepSameCabin' element value.
         * 
         * @return value
         */
        public KeepSameCabinType getKeepSameCabin() {
            return keepSameCabin;
        }

        /** 
         * Set the 'KeepSameCabin' element value.
         * 
         * @param keepSameCabin
         */
        public void setKeepSameCabin(KeepSameCabinType keepSameCabin) {
            this.keepSameCabin = keepSameCabin;
        }

        /** 
         * Get the 'AvoidCabinDowngrade' element value.
         * 
         * @return value
         */
        public AvoidCabinDowngradeType getAvoidCabinDowngrade() {
            return avoidCabinDowngrade;
        }

        /** 
         * Set the 'AvoidCabinDowngrade' element value.
         * 
         * @param avoidCabinDowngrade
         */
        public void setAvoidCabinDowngrade(
                AvoidCabinDowngradeType avoidCabinDowngrade) {
            this.avoidCabinDowngrade = avoidCabinDowngrade;
        }

        /** 
         * Get the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
         * 
         * @return value
         */
        public VoluntaryChangesSMPType getVoluntaryChanges() {
            return voluntaryChanges;
        }

        /** 
         * Set the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
         * 
         * @param voluntaryChanges
         */
        public void setVoluntaryChanges(VoluntaryChangesSMPType voluntaryChanges) {
            this.voluntaryChanges = voluntaryChanges;
        }

        /** 
         * Get the list of choice items.
         * 
         * @return list
         */
        public List<Choice> getChoiceList() {
            return choiceList;
        }

        /** 
         * Set the list of choice items.
         * 
         * @param list
         */
        public void setChoiceList(List<Choice> list) {
            choiceList = list;
        }

        /** 
         * Get the list of 'ClassOfService' element items. Requested booking code for whole flex fare
         * 
         * @return list
         */
        public List<ClassOfServiceElemType> getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the list of 'ClassOfService' element items. Requested booking code for whole flex fare
         * 
         * @param list
         */
        public void setClassOfServiceList(List<ClassOfServiceElemType> list) {
            classOfServiceList = list;
        }

        /** 
         * Get the list of 'FareBasis' element items. Fare Basis Codes requested for whole flexible fare
         * 
         * @return list
         */
        public List<FareBasisType> getFareBasiList() {
            return fareBasiList;
        }

        /** 
         * Set the list of 'FareBasis' element items. Fare Basis Codes requested for whole flexible fare
         * 
         * @param list
         */
        public void setFareBasiList(List<FareBasisType> list) {
            fareBasiList = list;
        }

        /** 
         * Get the list of 'FareType' element items. Defines preferred or excluded fare type codes for whole flexible fare.
         * 
         * @return list
         */
        public List<FareTypePrefType> getFareTypeList() {
            return fareTypeList;
        }

        /** 
         * Set the list of 'FareType' element items. Defines preferred or excluded fare type codes for whole flexible fare.
         * 
         * @param list
         */
        public void setFareTypeList(List<FareTypePrefType> list) {
            fareTypeList = list;
        }

        /** 
         * Get the 'BrandedFareIndicators' element value. Set of branded fare switches and preferences for whole flexible fare.
         * 
         * @return value
         */
        public BrandedFareIndicatorsBase getBrandedFareIndicators() {
            return brandedFareIndicators;
        }

        /** 
         * Set the 'BrandedFareIndicators' element value. Set of branded fare switches and preferences for whole flexible fare.
         * 
         * @param brandedFareIndicators
         */
        public void setBrandedFareIndicators(
                BrandedFareIndicatorsBase brandedFareIndicators) {
            this.brandedFareIndicators = brandedFareIndicators;
        }

        /** 
         * Get the 'Baggage' element value. This element allows user to get baggage information
         * 
         * @return value
         */
        public BaggageType getBaggage() {
            return baggage;
        }

        /** 
         * Set the 'Baggage' element value. This element allows user to get baggage information
         * 
         * @param baggage
         */
        public void setBaggage(BaggageType baggage) {
            this.baggage = baggage;
        }

        /** 
         * Get the 'SeatSelection' element value.
         * 
         * @return value
         */
        public FreeSeatSelectionType getSeatSelection() {
            return seatSelection;
        }

        /** 
         * Set the 'SeatSelection' element value.
         * 
         * @param seatSelection
         */
        public void setSeatSelection(FreeSeatSelectionType seatSelection) {
            this.seatSelection = seatSelection;
        }

        /** 
         * Get the 'PriorityBoarding' element value.
         * 
         * @return value
         */
        public FreePriorityBoardingType getPriorityBoarding() {
            return priorityBoarding;
        }

        /** 
         * Set the 'PriorityBoarding' element value.
         * 
         * @param priorityBoarding
         */
        public void setPriorityBoarding(
                FreePriorityBoardingType priorityBoarding) {
            this.priorityBoarding = priorityBoarding;
        }

        /** 
         * Get the 'Seats' element value. This element specifies seat comfort filter for whole flexible fare.
         * 
         * @return value
         */
        public SeatComfortPrefType getSeats() {
            return seats;
        }

        /** 
         * Set the 'Seats' element value. This element specifies seat comfort filter for whole flexible fare.
         * 
         * @param seats
         */
        public void setSeats(SeatComfortPrefType seats) {
            this.seats = seats;
        }

        /** 
         * Get the list of 'Leg' element items.
         * 
         * @return list
         */
        public List<Leg> getLegList() {
            return legList;
        }

        /** 
         * Set the list of 'Leg' element items.
         * 
         * @param list
         */
        public void setLegList(List<Leg> list) {
            legList = list;
        }
        /** 
         * Setting this to true means the same as setting ResTicketing, MinMaxStay and RefundPenalty to false.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeRestricted" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExcludeRestricted implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * If set to true, fares that have a reservation/ticketing can be included in the responses. If set to false, then no fares that include reservation/ticketing requirement will be included in the response. This is negation of XA qualifier.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResTicketing" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ResTicketing implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * If set to true, fares that have a min/max stay can be included in the responses. If set to false, then no fares that include a min/max stay requirement will be included in the response. This is negation of XS qualifier.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinMaxStay" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MinMaxStay implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * If set to true, fares that have a refund penalty can be included in the responses. If set to false, then no fares that include a refund penalty requirement will be included in the response. This is negation of XP qualifier.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundPenalty" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class RefundPenalty implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * This element finds only public fares.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublicFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PublicFare implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * This element finds only private fares.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PrivateFare implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * If set to true then returned fares need to match AcccountCode/CorpID specified in Fare Group definition on all fare components.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NegotiatedFaresOnly" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NegotiatedFaresOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * If set to true only fares matching PTC specified in the Flex Fare Group will be returned on all fare components.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="XOFares" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class XOFares implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * At least one fare component for each passenger type must be applicable for that passenger type.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UsePassengerFares" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UsePassengerFares implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Returned fares need to match AcccountCode/CorporateID specified in Fare Group definition on at least one fare component.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UseNegotiatedFares" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UseNegotiatedFares implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
         *   &lt;xs:element name="CorporateID" minOccurs="0">
         *     &lt;!-- Reference to inner class CorporateID -->
         *   &lt;/xs:element>
         *   &lt;xs:element name="AccountCode" minOccurs="0">
         *     &lt;!-- Reference to inner class AccountCode -->
         *   &lt;/xs:element>
         * &lt;/xs:choice>
         * </pre>
         */
        public static class Choice implements Serializable
        {
            private int choiceListSelect = -1;
            private static final int CORPORATE_ID_CHOICE = 0;
            private static final int ACCOUNT_CODE_CHOICE = 1;
            private CorporateID corporateID;
            private AccountCode accountCode;

            private void setChoiceListSelect(int choice) {
                if (choiceListSelect == -1) {
                    choiceListSelect = choice;
                } else if (choiceListSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceListSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceListSelect() {
                choiceListSelect = -1;
            }

            /** 
             * Check if CorporateID is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCorporateID() {
                return choiceListSelect == CORPORATE_ID_CHOICE;
            }

            /** 
             * Get the 'CorporateID' element value.
             * 
             * @return value
             */
            public CorporateID getCorporateID() {
                return corporateID;
            }

            /** 
             * Set the 'CorporateID' element value.
             * 
             * @param corporateID
             */
            public void setCorporateID(CorporateID corporateID) {
                setChoiceListSelect(CORPORATE_ID_CHOICE);
                this.corporateID = corporateID;
            }

            /** 
             * Check if AccountCode is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifAccountCode() {
                return choiceListSelect == ACCOUNT_CODE_CHOICE;
            }

            /** 
             * Get the 'AccountCode' element value.
             * 
             * @return value
             */
            public AccountCode getAccountCode() {
                return accountCode;
            }

            /** 
             * Set the 'AccountCode' element value.
             * 
             * @param accountCode
             */
            public void setAccountCode(AccountCode accountCode) {
                setChoiceListSelect(ACCOUNT_CODE_CHOICE);
                this.accountCode = accountCode;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CorporateID" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CorporateID implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountCode" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class AccountCode implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Defines legs for flexible fares
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Leg" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:ClassOfServiceElemType" name="ClassOfService" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:FareBasisType" name="FareBasis" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:FareTypePrefType" name="FareType" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:BrandFiltersType" name="BrandFilters" minOccurs="0"/>
         *       &lt;xs:element name="Cabin" minOccurs="0">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="ns:CabinType" use="required" name="Type"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:BaggageType" name="Baggage" minOccurs="0"/>
         *       &lt;xs:element type="ns:FreeSeatSelectionType" name="SeatSelection" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:element type="ns:FreePriorityBoardingType" name="PriorityBoarding" minOccurs="0" maxOccurs="1"/>
         *       &lt;xs:element type="ns:SeatComfortPrefType" name="Seats" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:short" use="required" name="Num"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Leg implements Serializable
        {
            private List<ClassOfServiceElemType> classOfServiceList = new ArrayList<ClassOfServiceElemType>();
            private List<FareBasisType> fareBasiList = new ArrayList<FareBasisType>();
            private List<FareTypePrefType> fareTypeList = new ArrayList<FareTypePrefType>();
            private BrandFiltersType brandFilters;
            private CabinType cabin;
            private BaggageType baggage;
            private FreeSeatSelectionType seatSelection;
            private FreePriorityBoardingType priorityBoarding;
            private SeatComfortPrefType seats;
            private Short num;

            /** 
             * Get the list of 'ClassOfService' element items. Requested booking code per flex fare leg
             * 
             * @return list
             */
            public List<ClassOfServiceElemType> getClassOfServiceList() {
                return classOfServiceList;
            }

            /** 
             * Set the list of 'ClassOfService' element items. Requested booking code per flex fare leg
             * 
             * @param list
             */
            public void setClassOfServiceList(List<ClassOfServiceElemType> list) {
                classOfServiceList = list;
            }

            /** 
             * Get the list of 'FareBasis' element items. Fare Basis Codes requested for flexible fare leg
             * 
             * @return list
             */
            public List<FareBasisType> getFareBasiList() {
                return fareBasiList;
            }

            /** 
             * Set the list of 'FareBasis' element items. Fare Basis Codes requested for flexible fare leg
             * 
             * @param list
             */
            public void setFareBasiList(List<FareBasisType> list) {
                fareBasiList = list;
            }

            /** 
             * Get the list of 'FareType' element items. Defines preferred or excluded fare type codes for flexible fare leg.
             * 
             * @return list
             */
            public List<FareTypePrefType> getFareTypeList() {
                return fareTypeList;
            }

            /** 
             * Set the list of 'FareType' element items. Defines preferred or excluded fare type codes for flexible fare leg.
             * 
             * @param list
             */
            public void setFareTypeList(List<FareTypePrefType> list) {
                fareTypeList = list;
            }

            /** 
             * Get the 'BrandFilters' element value. Defines preferred or excluded brand type codes for flexible fare leg.
             * 
             * @return value
             */
            public BrandFiltersType getBrandFilters() {
                return brandFilters;
            }

            /** 
             * Set the 'BrandFilters' element value. Defines preferred or excluded brand type codes for flexible fare leg.
             * 
             * @param brandFilters
             */
            public void setBrandFilters(BrandFiltersType brandFilters) {
                this.brandFilters = brandFilters;
            }

            /** 
             * Get the 'Type' attribute value. This element specifies preffered cabin type for flexible fare leg
             * 
             * @return value
             */
            public CabinType getCabin() {
                return cabin;
            }

            /** 
             * Set the 'Type' attribute value. This element specifies preffered cabin type for flexible fare leg
             * 
             * @param cabin
             */
            public void setCabin(CabinType cabin) {
                this.cabin = cabin;
            }

            /** 
             * Get the 'Baggage' element value. This element allows user to get baggage information
             * 
             * @return value
             */
            public BaggageType getBaggage() {
                return baggage;
            }

            /** 
             * Set the 'Baggage' element value. This element allows user to get baggage information
             * 
             * @param baggage
             */
            public void setBaggage(BaggageType baggage) {
                this.baggage = baggage;
            }

            /** 
             * Get the 'SeatSelection' element value.
             * 
             * @return value
             */
            public FreeSeatSelectionType getSeatSelection() {
                return seatSelection;
            }

            /** 
             * Set the 'SeatSelection' element value.
             * 
             * @param seatSelection
             */
            public void setSeatSelection(FreeSeatSelectionType seatSelection) {
                this.seatSelection = seatSelection;
            }

            /** 
             * Get the 'PriorityBoarding' element value.
             * 
             * @return value
             */
            public FreePriorityBoardingType getPriorityBoarding() {
                return priorityBoarding;
            }

            /** 
             * Set the 'PriorityBoarding' element value.
             * 
             * @param priorityBoarding
             */
            public void setPriorityBoarding(
                    FreePriorityBoardingType priorityBoarding) {
                this.priorityBoarding = priorityBoarding;
            }

            /** 
             * Get the 'Seats' element value. This element specifies seat comfort filter for flexible fare leg.
             * 
             * @return value
             */
            public SeatComfortPrefType getSeats() {
                return seats;
            }

            /** 
             * Set the 'Seats' element value. This element specifies seat comfort filter for flexible fare leg.
             * 
             * @param seats
             */
            public void setSeats(SeatComfortPrefType seats) {
                this.seats = seats;
            }

            /** 
             * Get the 'Num' attribute value.
             * 
             * @return value
             */
            public Short getNum() {
                return num;
            }

            /** 
             * Set the 'Num' attribute value.
             * 
             * @param num
             */
            public void setNum(Short num) {
                this.num = num;
            }
        }
    }
}
