
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * List of all Flight Amenities of different types that are available on any of the returned flights.
 They are later referenced from other elements.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightAmenitiesListType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BeverageAmenityType" name="Beverage" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:EntertainmentAmenityType" name="Entertainment" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FoodAmenityType" name="Food" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:LayoutAmenityType" name="Layout" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:PowerAmenityType" name="Power" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:SeatAmenityType" name="Seat" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:WifiAmenityType" name="Wifi" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class FlightAmenitiesListType implements Serializable
{
    private List<BeverageAmenityType> beverageList = new ArrayList<BeverageAmenityType>();
    private List<EntertainmentAmenityType> entertainmentList = new ArrayList<EntertainmentAmenityType>();
    private List<FoodAmenityType> foodList = new ArrayList<FoodAmenityType>();
    private List<LayoutAmenityType> layoutList = new ArrayList<LayoutAmenityType>();
    private List<PowerAmenityType> powerList = new ArrayList<PowerAmenityType>();
    private List<SeatAmenityType> seatList = new ArrayList<SeatAmenityType>();
    private List<WifiAmenityType> wifiList = new ArrayList<WifiAmenityType>();

    /** 
     * Get the list of 'Beverage' element items.
     * 
     * @return list
     */
    public List<BeverageAmenityType> getBeverageList() {
        return beverageList;
    }

    /** 
     * Set the list of 'Beverage' element items.
     * 
     * @param list
     */
    public void setBeverageList(List<BeverageAmenityType> list) {
        beverageList = list;
    }

    /** 
     * Get the list of 'Entertainment' element items.
     * 
     * @return list
     */
    public List<EntertainmentAmenityType> getEntertainmentList() {
        return entertainmentList;
    }

    /** 
     * Set the list of 'Entertainment' element items.
     * 
     * @param list
     */
    public void setEntertainmentList(List<EntertainmentAmenityType> list) {
        entertainmentList = list;
    }

    /** 
     * Get the list of 'Food' element items.
     * 
     * @return list
     */
    public List<FoodAmenityType> getFoodList() {
        return foodList;
    }

    /** 
     * Set the list of 'Food' element items.
     * 
     * @param list
     */
    public void setFoodList(List<FoodAmenityType> list) {
        foodList = list;
    }

    /** 
     * Get the list of 'Layout' element items.
     * 
     * @return list
     */
    public List<LayoutAmenityType> getLayoutList() {
        return layoutList;
    }

    /** 
     * Set the list of 'Layout' element items.
     * 
     * @param list
     */
    public void setLayoutList(List<LayoutAmenityType> list) {
        layoutList = list;
    }

    /** 
     * Get the list of 'Power' element items.
     * 
     * @return list
     */
    public List<PowerAmenityType> getPowerList() {
        return powerList;
    }

    /** 
     * Set the list of 'Power' element items.
     * 
     * @param list
     */
    public void setPowerList(List<PowerAmenityType> list) {
        powerList = list;
    }

    /** 
     * Get the list of 'Seat' element items.
     * 
     * @return list
     */
    public List<SeatAmenityType> getSeatList() {
        return seatList;
    }

    /** 
     * Set the list of 'Seat' element items.
     * 
     * @param list
     */
    public void setSeatList(List<SeatAmenityType> list) {
        seatList = list;
    }

    /** 
     * Get the list of 'Wifi' element items.
     * 
     * @return list
     */
    public List<WifiAmenityType> getWifiList() {
        return wifiList;
    }

    /** 
     * Set the list of 'Wifi' element items.
     * 
     * @param list
     */
    public void setWifiList(List<WifiAmenityType> list) {
        wifiList = list;
    }
}
