
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Indicates preferences for certain types of flights, such as connections or stopovers, when used for a specific travel situation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightTypePrefType">
 *   &lt;xs:attributeGroup ref="ns:PreferLevelGroup"/>
 *   &lt;xs:attribute type="ns:FlightTypeType" use="optional" name="FlightType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaxConnections"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferLevelGroup">
 *   &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class FlightTypePrefType implements Serializable
{
    private PreferLevelType preferLevel;
    private FlightTypeType flightType;
    private String maxConnections;

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @return value
     */
    public PreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'FlightType' attribute value.
     * 
     * @return value
     */
    public FlightTypeType getFlightType() {
        return flightType;
    }

    /** 
     * Set the 'FlightType' attribute value.
     * 
     * @param flightType
     */
    public void setFlightType(FlightTypeType flightType) {
        this.flightType = flightType;
    }

    /** 
     * Get the 'MaxConnections' attribute value. Indicates that if connection is chosen, then this attribute defines the maximum number of connections preferred.
     * 
     * @return value
     */
    public String getMaxConnections() {
        return maxConnections;
    }

    /** 
     * Set the 'MaxConnections' attribute value. Indicates that if connection is chosen, then this attribute defines the maximum number of connections preferred.
     * 
     * @param maxConnections
     */
    public void setMaxConnections(String maxConnections) {
        this.maxConnections = maxConnections;
    }
}
