
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * 
 Used to specify a preference level with only 2 value: Unacceptable and Preferred

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncludeExcludePreferLevelType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="Unacceptable"/>
 *     &lt;xs:enumeration value="Preferred"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum IncludeExcludePreferLevelType implements Serializable {
    UNACCEPTABLE("Unacceptable"), PREFERRED("Preferred");
    private final String value;

    private IncludeExcludePreferLevelType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static IncludeExcludePreferLevelType convert(String value) {
        for (IncludeExcludePreferLevelType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
