
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InterlineBrandsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BrandType" name="Brand" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ChangeBrandForSoldout"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class InterlineBrandsType implements Serializable
{
    private List<BrandType> brandList = new ArrayList<BrandType>();
    private Boolean changeBrandForSoldout;

    /** 
     * Get the list of 'Brand' element items. Brand list to be returned
     * 
     * @return list
     */
    public List<BrandType> getBrandList() {
        return brandList;
    }

    /** 
     * Set the list of 'Brand' element items. Brand list to be returned
     * 
     * @param list
     */
    public void setBrandList(List<BrandType> list) {
        brandList = list;
    }

    /** 
     * Get the 'ChangeBrandForSoldout' attribute value. If specific XX brand is not available for requested date/flight, another cheapest brand will be returned combined with available XX brand.
     * 
     * @return value
     */
    public Boolean getChangeBrandForSoldout() {
        return changeBrandForSoldout;
    }

    /** 
     * Set the 'ChangeBrandForSoldout' attribute value. If specific XX brand is not available for requested date/flight, another cheapest brand will be returned combined with available XX brand.
     * 
     * @param changeBrandForSoldout
     */
    public void setChangeBrandForSoldout(Boolean changeBrandForSoldout) {
        this.changeBrandForSoldout = changeBrandForSoldout;
    }
}
