
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItinTotalFareType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:FareType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Extras" minOccurs="0">
 *           &lt;!-- Reference to inner class Extras -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TotalWithExtras" minOccurs="0">
 *           &lt;!-- Reference to inner class TotalWithExtras -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="TotalMileage" minOccurs="0">
 *           &lt;!-- Reference to inner class TotalMileage -->
 *         &lt;/xs:element>
 *         &lt;xs:element name="ServiceFee" minOccurs="0">
 *           &lt;!-- Reference to inner class ServiceFee -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ItinTotalFareType extends FareType implements Serializable
{
    private Extras extras;
    private TotalWithExtras totalWithExtras;
    private TotalMileage totalMileage;
    private ServiceFee serviceFee;

    /** 
     * Get the 'Extras' element value.
     * 
     * @return value
     */
    public Extras getExtras() {
        return extras;
    }

    /** 
     * Set the 'Extras' element value.
     * 
     * @param extras
     */
    public void setExtras(Extras extras) {
        this.extras = extras;
    }

    /** 
     * Get the 'TotalWithExtras' element value.
     * 
     * @return value
     */
    public TotalWithExtras getTotalWithExtras() {
        return totalWithExtras;
    }

    /** 
     * Set the 'TotalWithExtras' element value.
     * 
     * @param totalWithExtras
     */
    public void setTotalWithExtras(TotalWithExtras totalWithExtras) {
        this.totalWithExtras = totalWithExtras;
    }

    /** 
     * Get the 'TotalMileage' element value.
     * 
     * @return value
     */
    public TotalMileage getTotalMileage() {
        return totalMileage;
    }

    /** 
     * Set the 'TotalMileage' element value.
     * 
     * @param totalMileage
     */
    public void setTotalMileage(TotalMileage totalMileage) {
        this.totalMileage = totalMileage;
    }

    /** 
     * Get the 'ServiceFee' element value.
     * 
     * @return value
     */
    public ServiceFee getServiceFee() {
        return serviceFee;
    }

    /** 
     * Set the 'ServiceFee' element value.
     * 
     * @param serviceFee
     */
    public void setServiceFee(ServiceFee serviceFee) {
        this.serviceFee = serviceFee;
    }
    /** 
     * Air Extras total summary amount
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Extras" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Extras implements Serializable
    {
        private String amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
    /** 
     * Total price with Air Extras
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalWithExtras" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalWithExtras implements Serializable
    {
        private String amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalMileage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Amount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TotalMileage implements Serializable
    {
        private String amount;

        /** 
         * Get the 'Amount' attribute value.
         * 
         * @return value
         */
        public String getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value.
         * 
         * @param amount
         */
        public void setAmount(String amount) {
            this.amount = amount;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ServiceFee" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="Amount"/>
     *     &lt;xs:attribute type="xs:decimal" use="required" name="TaxAmount"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ServiceFee implements Serializable
    {
        private BigDecimal amount;
        private BigDecimal taxAmount;

        /** 
         * Get the 'Amount' attribute value. Service Fee Amount
         * 
         * @return value
         */
        public BigDecimal getAmount() {
            return amount;
        }

        /** 
         * Set the 'Amount' attribute value. Service Fee Amount
         * 
         * @param amount
         */
        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        /** 
         * Get the 'TaxAmount' attribute value. Service Fee Tax
         * 
         * @return value
         */
        public BigDecimal getTaxAmount() {
            return taxAmount;
        }

        /** 
         * Set the 'TaxAmount' attribute value. Service Fee Tax
         * 
         * @param taxAmount
         */
        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }
    }
}
