
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 This describes the dominating row layout in a given cabin. These alements are later referenced from FlightAmenities

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LayoutAmenityType">
 *   &lt;xs:attribute type="xs:integer" use="required" name="Id"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="DirectAisleAccess"/>
 *   &lt;xs:attribute use="optional" name="RowLayout">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class RowLayout -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class LayoutAmenityType implements Serializable
{
    private BigInteger id;
    private Boolean directAisleAccess;
    private RowLayout rowLayout;

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public BigInteger getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(BigInteger id) {
        this.id = id;
    }

    /** 
     * Get the 'DirectAisleAccess' attribute value.
     * 
     * @return value
     */
    public Boolean getDirectAisleAccess() {
        return directAisleAccess;
    }

    /** 
     * Set the 'DirectAisleAccess' attribute value.
     * 
     * @param directAisleAccess
     */
    public void setDirectAisleAccess(Boolean directAisleAccess) {
        this.directAisleAccess = directAisleAccess;
    }

    /** 
     * Get the 'RowLayout' attribute value.
     * 
     * @return value
     */
    public RowLayout getRowLayout() {
        return rowLayout;
    }

    /** 
     * Set the 'RowLayout' attribute value.
     * 
     * @param rowLayout
     */
    public void setRowLayout(RowLayout rowLayout) {
        this.rowLayout = rowLayout;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="1-1"/>
     *     &lt;xs:enumeration value="1-1-1"/>
     *     &lt;xs:enumeration value="1-2"/>
     *     &lt;xs:enumeration value="1-2-1"/>
     *     &lt;xs:enumeration value="1-2-2"/>
     *     &lt;xs:enumeration value="2-0"/>
     *     &lt;xs:enumeration value="2-1"/>
     *     &lt;xs:enumeration value="2-1-2"/>
     *     &lt;xs:enumeration value="2-2"/>
     *     &lt;xs:enumeration value="2-2-1"/>
     *     &lt;xs:enumeration value="2-2-2"/>
     *     &lt;xs:enumeration value="2-3"/>
     *     &lt;xs:enumeration value="2-3-2"/>
     *     &lt;xs:enumeration value="2-4-2"/>
     *     &lt;xs:enumeration value="2-4-3"/>
     *     &lt;xs:enumeration value="3-2"/>
     *     &lt;xs:enumeration value="3-3"/>
     *     &lt;xs:enumeration value="3-3-3"/>
     *     &lt;xs:enumeration value="3-4-2"/>
     *     &lt;xs:enumeration value="3-4-3"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum RowLayout implements Serializable {
        _11("1-1"), _111("1-1-1"), _12("1-2"), _121("1-2-1"), _122("1-2-2"), _20(
                "2-0"), _21("2-1"), _212("2-1-2"), _22("2-2"), _221("2-2-1"), _222(
                "2-2-2"), _23("2-3"), _232("2-3-2"), _242("2-4-2"), _243(
                "2-4-3"), _32("3-2"), _33("3-3"), _333("3-3-3"), _342("3-4-2"), _343(
                "3-4-3");
        private final String value;

        private RowLayout(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static RowLayout convert(String value) {
            for (RowLayout inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
