
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OriginDestinationFlightAttributeGroup">
 *   &lt;xs:attribute type="xs:short" use="required" name="Number"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DepartureDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ArrivalDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MarriageStatus"/>
 *   &lt;xs:attribute type="xs:string" use="optional" default="A" name="Type"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Flown"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="KeepBookingCode"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class OriginDestinationFlightAttributeGroup implements Serializable
{
    private short number;
    private String departureDateTime;
    private String arrivalDateTime;
    private String marriageStatus;
    private String type;
    private Boolean flown;
    private Boolean keepBookingCode;

    /** 
     * Get the 'Number' attribute value. Flight number
     * 
     * @return value
     */
    public short getNumber() {
        return number;
    }

    /** 
     * Set the 'Number' attribute value. Flight number
     * 
     * @param number
     */
    public void setNumber(short number) {
        this.number = number;
    }

    /** 
     * Get the 'DepartureDateTime' attribute value. Departure date and time
     * 
     * @return value
     */
    public String getDepartureDateTime() {
        return departureDateTime;
    }

    /** 
     * Set the 'DepartureDateTime' attribute value. Departure date and time
     * 
     * @param departureDateTime
     */
    public void setDepartureDateTime(String departureDateTime) {
        this.departureDateTime = departureDateTime;
    }

    /** 
     * Get the 'ArrivalDateTime' attribute value. Arrival date and time
     * 
     * @return value
     */
    public String getArrivalDateTime() {
        return arrivalDateTime;
    }

    /** 
     * Set the 'ArrivalDateTime' attribute value. Arrival date and time
     * 
     * @param arrivalDateTime
     */
    public void setArrivalDateTime(String arrivalDateTime) {
        this.arrivalDateTime = arrivalDateTime;
    }

    /** 
     * Get the 'MarriageStatus' attribute value. Marriage status
     * 
     * @return value
     */
    public String getMarriageStatus() {
        return marriageStatus;
    }

    /** 
     * Set the 'MarriageStatus' attribute value. Marriage status
     * 
     * @param marriageStatus
     */
    public void setMarriageStatus(String marriageStatus) {
        this.marriageStatus = marriageStatus;
    }

    /** 
     * Get the 'Type' attribute value. Flight type (A: Air Segment, K: ARUNK, O: Open Segment)
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Flight type (A: Air Segment, K: ARUNK, O: Open Segment)
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'Flown' attribute value. Specify whether the flight is flown.
     * 
     * @return value
     */
    public Boolean getFlown() {
        return flown;
    }

    /** 
     * Set the 'Flown' attribute value. Specify whether the flight is flown.
     * 
     * @param flown
     */
    public void setFlown(Boolean flown) {
        this.flown = flown;
    }

    /** 
     * Get the 'KeepBookingCode' attribute value. If set to ''true'', the original booking code will be kept for unchanged flight.
     * 
     * @return value
     */
    public Boolean getKeepBookingCode() {
        return keepBookingCode;
    }

    /** 
     * Set the 'KeepBookingCode' attribute value. If set to ''true'', the original booking code will be kept for unchanged flight.
     * 
     * @param keepBookingCode
     */
    public void setKeepBookingCode(Boolean keepBookingCode) {
        this.keepBookingCode = keepBookingCode;
    }
}
