
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Per passenger type code pricing for this itinerary. Set if fareBreakdown was requested.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PTCFareBreakdownType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="OfferItem" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class OfferItem -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:PassengerTypeQuantityPersonalInfoType" name="PassengerTypeQuantity"/>
 *     &lt;xs:element name="FareBasisCodes">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="FareBasisCode" maxOccurs="400">
 *             &lt;!-- Reference to inner class FareBasisCode -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:FareType" name="PassengerFare"/>
 *     &lt;xs:element name="Endorsements" minOccurs="0">
 *       &lt;!-- Reference to inner class Endorsements -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FareInfos" minOccurs="0">
 *       &lt;!-- Reference to inner class FareInfos -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PricingSource"/>
 *   &lt;xs:attribute type="xs:string" name="PrivateFareType"/>
 *   &lt;xs:attribute type="xs:string" name="LastTicketDate"/>
 *   &lt;xs:attribute type="xs:string" name="LastTicketTime"/>
 *   &lt;xs:attribute type="xs:date" name="PreviousExchangeDate"/>
 *   &lt;xs:attribute name="ReissueExchange">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ReissueExchange -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PTCFareBreakdownType implements Serializable
{
    private OfferItem offerItem;
    private PassengerTypeQuantityPersonalInfoType passengerTypeQuantity;
    private List<FareBasisCode> fareBasisCodeList = new ArrayList<FareBasisCode>();
    private com.gridnine.sabre.bfm.FareType passengerFare;
    private Endorsements endorsements;
    private TPAExtensions TPAExtensions1;
    private FareInfos fareInfos;
    private String pricingSource;
    private String privateFareType;
    private String lastTicketDate;
    private String lastTicketTime;
    private Date previousExchangeDate;
    private ReissueExchange reissueExchange;

    /** 
     * Get the 'OfferItem' element value.
     * 
     * @return value
     */
    public OfferItem getOfferItem() {
        return offerItem;
    }

    /** 
     * Set the 'OfferItem' element value.
     * 
     * @param offerItem
     */
    public void setOfferItem(OfferItem offerItem) {
        this.offerItem = offerItem;
    }

    /** 
     * Get the 'PassengerTypeQuantity' element value. Number of individuals traveling under this PTC
     * 
     * @return value
     */
    public PassengerTypeQuantityPersonalInfoType getPassengerTypeQuantity() {
        return passengerTypeQuantity;
    }

    /** 
     * Set the 'PassengerTypeQuantity' element value. Number of individuals traveling under this PTC
     * 
     * @param passengerTypeQuantity
     */
    public void setPassengerTypeQuantity(
            PassengerTypeQuantityPersonalInfoType passengerTypeQuantity) {
        this.passengerTypeQuantity = passengerTypeQuantity;
    }

    /** 
     * Get the list of 'FareBasisCode' element items. This is a collection of Fare Basis Codes
     * 
     * @return list
     */
    public List<FareBasisCode> getFareBasisCodeList() {
        return fareBasisCodeList;
    }

    /** 
     * Set the list of 'FareBasisCode' element items. This is a collection of Fare Basis Codes
     * 
     * @param list
     */
    public void setFareBasisCodeList(List<FareBasisCode> list) {
        fareBasisCodeList = list;
    }

    /** 
     * Get the 'PassengerFare' element value. The total passenger fare with cost breakdown.
     * 
     * @return value
     */
    public com.gridnine.sabre.bfm.FareType getPassengerFare() {
        return passengerFare;
    }

    /** 
     * Set the 'PassengerFare' element value. The total passenger fare with cost breakdown.
     * 
     * @param passengerFare
     */
    public void setPassengerFare(com.gridnine.sabre.bfm.FareType passengerFare) {
        this.passengerFare = passengerFare;
    }

    /** 
     * Get the 'Endorsements' element value.
     * 
     * @return value
     */
    public Endorsements getEndorsements() {
        return endorsements;
    }

    /** 
     * Set the 'Endorsements' element value.
     * 
     * @param endorsements
     */
    public void setEndorsements(Endorsements endorsements) {
        this.endorsements = endorsements;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'FareInfos' element value.
     * 
     * @return value
     */
    public FareInfos getFareInfos() {
        return fareInfos;
    }

    /** 
     * Set the 'FareInfos' element value.
     * 
     * @param fareInfos
     */
    public void setFareInfos(FareInfos fareInfos) {
        this.fareInfos = fareInfos;
    }

    /** 
     * Get the 'PricingSource' attribute value. Indicates whether the fare is public or private.
     * 
     * @return value
     */
    public String getPricingSource() {
        return pricingSource;
    }

    /** 
     * Set the 'PricingSource' attribute value. Indicates whether the fare is public or private.
     * 
     * @param pricingSource
     */
    public void setPricingSource(String pricingSource) {
        this.pricingSource = pricingSource;
    }

    /** 
     * Get the 'PrivateFareType' attribute value. Private fare type symbol.
     * 
     * @return value
     */
    public String getPrivateFareType() {
        return privateFareType;
    }

    /** 
     * Set the 'PrivateFareType' attribute value. Private fare type symbol.
     * 
     * @param privateFareType
     */
    public void setPrivateFareType(String privateFareType) {
        this.privateFareType = privateFareType;
    }

    /** 
     * Get the 'LastTicketDate' attribute value. Last day to ticket.
     * 
     * @return value
     */
    public String getLastTicketDate() {
        return lastTicketDate;
    }

    /** 
     * Set the 'LastTicketDate' attribute value. Last day to ticket.
     * 
     * @param lastTicketDate
     */
    public void setLastTicketDate(String lastTicketDate) {
        this.lastTicketDate = lastTicketDate;
    }

    /** 
     * Get the 'LastTicketTime' attribute value. Last time to ticket.
     * 
     * @return value
     */
    public String getLastTicketTime() {
        return lastTicketTime;
    }

    /** 
     * Set the 'LastTicketTime' attribute value. Last time to ticket.
     * 
     * @param lastTicketTime
     */
    public void setLastTicketTime(String lastTicketTime) {
        this.lastTicketTime = lastTicketTime;
    }

    /** 
     * Get the 'PreviousExchangeDate' attribute value. Previous Exchange Date
     * 
     * @return value
     */
    public Date getPreviousExchangeDate() {
        return previousExchangeDate;
    }

    /** 
     * Set the 'PreviousExchangeDate' attribute value. Previous Exchange Date
     * 
     * @param previousExchangeDate
     */
    public void setPreviousExchangeDate(Date previousExchangeDate) {
        this.previousExchangeDate = previousExchangeDate;
    }

    /** 
     * Get the 'ReissueExchange' attribute value. Indicates whether priced as Reissue or Exchange
     * 
     * @return value
     */
    public ReissueExchange getReissueExchange() {
        return reissueExchange;
    }

    /** 
     * Set the 'ReissueExchange' attribute value. Indicates whether priced as Reissue or Exchange
     * 
     * @param reissueExchange
     */
    public void setReissueExchange(ReissueExchange reissueExchange) {
        this.reissueExchange = reissueExchange;
    }
    /** 
     * NDC OfferItem related data
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OfferItem" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="OfferItemId"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="MandatoryInd"/>
     *     &lt;xs:attribute type="xs:string" use="optional" name="ServiceId"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OfferItem implements Serializable
    {
        private String offerItemId;
        private Boolean mandatoryInd;
        private String serviceId;

        /** 
         * Get the 'OfferItemId' attribute value. NDC OfferItem Id
         * 
         * @return value
         */
        public String getOfferItemId() {
            return offerItemId;
        }

        /** 
         * Set the 'OfferItemId' attribute value. NDC OfferItem Id
         * 
         * @param offerItemId
         */
        public void setOfferItemId(String offerItemId) {
            this.offerItemId = offerItemId;
        }

        /** 
         * Get the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional.
         * 
         * @return value
         */
        public Boolean getMandatoryInd() {
            return mandatoryInd;
        }

        /** 
         * Set the 'MandatoryInd' attribute value. If set to 'true', indicates mandatory Offer Items which cannot be removed from the Offer. Mandatory Offer Items transition into Order Items. If not present or 'false', the Offer item is optional.
         * 
         * @param mandatoryInd
         */
        public void setMandatoryInd(Boolean mandatoryInd) {
            this.mandatoryInd = mandatoryInd;
        }

        /** 
         * Get the 'ServiceId' attribute value. NDC Service Id
         * 
         * @return value
         */
        public String getServiceId() {
            return serviceId;
        }

        /** 
         * Set the 'ServiceId' attribute value. NDC Service Id
         * 
         * @param serviceId
         */
        public void setServiceId(String serviceId) {
            this.serviceId = serviceId;
        }
    }
    /** 
     * Fare basis code for the price for this PTC
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareBasisCode" maxOccurs="400">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" name="PrivateFareType"/>
     *         &lt;xs:attribute type="xs:unsignedShort" use="optional" name="FareComponentReferenceID"/>
     *         &lt;xs:attribute type="xs:string" name="AccountCode"/>
     *         &lt;xs:attribute type="xs:int" name="Mileage"/>
     *         &lt;xs:attribute type="xs:string" name="BookingCode"/>
     *         &lt;xs:attribute type="xs:boolean" name="AvailabilityBreak"/>
     *         &lt;xs:attribute type="xs:anySimpleType" name="DepartureAirportCode"/>
     *         &lt;xs:attribute type="xs:anySimpleType" name="ArrivalAirportCode"/>
     *         &lt;xs:attribute type="xs:string" name="FareComponentBeginAirport"/>
     *         &lt;xs:attribute type="xs:string" name="FareComponentEndAirport"/>
     *         &lt;xs:attribute type="ns:FareDirectionality" name="FareComponentDirectionality"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentVendorCode"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentFareTypeBitmap"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentFareType"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentFareTariff"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentFareRule"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentCabinCode"/>
     *         &lt;xs:attribute type="xs:integer" use="optional" name="FareComponentID"/>
     *         &lt;xs:attribute type="xs:decimal" use="optional" name="FareComponentAmount"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="FareComponentCurrency"/>
     *         &lt;xs:attribute type="xs:string" name="GovCarrier"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareBasisCode implements Serializable
    {
        private String string;
        private String privateFareType;
        private String fareComponentReferenceID;
        private String accountCode;
        private Integer mileage;
        private String bookingCode;
        private Boolean availabilityBreak;
        private String departureAirportCode;
        private String arrivalAirportCode;
        private String fareComponentBeginAirport;
        private String fareComponentEndAirport;
        private FareDirectionality fareComponentDirectionality;
        private String fareComponentVendorCode;
        private String fareComponentFareTypeBitmap;
        private String fareComponentFareType;
        private String fareComponentFareTariff;
        private String fareComponentFareRule;
        private String fareComponentCabinCode;
        private BigInteger fareComponentID;
        private BigDecimal fareComponentAmount;
        private String fareComponentCurrency;
        private String govCarrier;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'PrivateFareType' attribute value. Private fare type symbol.
         * 
         * @return value
         */
        public String getPrivateFareType() {
            return privateFareType;
        }

        /** 
         * Set the 'PrivateFareType' attribute value. Private fare type symbol.
         * 
         * @param privateFareType
         */
        public void setPrivateFareType(String privateFareType) {
            this.privateFareType = privateFareType;
        }

        /** 
         * Get the 'FareComponentReferenceID' attribute value.
         * 
         * @return value
         */
        public String getFareComponentReferenceID() {
            return fareComponentReferenceID;
        }

        /** 
         * Set the 'FareComponentReferenceID' attribute value.
         * 
         * @param fareComponentReferenceID
         */
        public void setFareComponentReferenceID(String fareComponentReferenceID) {
            this.fareComponentReferenceID = fareComponentReferenceID;
        }

        /** 
         * Get the 'AccountCode' attribute value. Matched Account Code
         * 
         * @return value
         */
        public String getAccountCode() {
            return accountCode;
        }

        /** 
         * Set the 'AccountCode' attribute value. Matched Account Code
         * 
         * @param accountCode
         */
        public void setAccountCode(String accountCode) {
            this.accountCode = accountCode;
        }

        /** 
         * Get the 'Mileage' attribute value. Mileage (AWARD Shopping)
         * 
         * @return value
         */
        public Integer getMileage() {
            return mileage;
        }

        /** 
         * Set the 'Mileage' attribute value. Mileage (AWARD Shopping)
         * 
         * @param mileage
         */
        public void setMileage(Integer mileage) {
            this.mileage = mileage;
        }

        /** 
         * Get the 'BookingCode' attribute value. Booking code
         * 
         * @return value
         */
        public String getBookingCode() {
            return bookingCode;
        }

        /** 
         * Set the 'BookingCode' attribute value. Booking code
         * 
         * @param bookingCode
         */
        public void setBookingCode(String bookingCode) {
            this.bookingCode = bookingCode;
        }

        /** 
         * Get the 'AvailabilityBreak' attribute value. Availability break after this segment
         * 
         * @return value
         */
        public Boolean getAvailabilityBreak() {
            return availabilityBreak;
        }

        /** 
         * Set the 'AvailabilityBreak' attribute value. Availability break after this segment
         * 
         * @param availabilityBreak
         */
        public void setAvailabilityBreak(Boolean availabilityBreak) {
            this.availabilityBreak = availabilityBreak;
        }

        /** 
         * Get the 'DepartureAirportCode' attribute value. Departure point of flight segment.
         * 
         * @return value
         */
        public String getDepartureAirportCode() {
            return departureAirportCode;
        }

        /** 
         * Set the 'DepartureAirportCode' attribute value. Departure point of flight segment.
         * 
         * @param departureAirportCode
         */
        public void setDepartureAirportCode(String departureAirportCode) {
            this.departureAirportCode = departureAirportCode;
        }

        /** 
         * Get the 'ArrivalAirportCode' attribute value. Arrival point of flight segment.
         * 
         * @return value
         */
        public String getArrivalAirportCode() {
            return arrivalAirportCode;
        }

        /** 
         * Set the 'ArrivalAirportCode' attribute value. Arrival point of flight segment.
         * 
         * @param arrivalAirportCode
         */
        public void setArrivalAirportCode(String arrivalAirportCode) {
            this.arrivalAirportCode = arrivalAirportCode;
        }

        /** 
         * Get the 'FareComponentBeginAirport' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the origin airport of the fare component. 
         * 
         * @return value
         */
        public String getFareComponentBeginAirport() {
            return fareComponentBeginAirport;
        }

        /** 
         * Set the 'FareComponentBeginAirport' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the origin airport of the fare component. 
         * 
         * @param fareComponentBeginAirport
         */
        public void setFareComponentBeginAirport(
                String fareComponentBeginAirport) {
            this.fareComponentBeginAirport = fareComponentBeginAirport;
        }

        /** 
         * Get the 'FareComponentEndAirport' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the destination airport of the fare component. 
         * 
         * @return value
         */
        public String getFareComponentEndAirport() {
            return fareComponentEndAirport;
        }

        /** 
         * Set the 'FareComponentEndAirport' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. It represents the destination airport of the fare component. 
         * 
         * @param fareComponentEndAirport
         */
        public void setFareComponentEndAirport(String fareComponentEndAirport) {
            this.fareComponentEndAirport = fareComponentEndAirport;
        }

        /** 
         * Get the 'FareComponentDirectionality' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. If its value is "FROM" it means that fare component origin and destination are ordered the same as the departure and arival airports of the leg. Value "TO" means the opposite ordering of fare component origin and destination.
         * 
         * @return value
         */
        public FareDirectionality getFareComponentDirectionality() {
            return fareComponentDirectionality;
        }

        /** 
         * Set the 'FareComponentDirectionality' attribute value. If this attribute is present, the enclosing FareBasisCode element is the first portion of a new fare component. If its value is "FROM" it means that fare component origin and destination are ordered the same as the departure and arival airports of the leg. Value "TO" means the opposite ordering of fare component origin and destination.
         * 
         * @param fareComponentDirectionality
         */
        public void setFareComponentDirectionality(
                FareDirectionality fareComponentDirectionality) {
            this.fareComponentDirectionality = fareComponentDirectionality;
        }

        /** 
         * Get the 'FareComponentVendorCode' attribute value. Used to specify fare source
         * 
         * @return value
         */
        public String getFareComponentVendorCode() {
            return fareComponentVendorCode;
        }

        /** 
         * Set the 'FareComponentVendorCode' attribute value. Used to specify fare source
         * 
         * @param fareComponentVendorCode
         */
        public void setFareComponentVendorCode(String fareComponentVendorCode) {
            this.fareComponentVendorCode = fareComponentVendorCode;
        }

        /** 
         * Get the 'FareComponentFareTypeBitmap' attribute value. 
                              FareTypeBitmap represents sum of following possible values:
                              0x00 - Normal
                              0x01 - Discounted
                              0x02 - Fare by Rule
                              0x04 - Negotiated
                              0x08 - Private
                              Eg. 0x06 = Fare by Rule  Negotiated
                            
         * 
         * @return value
         */
        public String getFareComponentFareTypeBitmap() {
            return fareComponentFareTypeBitmap;
        }

        /** 
         * Set the 'FareComponentFareTypeBitmap' attribute value. 
                              FareTypeBitmap represents sum of following possible values:
                              0x00 - Normal
                              0x01 - Discounted
                              0x02 - Fare by Rule
                              0x04 - Negotiated
                              0x08 - Private
                              Eg. 0x06 = Fare by Rule  Negotiated
                            
         * 
         * @param fareComponentFareTypeBitmap
         */
        public void setFareComponentFareTypeBitmap(
                String fareComponentFareTypeBitmap) {
            this.fareComponentFareTypeBitmap = fareComponentFareTypeBitmap;
        }

        /** 
         * Get the 'FareComponentFareType' attribute value. Fare type (e.g. FIT, RU) 
         * 
         * @return value
         */
        public String getFareComponentFareType() {
            return fareComponentFareType;
        }

        /** 
         * Set the 'FareComponentFareType' attribute value. Fare type (e.g. FIT, RU) 
         * 
         * @param fareComponentFareType
         */
        public void setFareComponentFareType(String fareComponentFareType) {
            this.fareComponentFareType = fareComponentFareType;
        }

        /** 
         * Get the 'FareComponentFareTariff' attribute value. Fare tariff (e.g. 21) 
         * 
         * @return value
         */
        public String getFareComponentFareTariff() {
            return fareComponentFareTariff;
        }

        /** 
         * Set the 'FareComponentFareTariff' attribute value. Fare tariff (e.g. 21) 
         * 
         * @param fareComponentFareTariff
         */
        public void setFareComponentFareTariff(String fareComponentFareTariff) {
            this.fareComponentFareTariff = fareComponentFareTariff;
        }

        /** 
         * Get the 'FareComponentFareRule' attribute value. FareRule, part of the fare pricing (e.g. 62DD, K0ST), expected if carrier uses them also in ancillaries’ records
         * 
         * @return value
         */
        public String getFareComponentFareRule() {
            return fareComponentFareRule;
        }

        /** 
         * Set the 'FareComponentFareRule' attribute value. FareRule, part of the fare pricing (e.g. 62DD, K0ST), expected if carrier uses them also in ancillaries’ records
         * 
         * @param fareComponentFareRule
         */
        public void setFareComponentFareRule(String fareComponentFareRule) {
            this.fareComponentFareRule = fareComponentFareRule;
        }

        /** 
         * Get the 'FareComponentCabinCode' attribute value. Cabin code (e.g. Y, S)
         * 
         * @return value
         */
        public String getFareComponentCabinCode() {
            return fareComponentCabinCode;
        }

        /** 
         * Set the 'FareComponentCabinCode' attribute value. Cabin code (e.g. Y, S)
         * 
         * @param fareComponentCabinCode
         */
        public void setFareComponentCabinCode(String fareComponentCabinCode) {
            this.fareComponentCabinCode = fareComponentCabinCode;
        }

        /** 
         * Get the 'FareComponentID' attribute value. Fare component number
         * 
         * @return value
         */
        public BigInteger getFareComponentID() {
            return fareComponentID;
        }

        /** 
         * Set the 'FareComponentID' attribute value. Fare component number
         * 
         * @param fareComponentID
         */
        public void setFareComponentID(BigInteger fareComponentID) {
            this.fareComponentID = fareComponentID;
        }

        /** 
         * Get the 'FareComponentAmount' attribute value. Fare component calculation amount
         * 
         * @return value
         */
        public BigDecimal getFareComponentAmount() {
            return fareComponentAmount;
        }

        /** 
         * Set the 'FareComponentAmount' attribute value. Fare component calculation amount
         * 
         * @param fareComponentAmount
         */
        public void setFareComponentAmount(BigDecimal fareComponentAmount) {
            this.fareComponentAmount = fareComponentAmount;
        }

        /** 
         * Get the 'FareComponentCurrency' attribute value. Fare component calculation currency
         * 
         * @return value
         */
        public String getFareComponentCurrency() {
            return fareComponentCurrency;
        }

        /** 
         * Set the 'FareComponentCurrency' attribute value. Fare component calculation currency
         * 
         * @param fareComponentCurrency
         */
        public void setFareComponentCurrency(String fareComponentCurrency) {
            this.fareComponentCurrency = fareComponentCurrency;
        }

        /** 
         * Get the 'GovCarrier' attribute value. Governing carrier
         * 
         * @return value
         */
        public String getGovCarrier() {
            return govCarrier;
        }

        /** 
         * Set the 'GovCarrier' attribute value. Governing carrier
         * 
         * @param govCarrier
         */
        public void setGovCarrier(String govCarrier) {
            this.govCarrier = govCarrier;
        }
    }
    /** 
     * Container for endorsements.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Endorsements" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FreeTextType" name="Endorsement" minOccurs="0" maxOccurs="9"/>
     *       &lt;xs:element type="xs:string" name="TPA_Extensions" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="NonRefundableIndicator"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="NonEndorsableIndicator"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Endorsements implements Serializable
    {
        private List<FreeTextType> endorsementList = new ArrayList<FreeTextType>();
        private String TPAExtensions;
        private Boolean nonRefundableIndicator;
        private Boolean nonEndorsableIndicator;

        /** 
         * Get the list of 'Endorsement' element items. Specifies ticket endorsement information.
         * 
         * @return list
         */
        public List<FreeTextType> getEndorsementList() {
            return endorsementList;
        }

        /** 
         * Set the list of 'Endorsement' element items. Specifies ticket endorsement information.
         * 
         * @param list
         */
        public void setEndorsementList(List<FreeTextType> list) {
            endorsementList = list;
        }

        /** 
         * Get the 'TPA_Extensions' element value.
         * 
         * @return value
         */
        public String getTPAExtensions() {
            return TPAExtensions;
        }

        /** 
         * Set the 'TPA_Extensions' element value.
         * 
         * @param TPAExtensions
         */
        public void setTPAExtensions(String TPAExtensions) {
            this.TPAExtensions = TPAExtensions;
        }

        /** 
         * Get the 'NonRefundableIndicator' attribute value. Indicates whether the ticket is refundable. If true, the ticket is NOT refundable.
         * 
         * @return value
         */
        public Boolean getNonRefundableIndicator() {
            return nonRefundableIndicator;
        }

        /** 
         * Set the 'NonRefundableIndicator' attribute value. Indicates whether the ticket is refundable. If true, the ticket is NOT refundable.
         * 
         * @param nonRefundableIndicator
         */
        public void setNonRefundableIndicator(Boolean nonRefundableIndicator) {
            this.nonRefundableIndicator = nonRefundableIndicator;
        }

        /** 
         * Get the 'NonEndorsableIndicator' attribute value. Indicates whether the ticket is endorsable. If true, the ticket is NOT endorsable.
         * 
         * @return value
         */
        public Boolean getNonEndorsableIndicator() {
            return nonEndorsableIndicator;
        }

        /** 
         * Set the 'NonEndorsableIndicator' attribute value. Indicates whether the ticket is endorsable. If true, the ticket is NOT endorsable.
         * 
         * @param nonEndorsableIndicator
         */
        public void setNonEndorsableIndicator(Boolean nonEndorsableIndicator) {
            this.nonEndorsableIndicator = nonEndorsableIndicator;
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="ns:FareCalcLineType" name="FareCalcLine" minOccurs="0"/>
     *       &lt;xs:element name="FareType" minOccurs="0">
     *         &lt;!-- Reference to inner class FareType -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private FareCalcLineType fareCalcLine;
        private FareType fareType;

        /** 
         * Get the 'FareCalcLine' element value. Fare calculation line.
         * 
         * @return value
         */
        public FareCalcLineType getFareCalcLine() {
            return fareCalcLine;
        }

        /** 
         * Set the 'FareCalcLine' element value. Fare calculation line.
         * 
         * @param fareCalcLine
         */
        public void setFareCalcLine(FareCalcLineType fareCalcLine) {
            this.fareCalcLine = fareCalcLine;
        }

        /** 
         * Get the 'FareType' element value.
         * 
         * @return value
         */
        public FareType getFareType() {
            return fareType;
        }

        /** 
         * Set the 'FareType' element value.
         * 
         * @param fareType
         */
        public void setFareType(FareType fareType) {
            this.fareType = fareType;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:simpleContent>
         *       &lt;xs:extension base="xs:string">
         *         &lt;xs:attribute type="xs:string" name="Name"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:simpleContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareType implements Serializable
        {
            private String string;
            private String name;

            /** 
             * Get the extension value.
             * 
             * @return value
             */
            public String getString() {
                return string;
            }

            /** 
             * Set the extension value.
             * 
             * @param string
             */
            public void setString(String string) {
                this.string = string;
            }

            /** 
             * Get the 'Name' attribute value.
             * 
             * @return value
             */
            public String getName() {
                return name;
            }

            /** 
             * Set the 'Name' attribute value.
             * 
             * @param name
             */
            public void setName(String name) {
                this.name = name;
            }
        }
    }
    /** 
     * This is a collection of FareInfo
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfos" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FareInfo" maxOccurs="10">
     *         &lt;!-- Reference to inner class FareInfo -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareInfos implements Serializable
    {
        private List<FareInfo> fareInfoList = new ArrayList<FareInfo>();

        /** 
         * Get the list of 'FareInfo' element items.
         * 
         * @return list
         */
        public List<FareInfo> getFareInfoList() {
            return fareInfoList;
        }

        /** 
         * Set the list of 'FareInfo' element items.
         * 
         * @param list
         */
        public void setFareInfoList(List<FareInfo> list) {
            fareInfoList = list;
        }
        /** 
         * Detailed information on individual priced fares
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareInfo" maxOccurs="10">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="xs:string" name="DepartureDate" minOccurs="0"/>
         *       &lt;xs:element type="xs:string" name="FareReference"/>
         *       &lt;xs:element type="ns:RuleInfoType" name="RuleInfo" minOccurs="0"/>
         *       &lt;xs:element type="ns:CompanyNameType" name="MarketingAirline" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:ResponseLocationType" name="DepartureAirport" minOccurs="0"/>
         *       &lt;xs:element type="ns:ResponseLocationType" name="ArrivalAirport" minOccurs="0"/>
         *       &lt;xs:element type="ns:FareInfo_TPA_ExtensionsType" name="TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:NegotiatedFareAttributes"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareInfo implements Serializable
        {
            private String departureDate;
            private String fareReference;
            private RuleInfoType ruleInfo;
            private List<CompanyNameType> marketingAirlineList = new ArrayList<CompanyNameType>();
            private ResponseLocationType departureAirport;
            private ResponseLocationType arrivalAirport;
            private FareInfoTPAExtensionsType TPAExtensions;
            private NegotiatedFareAttributes negotiatedFareAttributes;

            /** 
             * Get the 'DepartureDate' element value. Departure Date for this priced fare. 
             * 
             * @return value
             */
            public String getDepartureDate() {
                return departureDate;
            }

            /** 
             * Set the 'DepartureDate' element value. Departure Date for this priced fare. 
             * 
             * @param departureDate
             */
            public void setDepartureDate(String departureDate) {
                this.departureDate = departureDate;
            }

            /** 
             * Get the 'FareReference' element value. FareReference is the booking code. 
             * 
             * @return value
             */
            public String getFareReference() {
                return fareReference;
            }

            /** 
             * Set the 'FareReference' element value. FareReference is the booking code. 
             * 
             * @param fareReference
             */
            public void setFareReference(String fareReference) {
                this.fareReference = fareReference;
            }

            /** 
             * Get the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
             * 
             * @return value
             */
            public RuleInfoType getRuleInfo() {
                return ruleInfo;
            }

            /** 
             * Set the 'RuleInfo' element value. Information regarding restrictions governing use of the fare.
             * 
             * @param ruleInfo
             */
            public void setRuleInfo(RuleInfoType ruleInfo) {
                this.ruleInfo = ruleInfo;
            }

            /** 
             * Get the list of 'MarketingAirline' element items. The marketing airline.
             * 
             * @return list
             */
            public List<CompanyNameType> getMarketingAirlineList() {
                return marketingAirlineList;
            }

            /** 
             * Set the list of 'MarketingAirline' element items. The marketing airline.
             * 
             * @param list
             */
            public void setMarketingAirlineList(List<CompanyNameType> list) {
                marketingAirlineList = list;
            }

            /** 
             * Get the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getDepartureAirport() {
                return departureAirport;
            }

            /** 
             * Set the 'DepartureAirport' element value. Departure point of flight segment.
             * 
             * @param departureAirport
             */
            public void setDepartureAirport(
                    ResponseLocationType departureAirport) {
                this.departureAirport = departureAirport;
            }

            /** 
             * Get the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @return value
             */
            public ResponseLocationType getArrivalAirport() {
                return arrivalAirport;
            }

            /** 
             * Set the 'ArrivalAirport' element value. Arrival point of flight segment.
             * 
             * @param arrivalAirport
             */
            public void setArrivalAirport(ResponseLocationType arrivalAirport) {
                this.arrivalAirport = arrivalAirport;
            }

            /** 
             * Get the 'TPA_Extensions' element value.
             * 
             * @return value
             */
            public FareInfoTPAExtensionsType getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(FareInfoTPAExtensionsType TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'NegotiatedFareAttributes' attributeGroup value.
             * 
             * @return value
             */
            public NegotiatedFareAttributes getNegotiatedFareAttributes() {
                return negotiatedFareAttributes;
            }

            /** 
             * Set the 'NegotiatedFareAttributes' attributeGroup value.
             * 
             * @param negotiatedFareAttributes
             */
            public void setNegotiatedFareAttributes(
                    NegotiatedFareAttributes negotiatedFareAttributes) {
                this.negotiatedFareAttributes = negotiatedFareAttributes;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:int">
     *     &lt;xs:enumeration value="1"/>
     *     &lt;xs:enumeration value="2"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ReissueExchange implements Serializable {
        /** 
         * Priced as Reissue
         */
        _1("1"), /** 
                  * Priced as Exchange
                  */
        _2("2");
        private final String value;

        private ReissueExchange(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ReissueExchange convert(String value) {
            for (ReissueExchange inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
