
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Specifies passenger information.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerInfoType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:PassengerTypeQuantityType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:FrequentFlyerPersonNameType" name="PersonName" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="PassengerId"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerInfoType extends PassengerTypeQuantityType implements
    Serializable
{
    private FrequentFlyerPersonNameType personName;
    private String passengerId;

    /** 
     * Get the 'PersonName' element value. Contains passenger information for frequent flyer.
     * 
     * @return value
     */
    public FrequentFlyerPersonNameType getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. Contains passenger information for frequent flyer.
     * 
     * @param personName
     */
    public void setPersonName(FrequentFlyerPersonNameType personName) {
        this.personName = personName;
    }

    /** 
     * Get the 'PassengerId' attribute value. Unique identifier of passenger.
     * 
     * @return value
     */
    public String getPassengerId() {
        return passengerId;
    }

    /** 
     * Set the 'PassengerId' attribute value. Unique identifier of passenger.
     * 
     * @param passengerId
     */
    public void setPassengerId(String passengerId) {
        this.passengerId = passengerId;
    }
}
