
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;
import java.sql.Date;

/** 
 * 
 Specifies a PTC (Passenger Type Code) and the associated number of PTC's - for use in specifying passenger lists.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerTypeQuantityType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:TravelerCountType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *           &lt;!-- Reference to inner class TPAExtensions -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *       &lt;xs:attribute type="xs:string" use="optional" name="Alias"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Changeable"/>
 *       &lt;xs:attribute type="xs:int" name="Index"/>
 *       &lt;xs:attribute type="xs:integer" use="optional" name="RequestedPassengerIndex"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PassengerTypeQuantityType extends TravelerCountType implements
    Serializable
{
    private TPAExtensions TPAExtensions1;
    private String alias;
    private Boolean changeable;
    private Integer index;
    private BigInteger requestedPassengerIndex;

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'Alias' attribute value. Contains long passanger name from DC
     * 
     * @return value
     */
    public String getAlias() {
        return alias;
    }

    /** 
     * Set the 'Alias' attribute value. Contains long passanger name from DC
     * 
     * @param alias
     */
    public void setAlias(String alias) {
        this.alias = alias;
    }

    /** 
     * Get the 'Changeable' attribute value.
     * 
     * @return value
     */
    public Boolean getChangeable() {
        return changeable;
    }

    /** 
     * Set the 'Changeable' attribute value.
     * 
     * @param changeable
     */
    public void setChangeable(Boolean changeable) {
        this.changeable = changeable;
    }

    /** 
     * Get the 'Index' attribute value. 
                              Allows to identify which one of requested passengers this solution relates to.
                          
     * 
     * @return value
     */
    public Integer getIndex() {
        return index;
    }

    /** 
     * Set the 'Index' attribute value. 
                              Allows to identify which one of requested passengers this solution relates to.
                          
     * 
     * @param index
     */
    public void setIndex(Integer index) {
        this.index = index;
    }

    /** 
     * Get the 'RequestedPassengerIndex' attribute value. 
                              Allows to identify which one of requested passenger groups from Exchange request this solution relates to.
                          
     * 
     * @return value
     */
    public BigInteger getRequestedPassengerIndex() {
        return requestedPassengerIndex;
    }

    /** 
     * Set the 'RequestedPassengerIndex' attribute value. 
                              Allows to identify which one of requested passenger groups from Exchange request this solution relates to.
                          
     * 
     * @param requestedPassengerIndex
     */
    public void setRequestedPassengerIndex(BigInteger requestedPassengerIndex) {
        this.requestedPassengerIndex = requestedPassengerIndex;
    }
    /** 
     * 
                                  Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
                              
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="BirthDate" minOccurs="0">
     *         &lt;!-- Reference to inner class BirthDate -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Age" minOccurs="0">
     *         &lt;!-- Reference to inner class Age -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="State" minOccurs="0">
     *         &lt;!-- Reference to inner class State -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TotalNumber" minOccurs="0">
     *         &lt;!-- Reference to inner class TotalNumber -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:VoluntaryChangesSMPType" name="VoluntaryChanges" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private BirthDate birthDate;
        private Age age;
        private State state;
        private TotalNumber totalNumber;
        private VoluntaryChangesSMPType voluntaryChanges;

        /** 
         * Get the 'BirthDate' element value.
         * 
         * @return value
         */
        public BirthDate getBirthDate() {
            return birthDate;
        }

        /** 
         * Set the 'BirthDate' element value.
         * 
         * @param birthDate
         */
        public void setBirthDate(BirthDate birthDate) {
            this.birthDate = birthDate;
        }

        /** 
         * Get the 'Age' element value.
         * 
         * @return value
         */
        public Age getAge() {
            return age;
        }

        /** 
         * Set the 'Age' element value.
         * 
         * @param age
         */
        public void setAge(Age age) {
            this.age = age;
        }

        /** 
         * Get the 'State' element value.
         * 
         * @return value
         */
        public State getState() {
            return state;
        }

        /** 
         * Set the 'State' element value.
         * 
         * @param state
         */
        public void setState(State state) {
            this.state = state;
        }

        /** 
         * Get the 'TotalNumber' element value.
         * 
         * @return value
         */
        public TotalNumber getTotalNumber() {
            return totalNumber;
        }

        /** 
         * Set the 'TotalNumber' element value.
         * 
         * @param totalNumber
         */
        public void setTotalNumber(TotalNumber totalNumber) {
            this.totalNumber = totalNumber;
        }

        /** 
         * Get the 'VoluntaryChanges' element value. 
                                                Identifies whether penalties associated with voluntary changes should be included in the search results.
                                            
         * 
         * @return value
         */
        public VoluntaryChangesSMPType getVoluntaryChanges() {
            return voluntaryChanges;
        }

        /** 
         * Set the 'VoluntaryChanges' element value. 
                                                Identifies whether penalties associated with voluntary changes should be included in the search results.
                                            
         * 
         * @param voluntaryChanges
         */
        public void setVoluntaryChanges(VoluntaryChangesSMPType voluntaryChanges) {
            this.voluntaryChanges = voluntaryChanges;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BirthDate" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:date" name="Date"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BirthDate implements Serializable
        {
            private Date date;

            /** 
             * Get the 'Date' attribute value.
             * 
             * @return value
             */
            public Date getDate() {
                return date;
            }

            /** 
             * Set the 'Date' attribute value.
             * 
             * @param date
             */
            public void setDate(Date date) {
                this.date = date;
            }
        }
        /** 
         * Exchange-specific
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Age" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Years"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Age implements Serializable
        {
            private short years;

            /** 
             * Get the 'Years' attribute value.
             * 
             * @return value
             */
            public short getYears() {
                return years;
            }

            /** 
             * Set the 'Years' attribute value.
             * 
             * @param years
             */
            public void setYears(short years) {
                this.years = years;
            }
        }
        /** 
         * Exchange-specific
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="State" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class State implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * Exchange-specific
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TotalNumber" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TotalNumber implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
    }
}
