
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PollingStatusType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="received"/>
 *     &lt;xs:enumeration value="in progress"/>
 *     &lt;xs:enumeration value="complete"/>
 *     &lt;xs:enumeration value="error"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum PollingStatusType implements Serializable {
    RECEIVED("received"), INPROGRESS("in progress"), COMPLETE("complete"), ERROR(
            "error");
    private final String value;

    private PollingStatusType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static PollingStatusType convert(String value) {
        for (PollingStatusType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
