
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 This describes electric power access in a given cabin. These alements are later referenced from FlightAmenities

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PowerAmenityType">
 *   &lt;xs:attribute type="xs:integer" use="required" name="Id"/>
 *   &lt;xs:attribute type="ns:AmenityCostType" use="optional" name="Cost"/>
 *   &lt;xs:attribute use="optional" name="Distribution">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Distribution -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute use="optional" name="Type">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PowerAmenityType implements Serializable
{
    private BigInteger id;
    private AmenityCostType cost;
    private Distribution distribution;
    private Type type;

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public BigInteger getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(BigInteger id) {
        this.id = id;
    }

    /** 
     * Get the 'Cost' attribute value.
     * 
     * @return value
     */
    public AmenityCostType getCost() {
        return cost;
    }

    /** 
     * Set the 'Cost' attribute value.
     * 
     * @param cost
     */
    public void setCost(AmenityCostType cost) {
        this.cost = cost;
    }

    /** 
     * Get the 'Distribution' attribute value.
     * 
     * @return value
     */
    public Distribution getDistribution() {
        return distribution;
    }

    /** 
     * Set the 'Distribution' attribute value.
     * 
     * @param distribution
     */
    public void setDistribution(Distribution distribution) {
        this.distribution = distribution;
    }

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="all"/>
     *     &lt;xs:enumeration value="some"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Distribution implements Serializable {
        ALL("all"), SOME("some");
        private final String value;

        private Distribution(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Distribution convert(String value) {
            for (Distribution inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="adapter"/>
     *     &lt;xs:enumeration value="none"/>
     *     &lt;xs:enumeration value="power"/>
     *     &lt;xs:enumeration value="power/usb"/>
     *     &lt;xs:enumeration value="usb"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Type implements Serializable {
        ADAPTER("adapter"), NONE("none"), POWER("power"), POWERUSB("power/usb"), USB(
                "usb");
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Type convert(String value) {
            for (Type inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
