
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Identify pricing source, if negotiated fares are requested and if it is a reprice request.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PriceRequestInformationType">
 *   &lt;xs:sequence>
 *     &lt;xs:choice maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element name="FlightPromotions" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class FlightPromotions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PriceRequestAttributes"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class PriceRequestInformationType implements Serializable
{
    private List<Choice> choiceList = new ArrayList<Choice>();
    private FlightPromotions flightPromotions;
    private TPAExtensions TPAExtensions1;
    private PriceRequestAttributes priceRequestAttributes;

    /** 
     * Get the list of choice items.
     * 
     * @return list
     */
    public List<Choice> getChoiceList() {
        return choiceList;
    }

    /** 
     * Set the list of choice items.
     * 
     * @param list
     */
    public void setChoiceList(List<Choice> list) {
        choiceList = list;
    }

    /** 
     * Get the 'FlightPromotions' element value.
     * 
     * @return value
     */
    public FlightPromotions getFlightPromotions() {
        return flightPromotions;
    }

    /** 
     * Set the 'FlightPromotions' element value.
     * 
     * @param flightPromotions
     */
    public void setFlightPromotions(FlightPromotions flightPromotions) {
        this.flightPromotions = flightPromotions;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'PriceRequestAttributes' attributeGroup value.
     * 
     * @return value
     */
    public PriceRequestAttributes getPriceRequestAttributes() {
        return priceRequestAttributes;
    }

    /** 
     * Set the 'PriceRequestAttributes' attributeGroup value.
     * 
     * @param priceRequestAttributes
     */
    public void setPriceRequestAttributes(
            PriceRequestAttributes priceRequestAttributes) {
        this.priceRequestAttributes = priceRequestAttributes;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:xs="http://www.w3.org/2001/XMLSchema" maxOccurs="unbounded">
     *   &lt;xs:element name="NegotiatedFareCode" minOccurs="0">
     *     &lt;!-- Reference to inner class NegotiatedFareCode -->
     *   &lt;/xs:element>
     *   &lt;xs:element name="AccountCode" minOccurs="0">
     *     &lt;!-- Reference to inner class AccountCode -->
     *   &lt;/xs:element>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceListSelect = -1;
        private static final int NEGOTIATED_FARE_CODE_CHOICE = 0;
        private static final int ACCOUNT_CODE_CHOICE = 1;
        private NegotiatedFareCode negotiatedFareCode;
        private AccountCode accountCode;

        private void setChoiceListSelect(int choice) {
            if (choiceListSelect == -1) {
                choiceListSelect = choice;
            } else if (choiceListSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceListSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceListSelect() {
            choiceListSelect = -1;
        }

        /** 
         * Check if NegotiatedFareCode is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifNegotiatedFareCode() {
            return choiceListSelect == NEGOTIATED_FARE_CODE_CHOICE;
        }

        /** 
         * Get the 'NegotiatedFareCode' element value.
         * 
         * @return value
         */
        public NegotiatedFareCode getNegotiatedFareCode() {
            return negotiatedFareCode;
        }

        /** 
         * Set the 'NegotiatedFareCode' element value.
         * 
         * @param negotiatedFareCode
         */
        public void setNegotiatedFareCode(NegotiatedFareCode negotiatedFareCode) {
            setChoiceListSelect(NEGOTIATED_FARE_CODE_CHOICE);
            this.negotiatedFareCode = negotiatedFareCode;
        }

        /** 
         * Check if AccountCode is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAccountCode() {
            return choiceListSelect == ACCOUNT_CODE_CHOICE;
        }

        /** 
         * Get the 'AccountCode' element value.
         * 
         * @return value
         */
        public AccountCode getAccountCode() {
            return accountCode;
        }

        /** 
         * Set the 'AccountCode' element value.
         * 
         * @param accountCode
         */
        public void setAccountCode(AccountCode accountCode) {
            setChoiceListSelect(ACCOUNT_CODE_CHOICE);
            this.accountCode = accountCode;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NegotiatedFareCode" minOccurs="0">
         *   &lt;xs:complexType mixed="true">
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:CompanyNameType" name="Supplier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="xs:string" name="TPA_Extensions" minOccurs="0"/>
         *     &lt;/xs:sequence>
         *     &lt;xs:attributeGroup ref="ns:CodeListAirGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NegotiatedFareCode implements Serializable
        {
            private List<CompanyNameType> supplierList = new ArrayList<CompanyNameType>();
            private String TPAExtensions;
            private CodeListAirGroup codeListAirGroup;

            /** 
             * Get the list of 'Supplier' element items. This element indicates the supplier associated with a negotiated fare code.
             * 
             * @return list
             */
            public List<CompanyNameType> getSupplierList() {
                return supplierList;
            }

            /** 
             * Set the list of 'Supplier' element items. This element indicates the supplier associated with a negotiated fare code.
             * 
             * @param list
             */
            public void setSupplierList(List<CompanyNameType> list) {
                supplierList = list;
            }

            /** 
             * Get the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @return value
             */
            public String getTPAExtensions() {
                return TPAExtensions;
            }

            /** 
             * Set the 'TPA_Extensions' element value. This is a place holder for additional elements.
             * 
             * @param TPAExtensions
             */
            public void setTPAExtensions(String TPAExtensions) {
                this.TPAExtensions = TPAExtensions;
            }

            /** 
             * Get the 'CodeListAirGroup' attributeGroup value.
             * 
             * @return value
             */
            public CodeListAirGroup getCodeListAirGroup() {
                return codeListAirGroup;
            }

            /** 
             * Set the 'CodeListAirGroup' attributeGroup value.
             * 
             * @param codeListAirGroup
             */
            public void setCodeListAirGroup(CodeListAirGroup codeListAirGroup) {
                this.codeListAirGroup = codeListAirGroup;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountCode" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AccountCode implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Information used to apply flight promotions.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightPromotions" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PromoCode" minOccurs="0" maxOccurs="99">
     *         &lt;!-- Reference to inner class PromoCode -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="TrendIndicator" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class TrendIndicator -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FlightPromotions implements Serializable
    {
        private List<PromoCode> promoCodeList = new ArrayList<PromoCode>();
        private TrendIndicator trendIndicator;

        /** 
         * Get the list of 'PromoCode' element items.
         * 
         * @return list
         */
        public List<PromoCode> getPromoCodeList() {
            return promoCodeList;
        }

        /** 
         * Set the list of 'PromoCode' element items.
         * 
         * @param list
         */
        public void setPromoCodeList(List<PromoCode> list) {
            promoCodeList = list;
        }

        /** 
         * Get the 'TrendIndicator' element value.
         * 
         * @return value
         */
        public TrendIndicator getTrendIndicator() {
            return trendIndicator;
        }

        /** 
         * Set the 'TrendIndicator' element value.
         * 
         * @param trendIndicator
         */
        public void setTrendIndicator(TrendIndicator trendIndicator) {
            this.trendIndicator = trendIndicator;
        }
        /** 
         * Promotion Code (or Codes) used to determine applicable promotion.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PromoCode" minOccurs="0" maxOccurs="99">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PromoCode implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Additional text indicator that can be used to trigger promotion rules on matching value.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TrendIndicator" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TrendIndicator implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PublicFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PublicFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PrivateFare" minOccurs="0">
     *         &lt;!-- Reference to inner class PrivateFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="IATAFare" minOccurs="0">
     *         &lt;!-- Reference to inner class IATAFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="WebFare" minOccurs="0">
     *         &lt;!-- Reference to inner class WebFare -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Priority" minOccurs="0">
     *         &lt;!-- Reference to inner class Priority -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Indicators" minOccurs="0">
     *         &lt;!-- Reference to inner class Indicators -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="PromoID" minOccurs="0"/>
     *       &lt;xs:element name="CustomerType" minOccurs="0">
     *         &lt;!-- Reference to inner class CustomerType -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MultipleTravelerGroups" minOccurs="0">
     *         &lt;!-- Reference to inner class MultipleTravelerGroups -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BrandedFareIndicators" minOccurs="0">
     *         &lt;!-- Reference to inner class BrandedFareIndicators -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="PassengerStatus" minOccurs="0">
     *         &lt;!-- Reference to inner class PassengerStatus -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:PointOfSaleOverrideType" name="PointOfSaleOverride" minOccurs="0"/>
     *       &lt;xs:element type="ns:PointOfTicketingOverrideType" name="PointOfTicketingOverride" minOccurs="0"/>
     *       &lt;xs:element type="ns:ApplyResidentDiscountType" name="ApplyResidentDiscount" minOccurs="0"/>
     *       &lt;xs:element name="ETicketableOverride" minOccurs="0">
     *         &lt;!-- Reference to inner class ETicketableOverride -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Currency" minOccurs="0">
     *         &lt;!-- Reference to inner class Currency -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UseReducedConstructions" minOccurs="0">
     *         &lt;!-- Reference to inner class UseReducedConstructions -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OBFees" minOccurs="0">
     *         &lt;!-- Reference to inner class OBFees -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ThroughFares" minOccurs="0">
     *         &lt;!-- Reference to inner class ThroughFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareAdjustment" minOccurs="0" maxOccurs="2">
     *         &lt;!-- Reference to inner class FareAdjustment -->
     *       &lt;/xs:element>
     *       &lt;xs:choice>
     *         &lt;xs:element type="ns:PassengerPriceAdjustmentType" name="PassengerPriceAdjustment" minOccurs="0" maxOccurs="unbounded"/>
     *         &lt;xs:element type="ns:PriceAdjustmentType" name="PriceAdjustment" minOccurs="0" maxOccurs="1"/>
     *       &lt;/xs:choice>
     *       &lt;xs:element name="ForceCompanion" minOccurs="0">
     *         &lt;!-- Reference to inner class ForceCompanion -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UsePassengerFares" minOccurs="0">
     *         &lt;!-- Reference to inner class UsePassengerFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="UseNegotiatedFares" minOccurs="0">
     *         &lt;!-- Reference to inner class UseNegotiatedFares -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ShelvesIndicators" minOccurs="0">
     *         &lt;!-- Reference to inner class ShelvesIndicators -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="BundledOffers" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class BundledOffers -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private PublicFare publicFare;
        private PrivateFare privateFare;
        private IATAFare IATAFare1;
        private WebFare webFare;
        private Priority priority;
        private Indicators indicators;
        private String promoID;
        private CustomerType customerType;
        private MultipleTravelerGroups multipleTravelerGroups;
        private BrandedFareIndicators brandedFareIndicators;
        private PassengerStatus passengerStatus;
        private PointOfSaleOverrideType pointOfSaleOverride;
        private PointOfTicketingOverrideType pointOfTicketingOverride;
        private ApplyResidentDiscountType applyResidentDiscount;
        private ETicketableOverride ETicketableOverride1;
        private Currency currency;
        private UseReducedConstructions useReducedConstructions;
        private OBFees OBFees1;
        private ThroughFares throughFares;
        private List<FareAdjustment> fareAdjustmentList = new ArrayList<FareAdjustment>();
        private int choiceSelect = -1;
        private static final int PASSENGER_PRICE_ADJUSTMENT_LIST_CHOICE = 0;
        private static final int PRICE_ADJUSTMENT_CHOICE = 1;
        private List<PassengerPriceAdjustmentType> passengerPriceAdjustmentList = new ArrayList<PassengerPriceAdjustmentType>();
        private PriceAdjustmentType priceAdjustment;
        private ForceCompanion forceCompanion;
        private UsePassengerFares usePassengerFares;
        private UseNegotiatedFares useNegotiatedFares;
        private ShelvesIndicators shelvesIndicators;
        private BundledOffers bundledOffers;

        /** 
         * Get the 'PublicFare' element value.
         * 
         * @return value
         */
        public PublicFare getPublicFare() {
            return publicFare;
        }

        /** 
         * Set the 'PublicFare' element value.
         * 
         * @param publicFare
         */
        public void setPublicFare(PublicFare publicFare) {
            this.publicFare = publicFare;
        }

        /** 
         * Get the 'PrivateFare' element value.
         * 
         * @return value
         */
        public PrivateFare getPrivateFare() {
            return privateFare;
        }

        /** 
         * Set the 'PrivateFare' element value.
         * 
         * @param privateFare
         */
        public void setPrivateFare(PrivateFare privateFare) {
            this.privateFare = privateFare;
        }

        /** 
         * Get the 'IATAFare' element value.
         * 
         * @return value
         */
        public IATAFare getIATAFare1() {
            return IATAFare1;
        }

        /** 
         * Set the 'IATAFare' element value.
         * 
         * @param IATAFare1
         */
        public void setIATAFare1(IATAFare IATAFare1) {
            this.IATAFare1 = IATAFare1;
        }

        /** 
         * Get the 'WebFare' element value.
         * 
         * @return value
         */
        public WebFare getWebFare() {
            return webFare;
        }

        /** 
         * Set the 'WebFare' element value.
         * 
         * @param webFare
         */
        public void setWebFare(WebFare webFare) {
            this.webFare = webFare;
        }

        /** 
         * Get the 'Priority' element value.
         * 
         * @return value
         */
        public Priority getPriority() {
            return priority;
        }

        /** 
         * Set the 'Priority' element value.
         * 
         * @param priority
         */
        public void setPriority(Priority priority) {
            this.priority = priority;
        }

        /** 
         * Get the 'Indicators' element value.
         * 
         * @return value
         */
        public Indicators getIndicators() {
            return indicators;
        }

        /** 
         * Set the 'Indicators' element value.
         * 
         * @param indicators
         */
        public void setIndicators(Indicators indicators) {
            this.indicators = indicators;
        }

        /** 
         * Get the 'PromoID' element value. Promotional Identifier - a string which identifies a promotion, possibly giving a discount prices etc.
         * 
         * @return value
         */
        public String getPromoID() {
            return promoID;
        }

        /** 
         * Set the 'PromoID' element value. Promotional Identifier - a string which identifies a promotion, possibly giving a discount prices etc.
         * 
         * @param promoID
         */
        public void setPromoID(String promoID) {
            this.promoID = promoID;
        }

        /** 
         * Get the 'CustomerType' element value.
         * 
         * @return value
         */
        public CustomerType getCustomerType() {
            return customerType;
        }

        /** 
         * Set the 'CustomerType' element value.
         * 
         * @param customerType
         */
        public void setCustomerType(CustomerType customerType) {
            this.customerType = customerType;
        }

        /** 
         * Get the 'MultipleTravelerGroups' element value.
         * 
         * @return value
         */
        public MultipleTravelerGroups getMultipleTravelerGroups() {
            return multipleTravelerGroups;
        }

        /** 
         * Set the 'MultipleTravelerGroups' element value.
         * 
         * @param multipleTravelerGroups
         */
        public void setMultipleTravelerGroups(
                MultipleTravelerGroups multipleTravelerGroups) {
            this.multipleTravelerGroups = multipleTravelerGroups;
        }

        /** 
         * Get the 'BrandedFareIndicators' element value.
         * 
         * @return value
         */
        public BrandedFareIndicators getBrandedFareIndicators() {
            return brandedFareIndicators;
        }

        /** 
         * Set the 'BrandedFareIndicators' element value.
         * 
         * @param brandedFareIndicators
         */
        public void setBrandedFareIndicators(
                BrandedFareIndicators brandedFareIndicators) {
            this.brandedFareIndicators = brandedFareIndicators;
        }

        /** 
         * Get the 'PassengerStatus' element value.
         * 
         * @return value
         */
        public PassengerStatus getPassengerStatus() {
            return passengerStatus;
        }

        /** 
         * Set the 'PassengerStatus' element value.
         * 
         * @param passengerStatus
         */
        public void setPassengerStatus(PassengerStatus passengerStatus) {
            this.passengerStatus = passengerStatus;
        }

        /** 
         * Get the 'PointOfSaleOverride' element value. Will return the fares available for specified point of sale and priced in this point of sale currency. Currency is overriden by PriceRequestInformation@CurrencyCode.
         * 
         * @return value
         */
        public PointOfSaleOverrideType getPointOfSaleOverride() {
            return pointOfSaleOverride;
        }

        /** 
         * Set the 'PointOfSaleOverride' element value. Will return the fares available for specified point of sale and priced in this point of sale currency. Currency is overriden by PriceRequestInformation@CurrencyCode.
         * 
         * @param pointOfSaleOverride
         */
        public void setPointOfSaleOverride(
                PointOfSaleOverrideType pointOfSaleOverride) {
            this.pointOfSaleOverride = pointOfSaleOverride;
        }

        /** 
         * Get the 'PointOfTicketingOverride' element value.
         * 
         * @return value
         */
        public PointOfTicketingOverrideType getPointOfTicketingOverride() {
            return pointOfTicketingOverride;
        }

        /** 
         * Set the 'PointOfTicketingOverride' element value.
         * 
         * @param pointOfTicketingOverride
         */
        public void setPointOfTicketingOverride(
                PointOfTicketingOverrideType pointOfTicketingOverride) {
            this.pointOfTicketingOverride = pointOfTicketingOverride;
        }

        /** 
         * Get the 'ApplyResidentDiscount' element value. Apply resident discount in CLFE
         * 
         * @return value
         */
        public ApplyResidentDiscountType getApplyResidentDiscount() {
            return applyResidentDiscount;
        }

        /** 
         * Set the 'ApplyResidentDiscount' element value. Apply resident discount in CLFE
         * 
         * @param applyResidentDiscount
         */
        public void setApplyResidentDiscount(
                ApplyResidentDiscountType applyResidentDiscount) {
            this.applyResidentDiscount = applyResidentDiscount;
        }

        /** 
         * Get the 'ETicketableOverride' element value.
         * 
         * @return value
         */
        public ETicketableOverride getETicketableOverride1() {
            return ETicketableOverride1;
        }

        /** 
         * Set the 'ETicketableOverride' element value.
         * 
         * @param ETicketableOverride1
         */
        public void setETicketableOverride1(
                ETicketableOverride ETicketableOverride1) {
            this.ETicketableOverride1 = ETicketableOverride1;
        }

        /** 
         * Get the 'Currency' element value.
         * 
         * @return value
         */
        public Currency getCurrency() {
            return currency;
        }

        /** 
         * Set the 'Currency' element value.
         * 
         * @param currency
         */
        public void setCurrency(Currency currency) {
            this.currency = currency;
        }

        /** 
         * Get the 'UseReducedConstructions' element value.
         * 
         * @return value
         */
        public UseReducedConstructions getUseReducedConstructions() {
            return useReducedConstructions;
        }

        /** 
         * Set the 'UseReducedConstructions' element value.
         * 
         * @param useReducedConstructions
         */
        public void setUseReducedConstructions(
                UseReducedConstructions useReducedConstructions) {
            this.useReducedConstructions = useReducedConstructions;
        }

        /** 
         * Get the 'OBFees' element value.
         * 
         * @return value
         */
        public OBFees getOBFees1() {
            return OBFees1;
        }

        /** 
         * Set the 'OBFees' element value.
         * 
         * @param OBFees1
         */
        public void setOBFees1(OBFees OBFees1) {
            this.OBFees1 = OBFees1;
        }

        /** 
         * Get the 'ThroughFares' element value.
         * 
         * @return value
         */
        public ThroughFares getThroughFares() {
            return throughFares;
        }

        /** 
         * Set the 'ThroughFares' element value.
         * 
         * @param throughFares
         */
        public void setThroughFares(ThroughFares throughFares) {
            this.throughFares = throughFares;
        }

        /** 
         * Get the list of 'FareAdjustment' element items.
         * 
         * @return list
         */
        public List<FareAdjustment> getFareAdjustmentList() {
            return fareAdjustmentList;
        }

        /** 
         * Set the list of 'FareAdjustment' element items.
         * 
         * @param list
         */
        public void setFareAdjustmentList(List<FareAdjustment> list) {
            fareAdjustmentList = list;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if PassengerPriceAdjustmentList is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPassengerPriceAdjustmentList() {
            return choiceSelect == PASSENGER_PRICE_ADJUSTMENT_LIST_CHOICE;
        }

        /** 
         * Get the list of 'PassengerPriceAdjustment' element items.
         * 
         * @return list
         */
        public List<PassengerPriceAdjustmentType> getPassengerPriceAdjustmentList() {
            return passengerPriceAdjustmentList;
        }

        /** 
         * Set the list of 'PassengerPriceAdjustment' element items.
         * 
         * @param list
         */
        public void setPassengerPriceAdjustmentList(
                List<PassengerPriceAdjustmentType> list) {
            setChoiceSelect(PASSENGER_PRICE_ADJUSTMENT_LIST_CHOICE);
            passengerPriceAdjustmentList = list;
        }

        /** 
         * Check if PriceAdjustment is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifPriceAdjustment() {
            return choiceSelect == PRICE_ADJUSTMENT_CHOICE;
        }

        /** 
         * Get the 'PriceAdjustment' element value.
         * 
         * @return value
         */
        public PriceAdjustmentType getPriceAdjustment() {
            return priceAdjustment;
        }

        /** 
         * Set the 'PriceAdjustment' element value.
         * 
         * @param priceAdjustment
         */
        public void setPriceAdjustment(PriceAdjustmentType priceAdjustment) {
            setChoiceSelect(PRICE_ADJUSTMENT_CHOICE);
            this.priceAdjustment = priceAdjustment;
        }

        /** 
         * Get the 'ForceCompanion' element value.
         * 
         * @return value
         */
        public ForceCompanion getForceCompanion() {
            return forceCompanion;
        }

        /** 
         * Set the 'ForceCompanion' element value.
         * 
         * @param forceCompanion
         */
        public void setForceCompanion(ForceCompanion forceCompanion) {
            this.forceCompanion = forceCompanion;
        }

        /** 
         * Get the 'UsePassengerFares' element value.
         * 
         * @return value
         */
        public UsePassengerFares getUsePassengerFares() {
            return usePassengerFares;
        }

        /** 
         * Set the 'UsePassengerFares' element value.
         * 
         * @param usePassengerFares
         */
        public void setUsePassengerFares(UsePassengerFares usePassengerFares) {
            this.usePassengerFares = usePassengerFares;
        }

        /** 
         * Get the 'UseNegotiatedFares' element value.
         * 
         * @return value
         */
        public UseNegotiatedFares getUseNegotiatedFares() {
            return useNegotiatedFares;
        }

        /** 
         * Set the 'UseNegotiatedFares' element value.
         * 
         * @param useNegotiatedFares
         */
        public void setUseNegotiatedFares(UseNegotiatedFares useNegotiatedFares) {
            this.useNegotiatedFares = useNegotiatedFares;
        }

        /** 
         * Get the 'ShelvesIndicators' element value.
         * 
         * @return value
         */
        public ShelvesIndicators getShelvesIndicators() {
            return shelvesIndicators;
        }

        /** 
         * Set the 'ShelvesIndicators' element value.
         * 
         * @param shelvesIndicators
         */
        public void setShelvesIndicators(ShelvesIndicators shelvesIndicators) {
            this.shelvesIndicators = shelvesIndicators;
        }

        /** 
         * Get the 'BundledOffers' element value.
         * 
         * @return value
         */
        public BundledOffers getBundledOffers() {
            return bundledOffers;
        }

        /** 
         * Set the 'BundledOffers' element value.
         * 
         * @param bundledOffers
         */
        public void setBundledOffers(BundledOffers bundledOffers) {
            this.bundledOffers = bundledOffers;
        }
        /** 
         * This element finds only public fares.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PublicFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PublicFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * This element finds only private fares.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PrivateFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PrivateFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * This element finds only IATA fares.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IATAFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class IATAFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="WebFare" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class WebFare implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value. Web fare
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value. Web fare
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * This element governs how flights are returned. A user can uses a priority of 1-9 to make this determination.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Priority" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Price" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class Price -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DirectFlights" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class DirectFlights -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Time" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class Time -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="LegTime" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class LegTime -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Vendor" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class Vendor -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MarketingCarrier" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class MarketingCarrier -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="OperatingCarrier" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class OperatingCarrier -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ElapsedTime" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class ElapsedTime -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="DepartureTime" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class DepartureTime -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ConnectionTime" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class ConnectionTime -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Priority implements Serializable
        {
            private Price price;
            private DirectFlights directFlights;
            private Time time;
            private LegTime legTime;
            private Vendor vendor;
            private MarketingCarrier marketingCarrier;
            private OperatingCarrier operatingCarrier;
            private ElapsedTime elapsedTime;
            private DepartureTime departureTime;
            private ConnectionTime connectionTime;

            /** 
             * Get the 'Price' element value.
             * 
             * @return value
             */
            public Price getPrice() {
                return price;
            }

            /** 
             * Set the 'Price' element value.
             * 
             * @param price
             */
            public void setPrice(Price price) {
                this.price = price;
            }

            /** 
             * Get the 'DirectFlights' element value.
             * 
             * @return value
             */
            public DirectFlights getDirectFlights() {
                return directFlights;
            }

            /** 
             * Set the 'DirectFlights' element value.
             * 
             * @param directFlights
             */
            public void setDirectFlights(DirectFlights directFlights) {
                this.directFlights = directFlights;
            }

            /** 
             * Get the 'Time' element value.
             * 
             * @return value
             */
            public Time getTime() {
                return time;
            }

            /** 
             * Set the 'Time' element value.
             * 
             * @param time
             */
            public void setTime(Time time) {
                this.time = time;
            }

            /** 
             * Get the 'LegTime' element value.
             * 
             * @return value
             */
            public LegTime getLegTime() {
                return legTime;
            }

            /** 
             * Set the 'LegTime' element value.
             * 
             * @param legTime
             */
            public void setLegTime(LegTime legTime) {
                this.legTime = legTime;
            }

            /** 
             * Get the 'Vendor' element value.
             * 
             * @return value
             */
            public Vendor getVendor() {
                return vendor;
            }

            /** 
             * Set the 'Vendor' element value.
             * 
             * @param vendor
             */
            public void setVendor(Vendor vendor) {
                this.vendor = vendor;
            }

            /** 
             * Get the 'MarketingCarrier' element value.
             * 
             * @return value
             */
            public MarketingCarrier getMarketingCarrier() {
                return marketingCarrier;
            }

            /** 
             * Set the 'MarketingCarrier' element value.
             * 
             * @param marketingCarrier
             */
            public void setMarketingCarrier(MarketingCarrier marketingCarrier) {
                this.marketingCarrier = marketingCarrier;
            }

            /** 
             * Get the 'OperatingCarrier' element value.
             * 
             * @return value
             */
            public OperatingCarrier getOperatingCarrier() {
                return operatingCarrier;
            }

            /** 
             * Set the 'OperatingCarrier' element value.
             * 
             * @param operatingCarrier
             */
            public void setOperatingCarrier(OperatingCarrier operatingCarrier) {
                this.operatingCarrier = operatingCarrier;
            }

            /** 
             * Get the 'ElapsedTime' element value.
             * 
             * @return value
             */
            public ElapsedTime getElapsedTime() {
                return elapsedTime;
            }

            /** 
             * Set the 'ElapsedTime' element value.
             * 
             * @param elapsedTime
             */
            public void setElapsedTime(ElapsedTime elapsedTime) {
                this.elapsedTime = elapsedTime;
            }

            /** 
             * Get the 'DepartureTime' element value.
             * 
             * @return value
             */
            public DepartureTime getDepartureTime() {
                return departureTime;
            }

            /** 
             * Set the 'DepartureTime' element value.
             * 
             * @param departureTime
             */
            public void setDepartureTime(DepartureTime departureTime) {
                this.departureTime = departureTime;
            }

            /** 
             * Get the 'ConnectionTime' element value.
             * 
             * @return value
             */
            public ConnectionTime getConnectionTime() {
                return connectionTime;
            }

            /** 
             * Set the 'ConnectionTime' element value.
             * 
             * @param connectionTime
             */
            public void setConnectionTime(ConnectionTime connectionTime) {
                this.connectionTime = connectionTime;
            }
            /** 
             * Prefer cheaper itineraries
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Price" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Price implements Serializable
            {
                private int priority;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }
            }
            /** 
             * Prefer itineraries will less connections
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DirectFlights" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DirectFlights implements Serializable
            {
                private int priority;
                private String leg;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
            }
            /** 
             * Prefer itineraries departing closer to requested departure time
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Time" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Time implements Serializable
            {
                private int priority;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }
            }
            /** 
             * Prefer itineraries departing closer to requested departure time, consecutively for all legs
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LegTime" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class LegTime implements Serializable
            {
                private int priority;
                private String leg;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
            }
            /** 
             * Promote certain marketing carriers over all the others in returning results. (configured in rules).
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Vendor" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Vendor implements Serializable
            {
                private int priority;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }
            }
            /** 
             * Prefer itineraries with marketing carriers in order speciied in Carrier subtags, comparing segment-wise
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MarketingCarrier" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Carrier" minOccurs="1" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Carrier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MarketingCarrier implements Serializable
            {
                private List<Carrier> carrierList = new ArrayList<Carrier>();
                private int priority;
                private String leg;

                /** 
                 * Get the list of 'Carrier' element items.
                 * 
                 * @return list
                 */
                public List<Carrier> getCarrierList() {
                    return carrierList;
                }

                /** 
                 * Set the list of 'Carrier' element items.
                 * 
                 * @param list
                 */
                public void setCarrierList(List<Carrier> list) {
                    carrierList = list;
                }

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
                /** 
                 * Specifies desired order of carriers
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Carrier implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Prefer itineraries with operating carriers in order speciied in Carrier subtags, comparing segment-wise
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingCarrier" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="Carrier" minOccurs="1" maxOccurs="unbounded">
             *         &lt;!-- Reference to inner class Carrier -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class OperatingCarrier implements Serializable
            {
                private List<Carrier> carrierList = new ArrayList<Carrier>();
                private int priority;
                private String leg;

                /** 
                 * Get the list of 'Carrier' element items.
                 * 
                 * @return list
                 */
                public List<Carrier> getCarrierList() {
                    return carrierList;
                }

                /** 
                 * Set the list of 'Carrier' element items.
                 * 
                 * @param list
                 */
                public void setCarrierList(List<Carrier> list) {
                    carrierList = list;
                }

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value. Which leg is most significant one? If inconclusive continue comparisons segment by segment starting from the beginning of itinerary
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
                /** 
                 * Specifies desired order of carriers
                 * 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" minOccurs="1" maxOccurs="unbounded">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class Carrier implements Serializable
                {
                    private String code;

                    /** 
                     * Get the 'Code' attribute value.
                     * 
                     * @return value
                     */
                    public String getCode() {
                        return code;
                    }

                    /** 
                     * Set the 'Code' attribute value.
                     * 
                     * @param code
                     */
                    public void setCode(String code) {
                        this.code = code;
                    }
                }
            }
            /** 
             * Prefer itineraries with shorter travel times
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ElapsedTime" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ElapsedTime implements Serializable
            {
                private int priority;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }
            }
            /** 
             * Prefer itineraries departing earlier during the day
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DepartureTime" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class DepartureTime implements Serializable
            {
                private int priority;
                private String leg;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value.
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value.
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
            }
            /** 
             * Prefer itineraries with smaller amount of time waiting in the airports during connections
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionTime" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:int" use="required" name="Priority"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ConnectionTime implements Serializable
            {
                private int priority;
                private String leg;

                /** 
                 * Get the 'Priority' attribute value.
                 * 
                 * @return value
                 */
                public int getPriority() {
                    return priority;
                }

                /** 
                 * Set the 'Priority' attribute value.
                 * 
                 * @param priority
                 */
                public void setPriority(int priority) {
                    this.priority = priority;
                }

                /** 
                 * Get the 'Leg' attribute value.
                 * 
                 * @return value
                 */
                public String getLeg() {
                    return leg;
                }

                /** 
                 * Set the 'Leg' attribute value.
                 * 
                 * @param leg
                 */
                public void setLeg(String leg) {
                    this.leg = leg;
                }
            }
        }
        /** 
         * This element restricts fares which can be returned in response. If a customer passes this element, all its children should be specified.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Indicators" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="RetainFare" minOccurs="0">
         *         &lt;!-- Reference to inner class RetainFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MinMaxStay" minOccurs="0">
         *         &lt;!-- Reference to inner class MinMaxStay -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="RefundPenalty" minOccurs="0">
         *         &lt;!-- Reference to inner class RefundPenalty -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ResTicketing" minOccurs="0">
         *         &lt;!-- Reference to inner class ResTicketing -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TravelPolicy" minOccurs="0">
         *         &lt;!-- Reference to inner class TravelPolicy -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Indicators implements Serializable
        {
            private RetainFare retainFare;
            private MinMaxStay minMaxStay;
            private RefundPenalty refundPenalty;
            private ResTicketing resTicketing;
            private TravelPolicy travelPolicy;

            /** 
             * Get the 'RetainFare' element value.
             * 
             * @return value
             */
            public RetainFare getRetainFare() {
                return retainFare;
            }

            /** 
             * Set the 'RetainFare' element value.
             * 
             * @param retainFare
             */
            public void setRetainFare(RetainFare retainFare) {
                this.retainFare = retainFare;
            }

            /** 
             * Get the 'MinMaxStay' element value.
             * 
             * @return value
             */
            public MinMaxStay getMinMaxStay() {
                return minMaxStay;
            }

            /** 
             * Set the 'MinMaxStay' element value.
             * 
             * @param minMaxStay
             */
            public void setMinMaxStay(MinMaxStay minMaxStay) {
                this.minMaxStay = minMaxStay;
            }

            /** 
             * Get the 'RefundPenalty' element value.
             * 
             * @return value
             */
            public RefundPenalty getRefundPenalty() {
                return refundPenalty;
            }

            /** 
             * Set the 'RefundPenalty' element value.
             * 
             * @param refundPenalty
             */
            public void setRefundPenalty(RefundPenalty refundPenalty) {
                this.refundPenalty = refundPenalty;
            }

            /** 
             * Get the 'ResTicketing' element value.
             * 
             * @return value
             */
            public ResTicketing getResTicketing() {
                return resTicketing;
            }

            /** 
             * Set the 'ResTicketing' element value.
             * 
             * @param resTicketing
             */
            public void setResTicketing(ResTicketing resTicketing) {
                this.resTicketing = resTicketing;
            }

            /** 
             * Get the 'TravelPolicy' element value.
             * 
             * @return value
             */
            public TravelPolicy getTravelPolicy() {
                return travelPolicy;
            }

            /** 
             * Set the 'TravelPolicy' element value.
             * 
             * @param travelPolicy
             */
            public void setTravelPolicy(TravelPolicy travelPolicy) {
                this.travelPolicy = travelPolicy;
            }
            /** 
             * Currently must be set to true.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RetainFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RetainFare implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * If set to true, fares that have a min/max stay can be included in the responses. If set to false, then no fares that include a min/max stay requirement will be included in the response.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MinMaxStay" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MinMaxStay implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * If set to true, fares that have a refund penalty can be included in the responses. If set to false, then no fares that include a refund penalty requirement will be included in the response.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RefundPenalty" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class RefundPenalty implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * If set to true, fares that have a reservation/ticketing can be included in the responses. If set to false, then no fares that include reservation/ticketing requirement will be included in the response.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ResTicketing" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ResTicketing implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
            /** 
             * This element is currently ignored whether it is true or false.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelPolicy" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TravelPolicy implements Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute use="required" name="Value">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Value -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CustomerType implements Serializable
        {
            private Value value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Value getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Value value) {
                this.value = value;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="REGULAR"/>
             *     &lt;xs:enumeration value="TVLYPREF"/>
             *     &lt;xs:enumeration value="PREFELITE"/>
             *     &lt;xs:enumeration value="LOYALTY"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Value implements Serializable {
                /** 
                 * Regular customer type.
                 */
                REGULAR, /** 
                          * TVLY_PREFERRED customer type.
                          */
                TVLYPREF, /** 
                           * PREFERED_ELITE customer type.
                           */
                PREFELITE, /** 
                            * LOYALTY customer type.
                            */
                LOYALTY
            }
        }
        /** 
         * This element governs how flights are returned when multiple passenger groups are requested.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleTravelerGroups" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" name="ItinerariesPerGroup"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MultipleTravelerGroups implements Serializable
        {
            private BigInteger itinerariesPerGroup;

            /** 
             * Get the 'ItinerariesPerGroup' attribute value. Indicates desired number of itineraries to be returned in each passenger group at beggining of response.
             * 
             * @return value
             */
            public BigInteger getItinerariesPerGroup() {
                return itinerariesPerGroup;
            }

            /** 
             * Set the 'ItinerariesPerGroup' attribute value. Indicates desired number of itineraries to be returned in each passenger group at beggining of response.
             * 
             * @param itinerariesPerGroup
             */
            public void setItinerariesPerGroup(BigInteger itinerariesPerGroup) {
                this.itinerariesPerGroup = itinerariesPerGroup;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedFareIndicators" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:complexContent>
         *       &lt;xs:extension base="ns:BrandedFareIndicatorsBase">
         *         &lt;xs:sequence>
         *           &lt;xs:element name="ReturnCheapestUnbrandedFare" minOccurs="0">
         *             &lt;!-- Reference to inner class ReturnCheapestUnbrandedFare -->
         *           &lt;/xs:element>
         *         &lt;/xs:sequence>
         *         &lt;xs:attribute type="xs:boolean" use="optional" name="ReturnBrandAncillaries"/>
         *       &lt;/xs:extension>
         *     &lt;/xs:complexContent>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BrandedFareIndicators
                extends
                    BrandedFareIndicatorsBase implements Serializable
        {
            private ReturnCheapestUnbrandedFare returnCheapestUnbrandedFare;
            private Boolean returnBrandAncillaries;

            /** 
             * Get the 'ReturnCheapestUnbrandedFare' element value.
             * 
             * @return value
             */
            public ReturnCheapestUnbrandedFare getReturnCheapestUnbrandedFare() {
                return returnCheapestUnbrandedFare;
            }

            /** 
             * Set the 'ReturnCheapestUnbrandedFare' element value.
             * 
             * @param returnCheapestUnbrandedFare
             */
            public void setReturnCheapestUnbrandedFare(
                    ReturnCheapestUnbrandedFare returnCheapestUnbrandedFare) {
                this.returnCheapestUnbrandedFare = returnCheapestUnbrandedFare;
            }

            /** 
             * Get the 'ReturnBrandAncillaries' attribute value. Return ancillaries from the ATPCO Branded Fares Feature Table 166
             * 
             * @return value
             */
            public Boolean getReturnBrandAncillaries() {
                return returnBrandAncillaries;
            }

            /** 
             * Set the 'ReturnBrandAncillaries' attribute value. Return ancillaries from the ATPCO Branded Fares Feature Table 166
             * 
             * @param returnBrandAncillaries
             */
            public void setReturnBrandAncillaries(Boolean returnBrandAncillaries) {
                this.returnBrandAncillaries = returnBrandAncillaries;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReturnCheapestUnbrandedFare" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ReturnCheapestUnbrandedFare implements
                Serializable
            {
                private boolean ind;

                /** 
                 * Get the 'Ind' attribute value. Indicator to turn on or off return of cheapest unbranded fare referred as "catch all" fare for the branded carriers from the branded fares service.
                 * 
                 * @return value
                 */
                public boolean isInd() {
                    return ind;
                }

                /** 
                 * Set the 'Ind' attribute value. Indicator to turn on or off return of cheapest unbranded fare referred as "catch all" fare for the branded carriers from the branded fares service.
                 * 
                 * @param ind
                 */
                public void setInd(boolean ind) {
                    this.ind = ind;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PassengerStatus" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:sequence>
         *         &lt;!-- Reference to inner class Sequence -->
         *       &lt;/xs:sequence>
         *       &lt;xs:element type="xs:string" name="CityCode"/>
         *     &lt;/xs:choice>
         *     &lt;xs:attribute use="required" name="Type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PassengerStatus implements Serializable
        {
            private int choiceSelect = -1;
            private static final int STATE_CODE_CHOICE = 0;
            private static final int CITY_CODE_CHOICE = 1;
            private Sequence stateCode;
            private String cityCode;
            private Type type;

            private void setChoiceSelect(int choice) {
                if (choiceSelect == -1) {
                    choiceSelect = choice;
                } else if (choiceSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearChoiceSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearChoiceSelect() {
                choiceSelect = -1;
            }

            /** 
             * Check if StateCode is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifStateCode() {
                return choiceSelect == STATE_CODE_CHOICE;
            }

            /** 
             * Get the sequence value.
             * 
             * @return value
             */
            public Sequence getStateCode() {
                return stateCode;
            }

            /** 
             * Set the sequence value.
             * 
             * @param stateCode
             */
            public void setStateCode(Sequence stateCode) {
                setChoiceSelect(STATE_CODE_CHOICE);
                this.stateCode = stateCode;
            }

            /** 
             * Check if CityCode is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifCityCode() {
                return choiceSelect == CITY_CODE_CHOICE;
            }

            /** 
             * Get the 'CityCode' element value.
             * 
             * @return value
             */
            public String getCityCode() {
                return cityCode;
            }

            /** 
             * Set the 'CityCode' element value.
             * 
             * @param cityCode
             */
            public void setCityCode(String cityCode) {
                setChoiceSelect(CITY_CODE_CHOICE);
                this.cityCode = cityCode;
            }

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:sequence xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:element type="xs:string" name="StateCode" minOccurs="0"/>
             *   &lt;xs:element type="xs:string" name="CountryCode"/>
             * &lt;/xs:sequence>
             * </pre>
             */
            public static class Sequence implements Serializable
            {
                private String stateCode;
                private String countryCode;

                /** 
                 * Get the 'StateCode' element value.
                 * 
                 * @return value
                 */
                public String getStateCode() {
                    return stateCode;
                }

                /** 
                 * Set the 'StateCode' element value.
                 * 
                 * @param stateCode
                 */
                public void setStateCode(String stateCode) {
                    this.stateCode = stateCode;
                }

                /** 
                 * Get the 'CountryCode' element value.
                 * 
                 * @return value
                 */
                public String getCountryCode() {
                    return countryCode;
                }

                /** 
                 * Set the 'CountryCode' element value.
                 * 
                 * @param countryCode
                 */
                public void setCountryCode(String countryCode) {
                    this.countryCode = countryCode;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="R"/>
             *     &lt;xs:enumeration value="E"/>
             *     &lt;xs:enumeration value="N"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                /** 
                 * Residency.
                 */
                R, /** 
                    * Employment.
                    */
                E, /** 
                    * Nationality.
                    */
                N
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ETicketableOverride" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ETicketableOverride implements Serializable
        {
            private Boolean value;

            /** 
             * Get the 'Value' attribute value. ETicketable override
             * 
             * @return value
             */
            public Boolean getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. ETicketable override
             * 
             * @param value
             */
            public void setValue(Boolean value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Currency" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Dual"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="MOverride"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Currency implements Serializable
        {
            private String dual;
            private Boolean MOverride;

            /** 
             * Get the 'Dual' attribute value. Dual currency
             * 
             * @return value
             */
            public String getDual() {
                return dual;
            }

            /** 
             * Set the 'Dual' attribute value. Dual currency
             * 
             * @param dual
             */
            public void setDual(String dual) {
                this.dual = dual;
            }

            /** 
             * Get the 'MOverride' attribute value. M override
             * 
             * @return value
             */
            public Boolean getMOverride() {
                return MOverride;
            }

            /** 
             * Set the 'MOverride' attribute value. M override
             * 
             * @param MOverride
             */
            public void setMOverride(Boolean MOverride) {
                this.MOverride = MOverride;
            }
        }
        /** 
         * Use reduced constructions (simple fare paths with restrictions on the number of fare components).
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UseReducedConstructions" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UseReducedConstructions implements Serializable
        {
            private Boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public Boolean getInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(Boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OBFees" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="RType"/>
         *     &lt;xs:attribute type="xs:boolean" name="TType"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OBFees implements Serializable
        {
            private Boolean RType;
            private Boolean TType;

            /** 
             * Get the 'RType' attribute value. Indicator Returning R-Type OB Fees
             * 
             * @return value
             */
            public Boolean getRType() {
                return RType;
            }

            /** 
             * Set the 'RType' attribute value. Indicator Returning R-Type OB Fees
             * 
             * @param RType
             */
            public void setRType(Boolean RType) {
                this.RType = RType;
            }

            /** 
             * Get the 'TType' attribute value. Indicator Returning T-Type OB Fees
             * 
             * @return value
             */
            public Boolean getTType() {
                return TType;
            }

            /** 
             * Set the 'TType' attribute value. Indicator Returning T-Type OB Fees
             * 
             * @param TType
             */
            public void setTType(Boolean TType) {
                this.TType = TType;
            }
        }
        /** 
         * 
                      Controls how through fares (fares that span across two or more legs) are handled when split-price-by-leg is requested.
                  
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ThroughFares" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute use="required" name="PriceAssignment">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class PriceAssignment -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ThroughFares implements Serializable
        {
            private PriceAssignment priceAssignment;

            /** 
             * Get the 'PriceAssignment' attribute value. 
                            Disallow - excludes through fares when determining itinerary prices;
                            Proportional Price Split - Price resulting from the through fare is distributed proportionally between affected legs;
                            Price in First Leg - Price resulting from the through fare is assigned to the first leg that the fare applies to;
                          
             * 
             * @return value
             */
            public PriceAssignment getPriceAssignment() {
                return priceAssignment;
            }

            /** 
             * Set the 'PriceAssignment' attribute value. 
                            Disallow - excludes through fares when determining itinerary prices;
                            Proportional Price Split - Price resulting from the through fare is distributed proportionally between affected legs;
                            Price in First Leg - Price resulting from the through fare is assigned to the first leg that the fare applies to;
                          
             * 
             * @param priceAssignment
             */
            public void setPriceAssignment(PriceAssignment priceAssignment) {
                this.priceAssignment = priceAssignment;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="Proportional"/>
             *     &lt;xs:enumeration value="InFirstLeg"/>
             *     &lt;xs:enumeration value="Disallow"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum PriceAssignment implements Serializable {
                PROPORTIONAL("Proportional"), IN_FIRST_LEG("InFirstLeg"), DISALLOW(
                        "Disallow");
                private final String value;

                private PriceAssignment(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static PriceAssignment convert(String value) {
                    for (PriceAssignment inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
        /** 
         * Capability to specify Plus-Up and Discount Amount and Percentage.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareAdjustment" minOccurs="0" maxOccurs="2">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *     &lt;xs:attribute type="xs:string" name="Currency"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareAdjustment implements Serializable
        {
            private String value;
            private String currency;

            /** 
             * Get the 'Value' attribute value. Adjustment Value, can be positive or negative, number or percentage
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Adjustment Value, can be positive or negative, number or percentage
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }

            /** 
             * Get the 'Currency' attribute value. Currency of Adjustment's Value
             * 
             * @return value
             */
            public String getCurrency() {
                return currency;
            }

            /** 
             * Set the 'Currency' attribute value. Currency of Adjustment's Value
             * 
             * @param currency
             */
            public void setCurrency(String currency) {
                this.currency = currency;
            }
        }
        /** 
         * Force companion fare value.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceCompanion" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ForceCompanion implements Serializable
        {
            private BigDecimal value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public BigDecimal getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(BigDecimal value) {
                this.value = value;
            }
        }
        /** 
         * At least one fare component for each passenger type must be applicable for that passenger type.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UsePassengerFares" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UsePassengerFares implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Returned fares need to match AcccountCode/CorporateID on at least one fare component.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="UseNegotiatedFares" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UseNegotiatedFares implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Requested shelves indicators
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShelvesIndicators" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Mode"/>
         *     &lt;xs:attribute type="xs:integer" use="optional" name="Limit"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ShelvesIndicators implements Serializable
        {
            private String mode;
            private BigInteger limit;

            /** 
             * Get the 'Mode' attribute value.
             * 
             * @return value
             */
            public String getMode() {
                return mode;
            }

            /** 
             * Set the 'Mode' attribute value.
             * 
             * @param mode
             */
            public void setMode(String mode) {
                this.mode = mode;
            }

            /** 
             * Get the 'Limit' attribute value. Indicates maximum number of requested shelves
             * 
             * @return value
             */
            public BigInteger getLimit() {
                return limit;
            }

            /** 
             * Set the 'Limit' attribute value. Indicates maximum number of requested shelves
             * 
             * @param limit
             */
            public void setLimit(BigInteger limit) {
                this.limit = limit;
            }
        }
        /** 
         * A bundle offer consists of an air fare plus chargeable ancillaries based on shelf definition or flex fare.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BundledOffers" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Enable"/>
         *     &lt;xs:attribute type="xs:string" name="BundleId"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class BundledOffers implements Serializable
        {
            private boolean enable;
            private String bundleId;

            /** 
             * Get the 'Enable' attribute value. Request enhancement of a base fare when a shelf or flex fare is not returned.
             * 
             * @return value
             */
            public boolean isEnable() {
                return enable;
            }

            /** 
             * Set the 'Enable' attribute value. Request enhancement of a base fare when a shelf or flex fare is not returned.
             * 
             * @param enable
             */
            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            /** 
             * Get the 'BundleId' attribute value. Bundle ID for revalidate itin purposes only.
             * 
             * @return value
             */
            public String getBundleId() {
                return bundleId;
            }

            /** 
             * Set the 'BundleId' attribute value. Bundle ID for revalidate itin purposes only.
             * 
             * @param bundleId
             */
            public void setBundleId(String bundleId) {
                this.bundleId = bundleId;
            }
        }
    }
}
