
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

/** 
 * Defines the data fields available for the reissue info type
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ReissueInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ChangeFees" minOccurs="0">
 *       &lt;!-- Reference to inner class ChangeFees -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ResidualIdicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TypeOfServiceFee"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TypeOfReissueTransaction"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ReissueResultFromTag"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FormOfRefund"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ReissueRequiresElectronicTicket"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ReissueDoesNotAllowElectronicTicket"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="TaxRefundable"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ReissueInfoType implements Serializable
{
    private ChangeFees changeFees;
    private String residualIdicator;
    private String typeOfServiceFee;
    private String typeOfReissueTransaction;
    private Boolean reissueResultFromTag;
    private String formOfRefund;
    private Boolean reissueRequiresElectronicTicket;
    private Boolean reissueDoesNotAllowElectronicTicket;
    private Boolean taxRefundable;

    /** 
     * Get the 'ChangeFees' element value.
     * 
     * @return value
     */
    public ChangeFees getChangeFees() {
        return changeFees;
    }

    /** 
     * Set the 'ChangeFees' element value.
     * 
     * @param changeFees
     */
    public void setChangeFees(ChangeFees changeFees) {
        this.changeFees = changeFees;
    }

    /** 
     * Get the 'ResidualIdicator' attribute value.
     * 
     * @return value
     */
    public String getResidualIdicator() {
        return residualIdicator;
    }

    /** 
     * Set the 'ResidualIdicator' attribute value.
     * 
     * @param residualIdicator
     */
    public void setResidualIdicator(String residualIdicator) {
        this.residualIdicator = residualIdicator;
    }

    /** 
     * Get the 'TypeOfServiceFee' attribute value.
     * 
     * @return value
     */
    public String getTypeOfServiceFee() {
        return typeOfServiceFee;
    }

    /** 
     * Set the 'TypeOfServiceFee' attribute value.
     * 
     * @param typeOfServiceFee
     */
    public void setTypeOfServiceFee(String typeOfServiceFee) {
        this.typeOfServiceFee = typeOfServiceFee;
    }

    /** 
     * Get the 'TypeOfReissueTransaction' attribute value.
     * 
     * @return value
     */
    public String getTypeOfReissueTransaction() {
        return typeOfReissueTransaction;
    }

    /** 
     * Set the 'TypeOfReissueTransaction' attribute value.
     * 
     * @param typeOfReissueTransaction
     */
    public void setTypeOfReissueTransaction(String typeOfReissueTransaction) {
        this.typeOfReissueTransaction = typeOfReissueTransaction;
    }

    /** 
     * Get the 'ReissueResultFromTag' attribute value.
     * 
     * @return value
     */
    public Boolean getReissueResultFromTag() {
        return reissueResultFromTag;
    }

    /** 
     * Set the 'ReissueResultFromTag' attribute value.
     * 
     * @param reissueResultFromTag
     */
    public void setReissueResultFromTag(Boolean reissueResultFromTag) {
        this.reissueResultFromTag = reissueResultFromTag;
    }

    /** 
     * Get the 'FormOfRefund' attribute value.
     * 
     * @return value
     */
    public String getFormOfRefund() {
        return formOfRefund;
    }

    /** 
     * Set the 'FormOfRefund' attribute value.
     * 
     * @param formOfRefund
     */
    public void setFormOfRefund(String formOfRefund) {
        this.formOfRefund = formOfRefund;
    }

    /** 
     * Get the 'ReissueRequiresElectronicTicket' attribute value.
     * 
     * @return value
     */
    public Boolean getReissueRequiresElectronicTicket() {
        return reissueRequiresElectronicTicket;
    }

    /** 
     * Set the 'ReissueRequiresElectronicTicket' attribute value.
     * 
     * @param reissueRequiresElectronicTicket
     */
    public void setReissueRequiresElectronicTicket(
            Boolean reissueRequiresElectronicTicket) {
        this.reissueRequiresElectronicTicket = reissueRequiresElectronicTicket;
    }

    /** 
     * Get the 'ReissueDoesNotAllowElectronicTicket' attribute value.
     * 
     * @return value
     */
    public Boolean getReissueDoesNotAllowElectronicTicket() {
        return reissueDoesNotAllowElectronicTicket;
    }

    /** 
     * Set the 'ReissueDoesNotAllowElectronicTicket' attribute value.
     * 
     * @param reissueDoesNotAllowElectronicTicket
     */
    public void setReissueDoesNotAllowElectronicTicket(
            Boolean reissueDoesNotAllowElectronicTicket) {
        this.reissueDoesNotAllowElectronicTicket = reissueDoesNotAllowElectronicTicket;
    }

    /** 
     * Get the 'TaxRefundable' attribute value.
     * 
     * @return value
     */
    public Boolean getTaxRefundable() {
        return taxRefundable;
    }

    /** 
     * Set the 'TaxRefundable' attribute value.
     * 
     * @param taxRefundable
     */
    public void setTaxRefundable(Boolean taxRefundable) {
        this.taxRefundable = taxRefundable;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ChangeFees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="ChangeFee">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="HighestChangeFee"/>
     *           &lt;xs:attributeGroup ref="ns:CurrencyAmountGroup"/>
     *           &lt;xs:attribute type="xs:decimal" use="optional" name="PaymentAmount"/>
     *           &lt;xs:attribute type="xs:string" use="optional" name="PaymentCurrency"/>
     *           &lt;xs:attribute type="xs:integer" use="optional" name="PaymentDecimalPlaces"/>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeFeeWaived"/>
     *           &lt;xs:attribute type="xs:boolean" use="optional" name="ChangeFeeNotApplicable"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ChangeFees implements Serializable
    {
        private Boolean changeFeeHighestChangeFee;
        private CurrencyAmountGroup changeFeeCurrencyAmountGroup;
        private BigDecimal changeFeePaymentAmount;
        private String changeFeePaymentCurrency;
        private BigInteger changeFeePaymentDecimalPlaces;
        private Boolean changeFeeChangeFeeWaived;
        private Boolean changeFeeChangeFeeNotApplicable;

        /** 
         * Get the 'HighestChangeFee' attribute value.
         * 
         * @return value
         */
        public Boolean getChangeFeeHighestChangeFee() {
            return changeFeeHighestChangeFee;
        }

        /** 
         * Set the 'HighestChangeFee' attribute value.
         * 
         * @param changeFeeHighestChangeFee
         */
        public void setChangeFeeHighestChangeFee(
                Boolean changeFeeHighestChangeFee) {
            this.changeFeeHighestChangeFee = changeFeeHighestChangeFee;
        }

        /** 
         * Get the 'CurrencyAmountGroup' attributeGroup value.
         * 
         * @return value
         */
        public CurrencyAmountGroup getChangeFeeCurrencyAmountGroup() {
            return changeFeeCurrencyAmountGroup;
        }

        /** 
         * Set the 'CurrencyAmountGroup' attributeGroup value.
         * 
         * @param changeFeeCurrencyAmountGroup
         */
        public void setChangeFeeCurrencyAmountGroup(
                CurrencyAmountGroup changeFeeCurrencyAmountGroup) {
            this.changeFeeCurrencyAmountGroup = changeFeeCurrencyAmountGroup;
        }

        /** 
         * Get the 'PaymentAmount' attribute value.
         * 
         * @return value
         */
        public BigDecimal getChangeFeePaymentAmount() {
            return changeFeePaymentAmount;
        }

        /** 
         * Set the 'PaymentAmount' attribute value.
         * 
         * @param changeFeePaymentAmount
         */
        public void setChangeFeePaymentAmount(BigDecimal changeFeePaymentAmount) {
            this.changeFeePaymentAmount = changeFeePaymentAmount;
        }

        /** 
         * Get the 'PaymentCurrency' attribute value.
         * 
         * @return value
         */
        public String getChangeFeePaymentCurrency() {
            return changeFeePaymentCurrency;
        }

        /** 
         * Set the 'PaymentCurrency' attribute value.
         * 
         * @param changeFeePaymentCurrency
         */
        public void setChangeFeePaymentCurrency(String changeFeePaymentCurrency) {
            this.changeFeePaymentCurrency = changeFeePaymentCurrency;
        }

        /** 
         * Get the 'PaymentDecimalPlaces' attribute value.
         * 
         * @return value
         */
        public BigInteger getChangeFeePaymentDecimalPlaces() {
            return changeFeePaymentDecimalPlaces;
        }

        /** 
         * Set the 'PaymentDecimalPlaces' attribute value.
         * 
         * @param changeFeePaymentDecimalPlaces
         */
        public void setChangeFeePaymentDecimalPlaces(
                BigInteger changeFeePaymentDecimalPlaces) {
            this.changeFeePaymentDecimalPlaces = changeFeePaymentDecimalPlaces;
        }

        /** 
         * Get the 'ChangeFeeWaived' attribute value.
         * 
         * @return value
         */
        public Boolean getChangeFeeChangeFeeWaived() {
            return changeFeeChangeFeeWaived;
        }

        /** 
         * Set the 'ChangeFeeWaived' attribute value.
         * 
         * @param changeFeeChangeFeeWaived
         */
        public void setChangeFeeChangeFeeWaived(Boolean changeFeeChangeFeeWaived) {
            this.changeFeeChangeFeeWaived = changeFeeChangeFeeWaived;
        }

        /** 
         * Get the 'ChangeFeeNotApplicable' attribute value.
         * 
         * @return value
         */
        public Boolean getChangeFeeChangeFeeNotApplicable() {
            return changeFeeChangeFeeNotApplicable;
        }

        /** 
         * Set the 'ChangeFeeNotApplicable' attribute value.
         * 
         * @param changeFeeChangeFeeNotApplicable
         */
        public void setChangeFeeChangeFeeNotApplicable(
                Boolean changeFeeChangeFeeNotApplicable) {
            this.changeFeeChangeFeeNotApplicable = changeFeeChangeFeeNotApplicable;
        }
    }
}
