
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Code and optional string to describe a location point.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RequestLocationType">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="xs:string">
 *       &lt;xs:attribute type="xs:string" use="optional" name="LocationCode"/>
 *       &lt;xs:attribute type="xs:string" name="AirportsGroup"/>
 *       &lt;xs:attribute type="xs:string" default="IATA" name="CodeContext"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RequestLocationType implements Serializable
{
    private String string;
    private String locationCode;
    private String airportsGroup;
    private String codeContext;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public String getString() {
        return string;
    }

    /** 
     * Set the extension value.
     * 
     * @param string
     */
    public void setString(String string) {
        this.string = string;
    }

    /** 
     * Get the 'LocationCode' attribute value. Location identifying code. Required unless AirportsGroup or AllAirports is specified. Cannot appear with AirportsGroup nor AllAirports.
     * 
     * @return value
     */
    public String getLocationCode() {
        return locationCode;
    }

    /** 
     * Set the 'LocationCode' attribute value. Location identifying code. Required unless AirportsGroup or AllAirports is specified. Cannot appear with AirportsGroup nor AllAirports.
     * 
     * @param locationCode
     */
    public void setLocationCode(String locationCode) {
        this.locationCode = locationCode;
    }

    /** 
     * Get the 'AirportsGroup' attribute value. Name of the airports group
     * 
     * @return value
     */
    public String getAirportsGroup() {
        return airportsGroup;
    }

    /** 
     * Set the 'AirportsGroup' attribute value. Name of the airports group
     * 
     * @param airportsGroup
     */
    public void setAirportsGroup(String airportsGroup) {
        this.airportsGroup = airportsGroup;
    }

    /** 
     * Get the 'CodeContext' attribute value. Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc.
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'CodeContext' attribute value. Identifies the context of the identifying code, such as IATA, ARC, or internal code, etc.
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }
}
