
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Definition of individual routing legs, at least one leg must be present.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="RoutingLegType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="InboundOutboundCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="InboundCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="OutboundCarrier" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ConnectPoint" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class RoutingLegType implements Serializable
{
    private List<String> inboundOutboundCarrierList = new ArrayList<String>();
    private List<String> inboundCarrierList = new ArrayList<String>();
    private List<String> outboundCarrierList = new ArrayList<String>();
    private List<String> connectPointList = new ArrayList<String>();

    /** 
     * Get the list of 'InboundOutboundCarrier' element items.
     * 
     * @return list
     */
    public List<String> getInboundOutboundCarrierList() {
        return inboundOutboundCarrierList;
    }

    /** 
     * Set the list of 'InboundOutboundCarrier' element items.
     * 
     * @param list
     */
    public void setInboundOutboundCarrierList(List<String> list) {
        inboundOutboundCarrierList = list;
    }

    /** 
     * Get the list of 'InboundCarrier' element items.
     * 
     * @return list
     */
    public List<String> getInboundCarrierList() {
        return inboundCarrierList;
    }

    /** 
     * Set the list of 'InboundCarrier' element items.
     * 
     * @param list
     */
    public void setInboundCarrierList(List<String> list) {
        inboundCarrierList = list;
    }

    /** 
     * Get the list of 'OutboundCarrier' element items.
     * 
     * @return list
     */
    public List<String> getOutboundCarrierList() {
        return outboundCarrierList;
    }

    /** 
     * Set the list of 'OutboundCarrier' element items.
     * 
     * @param list
     */
    public void setOutboundCarrierList(List<String> list) {
        outboundCarrierList = list;
    }

    /** 
     * Get the list of 'ConnectPoint' element items.
     * 
     * @return list
     */
    public List<String> getConnectPointList() {
        return connectPointList;
    }

    /** 
     * Set the list of 'ConnectPoint' element items.
     * 
     * @param list
     */
    public void setConnectPointList(List<String> list) {
        connectPointList = list;
    }
}
