
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * 
 A single letter cabin code in SABRE encoding as opposed to ATPCO encoding

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SabreCabinCode">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="P"/>
 *     &lt;xs:enumeration value="F"/>
 *     &lt;xs:enumeration value="J"/>
 *     &lt;xs:enumeration value="C"/>
 *     &lt;xs:enumeration value="S"/>
 *     &lt;xs:enumeration value="Y"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum SabreCabinCode implements Serializable {
    /** 
     * Premium First
     */
    P, /** 
        * First
        */
    F, /** 
        * Premium Business
        */
    J, /** 
        * Business
        */
    C, /** 
        * Prmium Economy
        */
    S, /** 
        * Economy
        */
    Y
}
