
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SeatPrefType">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="AtLeast"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="LessThan"/>
 *   &lt;xs:attribute type="ns:IncludeExcludePreferLevelType" use="optional" name="PreferLevel"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SeatPrefType implements Serializable
{
    private String type;
    private BigInteger atLeast;
    private BigInteger lessThan;
    private IncludeExcludePreferLevelType preferLevel;

    /** 
     * Get the 'Type' attribute value. Optional seat type
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Optional seat type
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }

    /** 
     * Get the 'AtLeast' attribute value. Optional minimum size of pitch
     * 
     * @return value
     */
    public BigInteger getAtLeast() {
        return atLeast;
    }

    /** 
     * Set the 'AtLeast' attribute value. Optional minimum size of pitch
     * 
     * @param atLeast
     */
    public void setAtLeast(BigInteger atLeast) {
        this.atLeast = atLeast;
    }

    /** 
     * Get the 'LessThan' attribute value. Optional maximum size of pitch
     * 
     * @return value
     */
    public BigInteger getLessThan() {
        return lessThan;
    }

    /** 
     * Set the 'LessThan' attribute value. Optional maximum size of pitch
     * 
     * @param lessThan
     */
    public void setLessThan(BigInteger lessThan) {
        this.lessThan = lessThan;
    }

    /** 
     * Get the 'PreferLevel' attribute value. 
                      Used to indicate a level of preference for an assosiate item: Unacceptable or Preferred.
                  
     * 
     * @return value
     */
    public IncludeExcludePreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. 
                      Used to indicate a level of preference for an assosiate item: Unacceptable or Preferred.
                  
     * 
     * @param preferLevel
     */
    public void setPreferLevel(IncludeExcludePreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }
}
