
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingFareDataType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:HandlingMarkupSummaryType" name="HandlingMarkupSummary" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AirTaxType" name="Tax" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:AirTaxSummaryType" name="TaxSummary" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="LayerTypeName"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="BaseFareAmount"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="ConstructedTotalAmount"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="EquivalentAmount"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="TotalTaxes"/>
 *   &lt;xs:attribute type="xs:float" use="optional" name="TotalPerPassenger"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FareCalculation"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="HiddenHandlingFee"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="NonHiddenHandlingFee"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FareRetailerRule"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SellingFareDataType implements Serializable
{
    private List<HandlingMarkupSummaryType> handlingMarkupSummaryList = new ArrayList<HandlingMarkupSummaryType>();
    private List<AirTaxType> taxList = new ArrayList<AirTaxType>();
    private List<AirTaxSummaryType> taxSummaryList = new ArrayList<AirTaxSummaryType>();
    private String layerTypeName;
    private Float baseFareAmount;
    private Float constructedTotalAmount;
    private Float equivalentAmount;
    private Float totalTaxes;
    private Float totalPerPassenger;
    private String fareCalculation;
    private Boolean hiddenHandlingFee;
    private Boolean nonHiddenHandlingFee;
    private Boolean fareRetailerRule;

    /** 
     * Get the list of 'HandlingMarkupSummary' element items.
     * 
     * @return list
     */
    public List<HandlingMarkupSummaryType> getHandlingMarkupSummaryList() {
        return handlingMarkupSummaryList;
    }

    /** 
     * Set the list of 'HandlingMarkupSummary' element items.
     * 
     * @param list
     */
    public void setHandlingMarkupSummaryList(
            List<HandlingMarkupSummaryType> list) {
        handlingMarkupSummaryList = list;
    }

    /** 
     * Get the list of 'Tax' element items. Any individual tax applied to the fare
     * 
     * @return list
     */
    public List<AirTaxType> getTaxList() {
        return taxList;
    }

    /** 
     * Set the list of 'Tax' element items. Any individual tax applied to the fare
     * 
     * @param list
     */
    public void setTaxList(List<AirTaxType> list) {
        taxList = list;
    }

    /** 
     * Get the list of 'TaxSummary' element items. Tax Summary Information
     * 
     * @return list
     */
    public List<AirTaxSummaryType> getTaxSummaryList() {
        return taxSummaryList;
    }

    /** 
     * Set the list of 'TaxSummary' element items. Tax Summary Information
     * 
     * @param list
     */
    public void setTaxSummaryList(List<AirTaxSummaryType> list) {
        taxSummaryList = list;
    }

    /** 
     * Get the 'LayerTypeName' attribute value.
     * 
     * @return value
     */
    public String getLayerTypeName() {
        return layerTypeName;
    }

    /** 
     * Set the 'LayerTypeName' attribute value.
     * 
     * @param layerTypeName
     */
    public void setLayerTypeName(String layerTypeName) {
        this.layerTypeName = layerTypeName;
    }

    /** 
     * Get the 'BaseFareAmount' attribute value.
     * 
     * @return value
     */
    public Float getBaseFareAmount() {
        return baseFareAmount;
    }

    /** 
     * Set the 'BaseFareAmount' attribute value.
     * 
     * @param baseFareAmount
     */
    public void setBaseFareAmount(Float baseFareAmount) {
        this.baseFareAmount = baseFareAmount;
    }

    /** 
     * Get the 'ConstructedTotalAmount' attribute value.
     * 
     * @return value
     */
    public Float getConstructedTotalAmount() {
        return constructedTotalAmount;
    }

    /** 
     * Set the 'ConstructedTotalAmount' attribute value.
     * 
     * @param constructedTotalAmount
     */
    public void setConstructedTotalAmount(Float constructedTotalAmount) {
        this.constructedTotalAmount = constructedTotalAmount;
    }

    /** 
     * Get the 'EquivalentAmount' attribute value.
     * 
     * @return value
     */
    public Float getEquivalentAmount() {
        return equivalentAmount;
    }

    /** 
     * Set the 'EquivalentAmount' attribute value.
     * 
     * @param equivalentAmount
     */
    public void setEquivalentAmount(Float equivalentAmount) {
        this.equivalentAmount = equivalentAmount;
    }

    /** 
     * Get the 'TotalTaxes' attribute value.
     * 
     * @return value
     */
    public Float getTotalTaxes() {
        return totalTaxes;
    }

    /** 
     * Set the 'TotalTaxes' attribute value.
     * 
     * @param totalTaxes
     */
    public void setTotalTaxes(Float totalTaxes) {
        this.totalTaxes = totalTaxes;
    }

    /** 
     * Get the 'TotalPerPassenger' attribute value.
     * 
     * @return value
     */
    public Float getTotalPerPassenger() {
        return totalPerPassenger;
    }

    /** 
     * Set the 'TotalPerPassenger' attribute value.
     * 
     * @param totalPerPassenger
     */
    public void setTotalPerPassenger(Float totalPerPassenger) {
        this.totalPerPassenger = totalPerPassenger;
    }

    /** 
     * Get the 'FareCalculation' attribute value.
     * 
     * @return value
     */
    public String getFareCalculation() {
        return fareCalculation;
    }

    /** 
     * Set the 'FareCalculation' attribute value.
     * 
     * @param fareCalculation
     */
    public void setFareCalculation(String fareCalculation) {
        this.fareCalculation = fareCalculation;
    }

    /** 
     * Get the 'HiddenHandlingFee' attribute value. Indicator if hidden handling fee was used in any HandlingMarkupSummary
     * 
     * @return value
     */
    public Boolean getHiddenHandlingFee() {
        return hiddenHandlingFee;
    }

    /** 
     * Set the 'HiddenHandlingFee' attribute value. Indicator if hidden handling fee was used in any HandlingMarkupSummary
     * 
     * @param hiddenHandlingFee
     */
    public void setHiddenHandlingFee(Boolean hiddenHandlingFee) {
        this.hiddenHandlingFee = hiddenHandlingFee;
    }

    /** 
     * Get the 'NonHiddenHandlingFee' attribute value. Indicator if non-hidden handling fee was used in any HandlingMarkupSummary
     * 
     * @return value
     */
    public Boolean getNonHiddenHandlingFee() {
        return nonHiddenHandlingFee;
    }

    /** 
     * Set the 'NonHiddenHandlingFee' attribute value. Indicator if non-hidden handling fee was used in any HandlingMarkupSummary
     * 
     * @param nonHiddenHandlingFee
     */
    public void setNonHiddenHandlingFee(Boolean nonHiddenHandlingFee) {
        this.nonHiddenHandlingFee = nonHiddenHandlingFee;
    }

    /** 
     * Get the 'FareRetailerRule' attribute value. Indicator if Fare Retailer selling level rule was used in any HandlingMarkupSummary
     * 
     * @return value
     */
    public Boolean getFareRetailerRule() {
        return fareRetailerRule;
    }

    /** 
     * Set the 'FareRetailerRule' attribute value. Indicator if Fare Retailer selling level rule was used in any HandlingMarkupSummary
     * 
     * @param fareRetailerRule
     */
    public void setFareRetailerRule(Boolean fareRetailerRule) {
        this.fareRetailerRule = fareRetailerRule;
    }
}
