
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceAttributeGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentSine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PseudoCityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ISOCountry"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ISOCurrency"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentDutyCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AirlineVendorID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AirportCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="FirstDepartPoint"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ERSP_UserID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PersonalCityCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AccountingCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OfficeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DefaultTicketingCarrier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AirlineChannelCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentDepartmentCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentFunction"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyIATA"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="HomeAgencyIATA"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentIATA"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VendorCRSCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentDuty"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="AbacusUser"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class SourceAttributeGroup implements Serializable
{
    private String agentSine;
    private String pseudoCityCode;
    private String ISOCountry;
    private String ISOCurrency;
    private String agentDutyCode;
    private String airlineVendorID;
    private String airportCode;
    private String firstDepartPoint;
    private String ERSPUserID;
    private String personalCityCode;
    private String accountingCode;
    private String officeCode;
    private String defaultTicketingCarrier;
    private String airlineChannelCode;
    private String agentDepartmentCode;
    private String agentFunction;
    private String travelAgencyIATA;
    private String homeAgencyIATA;
    private String agentIATA;
    private String vendorCRSCode;
    private String agentDuty;
    private Boolean abacusUser;

    /** 
     * Get the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' attribute value. Identifies the party within the requesting entity.
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @return value
     */
    public String getPseudoCityCode() {
        return pseudoCityCode;
    }

    /** 
     * Set the 'PseudoCityCode' attribute value. An identification code assigned to an office/agency by a reservation system.
     * 
     * @param pseudoCityCode
     */
    public void setPseudoCityCode(String pseudoCityCode) {
        this.pseudoCityCode = pseudoCityCode;
    }

    /** 
     * Get the 'ISOCountry' attribute value. The country code of the requesting party.
     * 
     * @return value
     */
    public String getISOCountry() {
        return ISOCountry;
    }

    /** 
     * Set the 'ISOCountry' attribute value. The country code of the requesting party.
     * 
     * @param ISOCountry
     */
    public void setISOCountry(String ISOCountry) {
        this.ISOCountry = ISOCountry;
    }

    /** 
     * Get the 'ISOCurrency' attribute value. The currency code in which the reservation will be ticketed.
     * 
     * @return value
     */
    public String getISOCurrency() {
        return ISOCurrency;
    }

    /** 
     * Set the 'ISOCurrency' attribute value. The currency code in which the reservation will be ticketed.
     * 
     * @param ISOCurrency
     */
    public void setISOCurrency(String ISOCurrency) {
        this.ISOCurrency = ISOCurrency;
    }

    /** 
     * Get the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @return value
     */
    public String getAgentDutyCode() {
        return agentDutyCode;
    }

    /** 
     * Set the 'AgentDutyCode' attribute value. An authority code assigned to a requestor.
     * 
     * @param agentDutyCode
     */
    public void setAgentDutyCode(String agentDutyCode) {
        this.agentDutyCode = agentDutyCode;
    }

    /** 
     * Get the 'AirlineVendorID' attribute value. The IATA assigned airline code.
     * 
     * @return value
     */
    public String getAirlineVendorID() {
        return airlineVendorID;
    }

    /** 
     * Set the 'AirlineVendorID' attribute value. The IATA assigned airline code.
     * 
     * @param airlineVendorID
     */
    public void setAirlineVendorID(String airlineVendorID) {
        this.airlineVendorID = airlineVendorID;
    }

    /** 
     * Get the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @return value
     */
    public String getAirportCode() {
        return airportCode;
    }

    /** 
     * Set the 'AirportCode' attribute value. The IATA assigned airport code.
     * 
     * @param airportCode
     */
    public void setAirportCode(String airportCode) {
        this.airportCode = airportCode;
    }

    /** 
     * Get the 'FirstDepartPoint' attribute value. The point of first departure in a trip.
     * 
     * @return value
     */
    public String getFirstDepartPoint() {
        return firstDepartPoint;
    }

    /** 
     * Set the 'FirstDepartPoint' attribute value. The point of first departure in a trip.
     * 
     * @param firstDepartPoint
     */
    public void setFirstDepartPoint(String firstDepartPoint) {
        this.firstDepartPoint = firstDepartPoint;
    }

    /** 
     * Get the 'ERSP_UserID' attribute value. Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system.
     * 
     * @return value
     */
    public String getERSPUserID() {
        return ERSPUserID;
    }

    /** 
     * Set the 'ERSP_UserID' attribute value. Electronic Reservation Service Provider (ERSP) assigned identifier used to identify the individual using the ERSP system.
     * 
     * @param ERSPUserID
     */
    public void setERSPUserID(String ERSPUserID) {
        this.ERSPUserID = ERSPUserID;
    }

    /** 
     * Get the 'PersonalCityCode' attribute value. City code part of Office Accounting Code
     * 
     * @return value
     */
    public String getPersonalCityCode() {
        return personalCityCode;
    }

    /** 
     * Set the 'PersonalCityCode' attribute value. City code part of Office Accounting Code
     * 
     * @param personalCityCode
     */
    public void setPersonalCityCode(String personalCityCode) {
        this.personalCityCode = personalCityCode;
    }

    /** 
     * Get the 'AccountingCode' attribute value. Accounting Code part of Office Accounting Code
     * 
     * @return value
     */
    public String getAccountingCode() {
        return accountingCode;
    }

    /** 
     * Set the 'AccountingCode' attribute value. Accounting Code part of Office Accounting Code
     * 
     * @param accountingCode
     */
    public void setAccountingCode(String accountingCode) {
        this.accountingCode = accountingCode;
    }

    /** 
     * Get the 'OfficeCode' attribute value. Office Code part of Office Accounting Code
     * 
     * @return value
     */
    public String getOfficeCode() {
        return officeCode;
    }

    /** 
     * Set the 'OfficeCode' attribute value. Office Code part of Office Accounting Code
     * 
     * @param officeCode
     */
    public void setOfficeCode(String officeCode) {
        this.officeCode = officeCode;
    }

    /** 
     * Get the 'DefaultTicketingCarrier' attribute value. Default Ticketing Carrier for Office Accounting Code
     * 
     * @return value
     */
    public String getDefaultTicketingCarrier() {
        return defaultTicketingCarrier;
    }

    /** 
     * Set the 'DefaultTicketingCarrier' attribute value. Default Ticketing Carrier for Office Accounting Code
     * 
     * @param defaultTicketingCarrier
     */
    public void setDefaultTicketingCarrier(String defaultTicketingCarrier) {
        this.defaultTicketingCarrier = defaultTicketingCarrier;
    }

    /** 
     * Get the 'AirlineChannelCode' attribute value. Airline Channel Code
     * 
     * @return value
     */
    public String getAirlineChannelCode() {
        return airlineChannelCode;
    }

    /** 
     * Set the 'AirlineChannelCode' attribute value. Airline Channel Code
     * 
     * @param airlineChannelCode
     */
    public void setAirlineChannelCode(String airlineChannelCode) {
        this.airlineChannelCode = airlineChannelCode;
    }

    /** 
     * Get the 'AgentDepartmentCode' attribute value. Agent department code
     * 
     * @return value
     */
    public String getAgentDepartmentCode() {
        return agentDepartmentCode;
    }

    /** 
     * Set the 'AgentDepartmentCode' attribute value. Agent department code
     * 
     * @param agentDepartmentCode
     */
    public void setAgentDepartmentCode(String agentDepartmentCode) {
        this.agentDepartmentCode = agentDepartmentCode;
    }

    /** 
     * Get the 'AgentFunction' attribute value. Agent function
     * 
     * @return value
     */
    public String getAgentFunction() {
        return agentFunction;
    }

    /** 
     * Set the 'AgentFunction' attribute value. Agent function
     * 
     * @param agentFunction
     */
    public void setAgentFunction(String agentFunction) {
        this.agentFunction = agentFunction;
    }

    /** 
     * Get the 'TravelAgencyIATA' attribute value. Travel agency IATA
     * 
     * @return value
     */
    public String getTravelAgencyIATA() {
        return travelAgencyIATA;
    }

    /** 
     * Set the 'TravelAgencyIATA' attribute value. Travel agency IATA
     * 
     * @param travelAgencyIATA
     */
    public void setTravelAgencyIATA(String travelAgencyIATA) {
        this.travelAgencyIATA = travelAgencyIATA;
    }

    /** 
     * Get the 'HomeAgencyIATA' attribute value. Home agency IATA
     * 
     * @return value
     */
    public String getHomeAgencyIATA() {
        return homeAgencyIATA;
    }

    /** 
     * Set the 'HomeAgencyIATA' attribute value. Home agency IATA
     * 
     * @param homeAgencyIATA
     */
    public void setHomeAgencyIATA(String homeAgencyIATA) {
        this.homeAgencyIATA = homeAgencyIATA;
    }

    /** 
     * Get the 'AgentIATA' attribute value. Agent IATA
     * 
     * @return value
     */
    public String getAgentIATA() {
        return agentIATA;
    }

    /** 
     * Set the 'AgentIATA' attribute value. Agent IATA
     * 
     * @param agentIATA
     */
    public void setAgentIATA(String agentIATA) {
        this.agentIATA = agentIATA;
    }

    /** 
     * Get the 'VendorCRSCode' attribute value. Vendor CRS code
     * 
     * @return value
     */
    public String getVendorCRSCode() {
        return vendorCRSCode;
    }

    /** 
     * Set the 'VendorCRSCode' attribute value. Vendor CRS code
     * 
     * @param vendorCRSCode
     */
    public void setVendorCRSCode(String vendorCRSCode) {
        this.vendorCRSCode = vendorCRSCode;
    }

    /** 
     * Get the 'AgentDuty' attribute value. Agent duty
     * 
     * @return value
     */
    public String getAgentDuty() {
        return agentDuty;
    }

    /** 
     * Set the 'AgentDuty' attribute value. Agent duty
     * 
     * @param agentDuty
     */
    public void setAgentDuty(String agentDuty) {
        this.agentDuty = agentDuty;
    }

    /** 
     * Get the 'AbacusUser' attribute value. Abacus user
     * 
     * @return value
     */
    public Boolean getAbacusUser() {
        return abacusUser;
    }

    /** 
     * Set the 'AbacusUser' attribute value. Abacus user
     * 
     * @param abacusUser
     */
    public void setAbacusUser(Boolean abacusUser) {
        this.abacusUser = abacusUser;
    }
}
