
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Specifies the booking channel type and whether it is the primary means of connectivity of the source.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceBookingChannelType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:BookingChannelType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:CompanyNameType" name="CompanyName" minOccurs="0"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class SourceBookingChannelType extends BookingChannelType implements
    Serializable
{
    private CompanyNameType companyName;

    /** 
     * Get the 'CompanyName' element value. Identifies the company that is associated with the booking channel.
     * 
     * @return value
     */
    public CompanyNameType getCompanyName() {
        return companyName;
    }

    /** 
     * Set the 'CompanyName' element value. Identifies the company that is associated with the booking channel.
     * 
     * @param companyName
     */
    public void setCompanyName(CompanyNameType companyName) {
        this.companyName = companyName;
    }
}
