
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:group xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SourceGroup">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:UniqueID_Type" name="RequestorID"/>
 *     &lt;xs:element type="ns:PositionType" name="Position" minOccurs="0"/>
 *     &lt;xs:element type="ns:SourceBookingChannelType" name="BookingChannel" minOccurs="0"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:group>
 * </pre>
 */
public class SourceGroup implements Serializable
{
    private UniqueIDType requestorID;
    private PositionType position;
    private SourceBookingChannelType bookingChannel;

    /** 
     * Get the 'RequestorID' element value. An identifier of the entity making the request (e.g. ATA/IATA/ID number, Electronic Reservation Service Provider (ERSP), Association of British Travel Agents (ABTA)).
     * 
     * @return value
     */
    public UniqueIDType getRequestorID() {
        return requestorID;
    }

    /** 
     * Set the 'RequestorID' element value. An identifier of the entity making the request (e.g. ATA/IATA/ID number, Electronic Reservation Service Provider (ERSP), Association of British Travel Agents (ABTA)).
     * 
     * @param requestorID
     */
    public void setRequestorID(UniqueIDType requestorID) {
        this.requestorID = requestorID;
    }

    /** 
     * Get the 'Position' element value.
     * 
     * @return value
     */
    public PositionType getPosition() {
        return position;
    }

    /** 
     * Set the 'Position' element value.
     * 
     * @param position
     */
    public void setPosition(PositionType position) {
        this.position = position;
    }

    /** 
     * Get the 'BookingChannel' element value.
     * 
     * @return value
     */
    public SourceBookingChannelType getBookingChannel() {
        return bookingChannel;
    }

    /** 
     * Set the 'BookingChannel' element value.
     * 
     * @param bookingChannel
     */
    public void setBookingChannel(SourceBookingChannelType bookingChannel) {
        this.bookingChannel = bookingChannel;
    }
}
