
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Type defining Min and Max Stay Restrictions.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StayRestrictionsType">
 *   &lt;xs:sequence minOccurs="0">
 *     &lt;!-- Reference to inner class Sequence -->
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="StayRestrictionsInd"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class StayRestrictionsType implements Serializable
{
    private Sequence sequence;
    private Boolean stayRestrictionsInd;

    /** 
     * Get the sequence value.
     * 
     * @return value
     */
    public Sequence getSequence() {
        return sequence;
    }

    /** 
     * Set the sequence value.
     * 
     * @param sequence
     */
    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    /** 
     * Get the 'StayRestrictionsInd' attribute value. True indicates that Stay Restrictions exist. 
     * 
     * @return value
     */
    public Boolean getStayRestrictionsInd() {
        return stayRestrictionsInd;
    }

    /** 
     * Set the 'StayRestrictionsInd' attribute value. True indicates that Stay Restrictions exist. 
     * 
     * @param stayRestrictionsInd
     */
    public void setStayRestrictionsInd(Boolean stayRestrictionsInd) {
        this.stayRestrictionsInd = stayRestrictionsInd;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:sequence xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0">
     *   &lt;xs:element name="MinimumStay">
     *     &lt;xs:complexType>
     *       &lt;xs:attribute type="xs:string" use="optional" name="ReturnTimeOfDay"/>
     *       &lt;xs:attribute type="xs:integer" use="optional" name="MinStay"/>
     *       &lt;xs:attribute type="ns:StayUnitType" use="optional" name="StayUnit"/>
     *       &lt;xs:attribute type="xs:string" use="optional" name="MinStayDate"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     *   &lt;xs:element name="MaximumStay">
     *     &lt;xs:complexType>
     *       &lt;xs:attribute use="optional" name="ReturnType">
     *         &lt;xs:simpleType>
     *           &lt;!-- Reference to inner class ReturnType -->
     *         &lt;/xs:simpleType>
     *       &lt;/xs:attribute>
     *       &lt;xs:attribute type="xs:string" use="optional" name="ReturnTimeOfDay"/>
     *       &lt;xs:attribute type="xs:integer" use="optional" name="MaxStay"/>
     *       &lt;xs:attribute type="ns:StayUnitType" use="optional" name="StayUnit"/>
     *       &lt;xs:attribute type="xs:string" use="optional" name="MaxStayDate"/>
     *     &lt;/xs:complexType>
     *   &lt;/xs:element>
     * &lt;/xs:sequence>
     * </pre>
     */
    public static class Sequence implements Serializable
    {
        private String minimumStayReturnTimeOfDay;
        private BigInteger minimumStayMinStay;
        private StayUnitType minimumStayStayUnit;
        private String minimumStayMinStayDate;
        private ReturnType maximumStayReturnType;
        private String maximumStayReturnTimeOfDay;
        private BigInteger maximumStayMaxStay;
        private StayUnitType maximumStayStayUnit;
        private String maximumStayMaxStayDate;

        /** 
         * Get the 'ReturnTimeOfDay' attribute value. The time of day when return travel may commence.
         * 
         * @return value
         */
        public String getMinimumStayReturnTimeOfDay() {
            return minimumStayReturnTimeOfDay;
        }

        /** 
         * Set the 'ReturnTimeOfDay' attribute value. The time of day when return travel may commence.
         * 
         * @param minimumStayReturnTimeOfDay
         */
        public void setMinimumStayReturnTimeOfDay(
                String minimumStayReturnTimeOfDay) {
            this.minimumStayReturnTimeOfDay = minimumStayReturnTimeOfDay;
        }

        /** 
         * Get the 'MinStay' attribute value. 
                                    The amount of elapsed time or number of occurrences of a day of the week needed to satisfy a minimum stay requirement.
                                
         * 
         * @return value
         */
        public BigInteger getMinimumStayMinStay() {
            return minimumStayMinStay;
        }

        /** 
         * Set the 'MinStay' attribute value. 
                                    The amount of elapsed time or number of occurrences of a day of the week needed to satisfy a minimum stay requirement.
                                
         * 
         * @param minimumStayMinStay
         */
        public void setMinimumStayMinStay(BigInteger minimumStayMinStay) {
            this.minimumStayMinStay = minimumStayMinStay;
        }

        /** 
         * Get the 'StayUnit' attribute value. 
                                    The unit of elapsed time or the day of the week applied to the MinStay value.
                                
         * 
         * @return value
         */
        public StayUnitType getMinimumStayStayUnit() {
            return minimumStayStayUnit;
        }

        /** 
         * Set the 'StayUnit' attribute value. 
                                    The unit of elapsed time or the day of the week applied to the MinStay value.
                                
         * 
         * @param minimumStayStayUnit
         */
        public void setMinimumStayStayUnit(StayUnitType minimumStayStayUnit) {
            this.minimumStayStayUnit = minimumStayStayUnit;
        }

        /** 
         * Get the 'MinStayDate' attribute value. 
                                    The specific date for the minimum stay requirement.
                                
         * 
         * @return value
         */
        public String getMinimumStayMinStayDate() {
            return minimumStayMinStayDate;
        }

        /** 
         * Set the 'MinStayDate' attribute value. 
                                    The specific date for the minimum stay requirement.
                                
         * 
         * @param minimumStayMinStayDate
         */
        public void setMinimumStayMinStayDate(String minimumStayMinStayDate) {
            this.minimumStayMinStayDate = minimumStayMinStayDate;
        }

        /** 
         * Get the 'ReturnType' attribute value. 
                                    Code indicating whether travel must commence or be completed in order to satisfy the stay restriction.
                                
         * 
         * @return value
         */
        public ReturnType getMaximumStayReturnType() {
            return maximumStayReturnType;
        }

        /** 
         * Set the 'ReturnType' attribute value. 
                                    Code indicating whether travel must commence or be completed in order to satisfy the stay restriction.
                                
         * 
         * @param maximumStayReturnType
         */
        public void setMaximumStayReturnType(ReturnType maximumStayReturnType) {
            this.maximumStayReturnType = maximumStayReturnType;
        }

        /** 
         * Get the 'ReturnTimeOfDay' attribute value.  The time of day when return travel may commence.
         * 
         * @return value
         */
        public String getMaximumStayReturnTimeOfDay() {
            return maximumStayReturnTimeOfDay;
        }

        /** 
         * Set the 'ReturnTimeOfDay' attribute value.  The time of day when return travel may commence.
         * 
         * @param maximumStayReturnTimeOfDay
         */
        public void setMaximumStayReturnTimeOfDay(
                String maximumStayReturnTimeOfDay) {
            this.maximumStayReturnTimeOfDay = maximumStayReturnTimeOfDay;
        }

        /** 
         * Get the 'MaxStay' attribute value. 
                                    The amount of elapsed time or number of occurrences of a day of the week that must occur to satisfy a maximum stay requirement.
                                
         * 
         * @return value
         */
        public BigInteger getMaximumStayMaxStay() {
            return maximumStayMaxStay;
        }

        /** 
         * Set the 'MaxStay' attribute value. 
                                    The amount of elapsed time or number of occurrences of a day of the week that must occur to satisfy a maximum stay requirement.
                                
         * 
         * @param maximumStayMaxStay
         */
        public void setMaximumStayMaxStay(BigInteger maximumStayMaxStay) {
            this.maximumStayMaxStay = maximumStayMaxStay;
        }

        /** 
         * Get the 'StayUnit' attribute value. 
                                    The unit of elapsed time or the day of the week applied to the MaxStay value.
                                
         * 
         * @return value
         */
        public StayUnitType getMaximumStayStayUnit() {
            return maximumStayStayUnit;
        }

        /** 
         * Set the 'StayUnit' attribute value. 
                                    The unit of elapsed time or the day of the week applied to the MaxStay value.
                                
         * 
         * @param maximumStayStayUnit
         */
        public void setMaximumStayStayUnit(StayUnitType maximumStayStayUnit) {
            this.maximumStayStayUnit = maximumStayStayUnit;
        }

        /** 
         * Get the 'MaxStayDate' attribute value. 
                                    The specific date for the maximum stay requirement.
                                
         * 
         * @return value
         */
        public String getMaximumStayMaxStayDate() {
            return maximumStayMaxStayDate;
        }

        /** 
         * Set the 'MaxStayDate' attribute value. 
                                    The specific date for the maximum stay requirement.
                                
         * 
         * @param maximumStayMaxStayDate
         */
        public void setMaximumStayMaxStayDate(String maximumStayMaxStayDate) {
            this.maximumStayMaxStayDate = maximumStayMaxStayDate;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:string">
         *     &lt;xs:enumeration value="C"/>
         *     &lt;xs:enumeration value="S"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum ReturnType implements Serializable {
            /** 
             * Return travel must be Completed.
             */
            C, /** 
                * Return travel must be Started.
                */
            S
        }
    }
}
