
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 Extends TicketingInfoType to provide an eTicketNumber.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingInfoRS_Type">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FreeTextType" name="TicketAdvisory" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="xs:string" name="TPA_Extensions" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="eTicketNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TicketTimeLimit"/>
 *   &lt;xs:attribute type="ns:TicketType" use="required" name="TicketType"/>
 *   &lt;xs:attribute type="ns:ValidInterlineType" use="optional" default="Unknown" name="ValidInterline"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class TicketingInfoRSType implements Serializable
{
    private List<FreeTextType> ticketAdvisoryList = new ArrayList<FreeTextType>();
    private String TPAExtensions;
    private String ETicketNumber;
    private String ticketTimeLimit;
    private TicketType ticketType;
    private ValidInterlineType validInterline;

    /** 
     * Get the list of 'TicketAdvisory' element items. Open text field available for additional ticket information.
     * 
     * @return list
     */
    public List<FreeTextType> getTicketAdvisoryList() {
        return ticketAdvisoryList;
    }

    /** 
     * Set the list of 'TicketAdvisory' element items. Open text field available for additional ticket information.
     * 
     * @param list
     */
    public void setTicketAdvisoryList(List<FreeTextType> list) {
        ticketAdvisoryList = list;
    }

    /** 
     * Get the 'TPA_Extensions' element value. Place holder for additional elements.
     * 
     * @return value
     */
    public String getTPAExtensions() {
        return TPAExtensions;
    }

    /** 
     * Set the 'TPA_Extensions' element value. Place holder for additional elements.
     * 
     * @param TPAExtensions
     */
    public void setTPAExtensions(String TPAExtensions) {
        this.TPAExtensions = TPAExtensions;
    }

    /** 
     * Get the 'eTicketNumber' attribute value. If reservation is electronically ticketed at time of booking, this is the field for the eTicket number.
     * 
     * @return value
     */
    public String getETicketNumber() {
        return ETicketNumber;
    }

    /** 
     * Set the 'eTicketNumber' attribute value. If reservation is electronically ticketed at time of booking, this is the field for the eTicket number.
     * 
     * @param eTicketNumber
     */
    public void setETicketNumber(String eTicketNumber) {
        ETicketNumber = eTicketNumber;
    }

    /** 
     * Get the 'TicketTimeLimit' attribute value. TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * 
     * @return value
     */
    public String getTicketTimeLimit() {
        return ticketTimeLimit;
    }

    /** 
     * Set the 'TicketTimeLimit' attribute value. TicketTimeLimit - Indicates the ticketing arrangement, and allows for the requirement that an itinerary must be ticketed by a certain date and time.
     * 
     * @param ticketTimeLimit
     */
    public void setTicketTimeLimit(String ticketTimeLimit) {
        this.ticketTimeLimit = ticketTimeLimit;
    }

    /** 
     * Get the 'TicketType' attribute value. TicketType - Indicates the type of ticket (Paper, eTicket)
     * 
     * @return value
     */
    public TicketType getTicketType() {
        return ticketType;
    }

    /** 
     * Set the 'TicketType' attribute value. TicketType - Indicates the type of ticket (Paper, eTicket)
     * 
     * @param ticketType
     */
    public void setTicketType(TicketType ticketType) {
        this.ticketType = ticketType;
    }

    /** 
     * Get the 'ValidInterline' attribute value. ValidInterline - Indicates validation of interline ticketing aggrement, possible values (Yes, No, Unknown), default=unknown
     * 
     * @return value
     */
    public ValidInterlineType getValidInterline() {
        return validInterline;
    }

    /** 
     * Set the 'ValidInterline' attribute value. ValidInterline - Indicates validation of interline ticketing aggrement, possible values (Yes, No, Unknown), default=unknown
     * 
     * @param validInterline
     */
    public void setValidInterline(ValidInterlineType validInterline) {
        this.validInterline = validInterline;
    }
}
