
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Validating Carrier Commission Information
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VCCInformationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FareComponentBreakdownType" name="FareComponentBreakdown" minOccurs="0" maxOccurs="24"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ValidatingCarrier"/>
 *   &lt;xs:attribute type="xs:decimal" use="required" name="CommissionAmount"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="EarnedCommissionAmount"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="TotalAmountIncludingMarkUp"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="CommissionPercent"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CommissionContractQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SourcePCC"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VCCInformationType implements Serializable
{
    private List<FareComponentBreakdownType> fareComponentBreakdownList = new ArrayList<FareComponentBreakdownType>();
    private String validatingCarrier;
    private BigDecimal commissionAmount;
    private BigDecimal earnedCommissionAmount;
    private BigDecimal totalAmountIncludingMarkUp;
    private BigDecimal commissionPercent;
    private String commissionContractQualifier;
    private String sourcePCC;

    /** 
     * Get the list of 'FareComponentBreakdown' element items.
     * 
     * @return list
     */
    public List<FareComponentBreakdownType> getFareComponentBreakdownList() {
        return fareComponentBreakdownList;
    }

    /** 
     * Set the list of 'FareComponentBreakdown' element items.
     * 
     * @param list
     */
    public void setFareComponentBreakdownList(
            List<FareComponentBreakdownType> list) {
        fareComponentBreakdownList = list;
    }

    /** 
     * Get the 'ValidatingCarrier' attribute value.
     * 
     * @return value
     */
    public String getValidatingCarrier() {
        return validatingCarrier;
    }

    /** 
     * Set the 'ValidatingCarrier' attribute value.
     * 
     * @param validatingCarrier
     */
    public void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    /** 
     * Get the 'CommissionAmount' attribute value. Commission Amount (in equivalent amount currency)
     * 
     * @return value
     */
    public BigDecimal getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' attribute value. Commission Amount (in equivalent amount currency)
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(BigDecimal commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'EarnedCommissionAmount' attribute value. Earned Commission Amount
     * 
     * @return value
     */
    public BigDecimal getEarnedCommissionAmount() {
        return earnedCommissionAmount;
    }

    /** 
     * Set the 'EarnedCommissionAmount' attribute value. Earned Commission Amount
     * 
     * @param earnedCommissionAmount
     */
    public void setEarnedCommissionAmount(BigDecimal earnedCommissionAmount) {
        this.earnedCommissionAmount = earnedCommissionAmount;
    }

    /** 
     * Get the 'TotalAmountIncludingMarkUp' attribute value. Total Commision amount including Mark-Up
     * 
     * @return value
     */
    public BigDecimal getTotalAmountIncludingMarkUp() {
        return totalAmountIncludingMarkUp;
    }

    /** 
     * Set the 'TotalAmountIncludingMarkUp' attribute value. Total Commision amount including Mark-Up
     * 
     * @param totalAmountIncludingMarkUp
     */
    public void setTotalAmountIncludingMarkUp(
            BigDecimal totalAmountIncludingMarkUp) {
        this.totalAmountIncludingMarkUp = totalAmountIncludingMarkUp;
    }

    /** 
     * Get the 'CommissionPercent' attribute value.
     * 
     * @return value
     */
    public BigDecimal getCommissionPercent() {
        return commissionPercent;
    }

    /** 
     * Set the 'CommissionPercent' attribute value.
     * 
     * @param commissionPercent
     */
    public void setCommissionPercent(BigDecimal commissionPercent) {
        this.commissionPercent = commissionPercent;
    }

    /** 
     * Get the 'CommissionContractQualifier' attribute value.
     * 
     * @return value
     */
    public String getCommissionContractQualifier() {
        return commissionContractQualifier;
    }

    /** 
     * Set the 'CommissionContractQualifier' attribute value.
     * 
     * @param commissionContractQualifier
     */
    public void setCommissionContractQualifier(
            String commissionContractQualifier) {
        this.commissionContractQualifier = commissionContractQualifier;
    }

    /** 
     * Get the 'SourcePCC' attribute value.
     * 
     * @return value
     */
    public String getSourcePCC() {
        return sourcePCC;
    }

    /** 
     * Set the 'SourcePCC' attribute value.
     * 
     * @param sourcePCC
     */
    public void setSourcePCC(String sourcePCC) {
        this.sourcePCC = sourcePCC;
    }
}
