
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrierInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CarrierCountriesType" name="Default" minOccurs="0"/>
 *     &lt;xs:element type="ns:CarrierCountriesType" name="Alternate" minOccurs="0" maxOccurs="24"/>
 *     &lt;xs:element type="ns:CarrierCountriesType" name="OtherTicketing" minOccurs="0" maxOccurs="24"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" name="SettlementMethod"/>
 *   &lt;xs:attribute type="xs:string" name="Country"/>
 *   &lt;xs:attribute type="xs:boolean" name="NewVcxProcess"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ValidatingCarrierInfoType implements Serializable
{
    private CarrierCountriesType _default;
    private List<CarrierCountriesType> alternateList = new ArrayList<CarrierCountriesType>();
    private List<CarrierCountriesType> otherTicketingList = new ArrayList<CarrierCountriesType>();
    private String settlementMethod;
    private String country;
    private Boolean newVcxProcess;

    /** 
     * Get the 'Default' element value. Default validating carrier code
     * 
     * @return value
     */
    public CarrierCountriesType getDefault() {
        return _default;
    }

    /** 
     * Set the 'Default' element value. Default validating carrier code
     * 
     * @param _default
     */
    public void setDefault(CarrierCountriesType _default) {
        this._default = _default;
    }

    /** 
     * Get the list of 'Alternate' element items. Alternate validating carrier code
     * 
     * @return list
     */
    public List<CarrierCountriesType> getAlternateList() {
        return alternateList;
    }

    /** 
     * Set the list of 'Alternate' element items. Alternate validating carrier code
     * 
     * @param list
     */
    public void setAlternateList(List<CarrierCountriesType> list) {
        alternateList = list;
    }

    /** 
     * Get the list of 'OtherTicketing' element items. Other possible validating carrier code - IET checked, reprice
     * 
     * @return list
     */
    public List<CarrierCountriesType> getOtherTicketingList() {
        return otherTicketingList;
    }

    /** 
     * Set the list of 'OtherTicketing' element items. Other possible validating carrier code - IET checked, reprice
     * 
     * @param list
     */
    public void setOtherTicketingList(List<CarrierCountriesType> list) {
        otherTicketingList = list;
    }

    /** 
     * Get the 'SettlementMethod' attribute value.
     * 
     * @return value
     */
    public String getSettlementMethod() {
        return settlementMethod;
    }

    /** 
     * Set the 'SettlementMethod' attribute value.
     * 
     * @param settlementMethod
     */
    public void setSettlementMethod(String settlementMethod) {
        this.settlementMethod = settlementMethod;
    }

    /** 
     * Get the 'Country' attribute value.
     * 
     * @return value
     */
    public String getCountry() {
        return country;
    }

    /** 
     * Set the 'Country' attribute value.
     * 
     * @param country
     */
    public void setCountry(String country) {
        this.country = country;
    }

    /** 
     * Get the 'NewVcxProcess' attribute value.
     * 
     * @return value
     */
    public Boolean getNewVcxProcess() {
        return newVcxProcess;
    }

    /** 
     * Set the 'NewVcxProcess' attribute value.
     * 
     * @param newVcxProcess
     */
    public void setNewVcxProcess(Boolean newVcxProcess) {
        this.newVcxProcess = newVcxProcess;
    }
}
