
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Specifies if online or interline carrier selection logic should be applied for provided carrier type.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefApplicabilityType">
 *   &lt;xs:attribute type="ns:ApplicabilityEnumType" use="required" name="Value"/>
 *   &lt;xs:attribute type="ns:CarrierType" use="required" name="Type"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VendorPrefApplicabilityType implements Serializable
{
    private ApplicabilityEnumType value;
    private CarrierType type;

    /** 
     * Get the 'Value' attribute value.
     * 
     * @return value
     */
    public ApplicabilityEnumType getValue() {
        return value;
    }

    /** 
     * Set the 'Value' attribute value.
     * 
     * @param value
     */
    public void setValue(ApplicabilityEnumType value) {
        this.value = value;
    }

    /** 
     * Get the 'Type' attribute value. Specifies what type of carrier it applies to.
     * 
     * @return value
     */
    public CarrierType getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Specifies what type of carrier it applies to.
     * 
     * @param type
     */
    public void setType(CarrierType type) {
        this.type = type;
    }
}
