
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Specifies which marketing and operating carrier pairs are preferred or unacceptable.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPrefPairingType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="VendorPref" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class VendorPref -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute use="required" name="PreferLevel">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class PreferLevel -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="ns:ApplicabilityEnumType" default="AllSegments" name="Applicability"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class VendorPrefPairingType implements Serializable
{
    private List<VendorPref> vendorPrefList = new ArrayList<VendorPref>();
    private PreferLevel preferLevel;
    private ApplicabilityEnumType applicability;

    /** 
     * Get the list of 'VendorPref' element items.
     * 
     * @return list
     */
    public List<VendorPref> getVendorPrefList() {
        return vendorPrefList;
    }

    /** 
     * Set the list of 'VendorPref' element items.
     * 
     * @param list
     */
    public void setVendorPrefList(List<VendorPref> list) {
        vendorPrefList = list;
    }

    /** 
     * Get the 'PreferLevel' attribute value.
     * 
     * @return value
     */
    public PreferLevel getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevel preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'Applicability' attribute value.
     * 
     * @return value
     */
    public ApplicabilityEnumType getApplicability() {
        return applicability;
    }

    /** 
     * Set the 'Applicability' attribute value.
     * 
     * @param applicability
     */
    public void setApplicability(ApplicabilityEnumType applicability) {
        this.applicability = applicability;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VendorPref" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
     *     &lt;xs:attribute type="ns:CarrierType" name="Type"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class VendorPref implements Serializable
    {
        private String code;
        private CarrierType type;

        /** 
         * Get the 'Code' attribute value.
         * 
         * @return value
         */
        public String getCode() {
            return code;
        }

        /** 
         * Set the 'Code' attribute value.
         * 
         * @param code
         */
        public void setCode(String code) {
            this.code = code;
        }

        /** 
         * Get the 'Type' attribute value.
         * 
         * @return value
         */
        public CarrierType getType() {
            return type;
        }

        /** 
         * Set the 'Type' attribute value.
         * 
         * @param type
         */
        public void setType(CarrierType type) {
            this.type = type;
        }
    }
    /** 
     * Used to specify a preference level for all carrier combinations inside one element.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Unacceptable"/>
     *     &lt;xs:enumeration value="Preferred"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum PreferLevel implements Serializable {
        UNACCEPTABLE("Unacceptable"), PREFERRED("Preferred");
        private final String value;

        private PreferLevel(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static PreferLevel convert(String value) {
            for (PreferLevel inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
