
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Agency Arranger Info Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgencyInfoType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TaxInfoType" name="TaxInfo" minOccurs="0" maxOccurs="200"/>
 *     &lt;xs:element type="ns:FeeInfoType" name="Fee" minOccurs="0" maxOccurs="10"/>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyDescription"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LanguageIDCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgencyBusinessUnitID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TravelAgencyIdentifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="URL"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="URLLogoLocationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgencyTradeName"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BillableTravelArrangerCd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DefaultInactiveProfilesPurgeNoDays"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="EditPNRDesc"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="WebLoginRestrictID"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="AgyCreditCardAllowInd"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="AgyCreditLimitAllowedInd"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgyCreditLimit"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgencyInfoType implements Serializable
{
    private List<TaxInfoType> taxInfoList = new ArrayList<TaxInfoType>();
    private List<FeeInfoType> feeList = new ArrayList<FeeInfoType>();
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String travelAgencyName;
    private String travelAgencyDescription;
    private String travelAgencyTypeCode;
    private String languageIDCode;
    private String agencyBusinessUnitID;
    private String travelAgencyIdentifier;
    private String URL;
    private String URLLogoLocationText;
    private String agencyTradeName;
    private String billableTravelArrangerCd;
    private String defaultInactiveProfilesPurgeNoDays;
    private String editPNRDesc;
    private String webLoginRestrictID;
    private YesNoType agyCreditCardAllowInd;
    private YesNoType agyCreditLimitAllowedInd;
    private String agyCreditLimit;

    /** 
     * Get the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @return list
     */
    public List<TaxInfoType> getTaxInfoList() {
        return taxInfoList;
    }

    /** 
     * Set the list of 'TaxInfo' element items. *** SABRE ADDED *** Tax Information associated to a profile 
     * 
     * @param list
     */
    public void setTaxInfoList(List<TaxInfoType> list) {
        taxInfoList = list;
    }

    /** 
     * Get the list of 'Fee' element items. *** SABRE ADDED *** Any Fee Specific data stored in an Agency profile
     * 
     * @return list
     */
    public List<FeeInfoType> getFeeList() {
        return feeList;
    }

    /** 
     * Set the list of 'Fee' element items. *** SABRE ADDED *** Any Fee Specific data stored in an Agency profile
     * 
     * @param list
     */
    public void setFeeList(List<FeeInfoType> list) {
        feeList = list;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'TravelAgencyName' attribute value. Description of the Travel Agency
     * 
     * @return value
     */
    public String getTravelAgencyName() {
        return travelAgencyName;
    }

    /** 
     * Set the 'TravelAgencyName' attribute value. Description of the Travel Agency
     * 
     * @param travelAgencyName
     */
    public void setTravelAgencyName(String travelAgencyName) {
        this.travelAgencyName = travelAgencyName;
    }

    /** 
     * Get the 'TravelAgencyDescription' attribute value. Name of the Travel Agency
     * 
     * @return value
     */
    public String getTravelAgencyDescription() {
        return travelAgencyDescription;
    }

    /** 
     * Set the 'TravelAgencyDescription' attribute value. Name of the Travel Agency
     * 
     * @param travelAgencyDescription
     */
    public void setTravelAgencyDescription(String travelAgencyDescription) {
        this.travelAgencyDescription = travelAgencyDescription;
    }

    /** 
     * Get the 'TravelAgencyTypeCode' attribute value.
     * 
     * @return value
     */
    public String getTravelAgencyTypeCode() {
        return travelAgencyTypeCode;
    }

    /** 
     * Set the 'TravelAgencyTypeCode' attribute value.
     * 
     * @param travelAgencyTypeCode
     */
    public void setTravelAgencyTypeCode(String travelAgencyTypeCode) {
        this.travelAgencyTypeCode = travelAgencyTypeCode;
    }

    /** 
     * Get the 'LanguageIDCode' attribute value.
     * 
     * @return value
     */
    public String getLanguageIDCode() {
        return languageIDCode;
    }

    /** 
     * Set the 'LanguageIDCode' attribute value.
     * 
     * @param languageIDCode
     */
    public void setLanguageIDCode(String languageIDCode) {
        this.languageIDCode = languageIDCode;
    }

    /** 
     * Get the 'AgencyBusinessUnitID' attribute value. "Represents an internal identifier assigned by an AGENCY or sub AGENCY for its business unit.   
    e.g. branch, cost center" 
     * 
     * @return value
     */
    public String getAgencyBusinessUnitID() {
        return agencyBusinessUnitID;
    }

    /** 
     * Set the 'AgencyBusinessUnitID' attribute value. "Represents an internal identifier assigned by an AGENCY or sub AGENCY for its business unit.   
    e.g. branch, cost center" 
     * 
     * @param agencyBusinessUnitID
     */
    public void setAgencyBusinessUnitID(String agencyBusinessUnitID) {
        this.agencyBusinessUnitID = agencyBusinessUnitID;
    }

    /** 
     * Get the 'TravelAgencyIdentifier' attribute value. "Represents the Travel industry standard, travel agency identification.  This number can either stem from the ARc, IATA or TID.  (Travel Agency Identifier).   ARC is a ""nationally assigned number"", IATA is internationally assigned and TID is assigned if the other 2 are not the source of information for the agency identification.  Usually the prefix distinguishes what type of source it comes from -- there is no requriement for a type code.  Note: this is a ""restricted field"", and can never be ""updated"" in VTO. 
     * 
     * @return value
     */
    public String getTravelAgencyIdentifier() {
        return travelAgencyIdentifier;
    }

    /** 
     * Set the 'TravelAgencyIdentifier' attribute value. "Represents the Travel industry standard, travel agency identification.  This number can either stem from the ARc, IATA or TID.  (Travel Agency Identifier).   ARC is a ""nationally assigned number"", IATA is internationally assigned and TID is assigned if the other 2 are not the source of information for the agency identification.  Usually the prefix distinguishes what type of source it comes from -- there is no requriement for a type code.  Note: this is a ""restricted field"", and can never be ""updated"" in VTO. 
     * 
     * @param travelAgencyIdentifier
     */
    public void setTravelAgencyIdentifier(String travelAgencyIdentifier) {
        this.travelAgencyIdentifier = travelAgencyIdentifier;
    }

    /** 
     * Get the 'URL' attribute value. Uniform Resource Locator (URL) is the address of a file accessible on the Internet.
     * 
     * @return value
     */
    public String getURL() {
        return URL;
    }

    /** 
     * Set the 'URL' attribute value. Uniform Resource Locator (URL) is the address of a file accessible on the Internet.
     * 
     * @param URL
     */
    public void setURL(String URL) {
        this.URL = URL;
    }

    /** 
     * Get the 'URLLogoLocationText' attribute value. "Description of the location where SVT is holding the  AGENCY's logo associated with an agency. Example: www.DynamicTravel.com Note:  SVT purposes"
     * 
     * @return value
     */
    public String getURLLogoLocationText() {
        return URLLogoLocationText;
    }

    /** 
     * Set the 'URLLogoLocationText' attribute value. "Description of the location where SVT is holding the  AGENCY's logo associated with an agency. Example: www.DynamicTravel.com Note:  SVT purposes"
     * 
     * @param URLLogoLocationText
     */
    public void setURLLogoLocationText(String URLLogoLocationText) {
        this.URLLogoLocationText = URLLogoLocationText;
    }

    /** 
     * Get the 'AgencyTradeName' attribute value. Agency Trade Name 
     * 
     * @return value
     */
    public String getAgencyTradeName() {
        return agencyTradeName;
    }

    /** 
     * Set the 'AgencyTradeName' attribute value. Agency Trade Name 
     * 
     * @param agencyTradeName
     */
    public void setAgencyTradeName(String agencyTradeName) {
        this.agencyTradeName = agencyTradeName;
    }

    /** 
     * Get the 'BillableTravelArrangerCd' attribute value. "The code may represent a Billable travel arranger code" 
     * 
     * @return value
     */
    public String getBillableTravelArrangerCd() {
        return billableTravelArrangerCd;
    }

    /** 
     * Set the 'BillableTravelArrangerCd' attribute value. "The code may represent a Billable travel arranger code" 
     * 
     * @param billableTravelArrangerCd
     */
    public void setBillableTravelArrangerCd(String billableTravelArrangerCd) {
        this.billableTravelArrangerCd = billableTravelArrangerCd;
    }

    /** 
     * Get the 'DefaultInactiveProfilesPurgeNoDays' attribute value. "Represents the number of DAYS to be added to the transaction date, indicative of when a profile should be deleted/purged from the system. If this profile is inactive for a certain number of months: **  the Transaction Action Description will be changed to 'delete'  **  the PROFILE PURGE DATE will be ""set"" to the TRANSACTION DATE +  DEFAULT PURGE NUMBER OF DAYS attribute." 
     * 
     * @return value
     */
    public String getDefaultInactiveProfilesPurgeNoDays() {
        return defaultInactiveProfilesPurgeNoDays;
    }

    /** 
     * Set the 'DefaultInactiveProfilesPurgeNoDays' attribute value. "Represents the number of DAYS to be added to the transaction date, indicative of when a profile should be deleted/purged from the system. If this profile is inactive for a certain number of months: **  the Transaction Action Description will be changed to 'delete'  **  the PROFILE PURGE DATE will be ""set"" to the TRANSACTION DATE +  DEFAULT PURGE NUMBER OF DAYS attribute." 
     * 
     * @param defaultInactiveProfilesPurgeNoDays
     */
    public void setDefaultInactiveProfilesPurgeNoDays(
            String defaultInactiveProfilesPurgeNoDays) {
        this.defaultInactiveProfilesPurgeNoDays = defaultInactiveProfilesPurgeNoDays;
    }

    /** 
     * Get the 'EditPNRDesc' attribute value. "Denotes whether edits should be applied at segment sell or end transaction. Value: Segment Sell
    End Transaction" 
     * 
     * @return value
     */
    public String getEditPNRDesc() {
        return editPNRDesc;
    }

    /** 
     * Set the 'EditPNRDesc' attribute value. "Denotes whether edits should be applied at segment sell or end transaction. Value: Segment Sell
    End Transaction" 
     * 
     * @param editPNRDesc
     */
    public void setEditPNRDesc(String editPNRDesc) {
        this.editPNRDesc = editPNRDesc;
    }

    /** 
     * Get the 'WebLoginRestrictID' attribute value. This is an identifier used by SSW to restrict login to a particular website/storefront for a travel agency. 
     * 
     * @return value
     */
    public String getWebLoginRestrictID() {
        return webLoginRestrictID;
    }

    /** 
     * Set the 'WebLoginRestrictID' attribute value. This is an identifier used by SSW to restrict login to a particular website/storefront for a travel agency. 
     * 
     * @param webLoginRestrictID
     */
    public void setWebLoginRestrictID(String webLoginRestrictID) {
        this.webLoginRestrictID = webLoginRestrictID;
    }

    /** 
     * Get the 'AgyCreditCardAllowInd' attribute value. This indicator is set to 'Y' when the Travel Agency's credit card is enabled as a form of payment. It is set to 'N' when the Travel Agency's credit card is disabled as a form of payment.
     * 
     * @return value
     */
    public YesNoType getAgyCreditCardAllowInd() {
        return agyCreditCardAllowInd;
    }

    /** 
     * Set the 'AgyCreditCardAllowInd' attribute value. This indicator is set to 'Y' when the Travel Agency's credit card is enabled as a form of payment. It is set to 'N' when the Travel Agency's credit card is disabled as a form of payment.
     * 
     * @param agyCreditCardAllowInd
     */
    public void setAgyCreditCardAllowInd(YesNoType agyCreditCardAllowInd) {
        this.agyCreditCardAllowInd = agyCreditCardAllowInd;
    }

    /** 
     * Get the 'AgyCreditLimitAllowedInd' attribute value. This indicator is set to 'Y' when the Agency Credit Limit is enabled as a form of payment. It is set to 'N' when the Agency Credit Limit is disabled as a form of payment.
     * 
     * @return value
     */
    public YesNoType getAgyCreditLimitAllowedInd() {
        return agyCreditLimitAllowedInd;
    }

    /** 
     * Set the 'AgyCreditLimitAllowedInd' attribute value. This indicator is set to 'Y' when the Agency Credit Limit is enabled as a form of payment. It is set to 'N' when the Agency Credit Limit is disabled as a form of payment.
     * 
     * @param agyCreditLimitAllowedInd
     */
    public void setAgyCreditLimitAllowedInd(YesNoType agyCreditLimitAllowedInd) {
        this.agyCreditLimitAllowedInd = agyCreditLimitAllowedInd;
    }

    /** 
     * Get the 'AgyCreditLimit' attribute value. This is an amount field used in association with Agency Credit Limit Allowed Indicator and the POS system will identify the currency used for that amount
     * 
     * @return value
     */
    public String getAgyCreditLimit() {
        return agyCreditLimit;
    }

    /** 
     * Set the 'AgyCreditLimit' attribute value. This is an amount field used in association with Agency Credit Limit Allowed Indicator and the POS system will identify the currency used for that amount
     * 
     * @param agyCreditLimit
     */
    public void setAgyCreditLimit(String agyCreditLimit) {
        this.agyCreditLimit = agyCreditLimit;
    }
}
