
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Agent GDS Identity Data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentGDSIdentityType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentSine"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgentID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="GDSCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AgentGDSIdentityType implements Serializable
{
    private TransactionalDataType transactionalData;
    private String agentSine;
    private String agentID;
    private String GDSCode;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'AgentSine' attribute value. Agent Sign Information
     * 
     * @return value
     */
    public String getAgentSine() {
        return agentSine;
    }

    /** 
     * Set the 'AgentSine' attribute value. Agent Sign Information
     * 
     * @param agentSine
     */
    public void setAgentSine(String agentSine) {
        this.agentSine = agentSine;
    }

    /** 
     * Get the 'AgentID' attribute value. ***SABRE ADDED*** Agent ID in GDS
     * 
     * @return value
     */
    public String getAgentID() {
        return agentID;
    }

    /** 
     * Set the 'AgentID' attribute value. ***SABRE ADDED*** Agent ID in GDS
     * 
     * @param agentID
     */
    public void setAgentID(String agentID) {
        this.agentID = agentID;
    }

    /** 
     * Get the 'GDSCode' attribute value. ***SABRE ADDED*** GDS Code
     * 
     * @return value
     */
    public String getGDSCode() {
        return GDSCode;
    }

    /** 
     * Set the 'GDSCode' attribute value. ***SABRE ADDED*** GDS Code
     * 
     * @param GDSCode
     */
    public void setGDSCode(String GDSCode) {
        this.GDSCode = GDSCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
