
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AllianceProfileType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="Traveler">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="PersonName" minOccurs="0">
 *             &lt;!-- Reference to inner class PersonName -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="CustLoyalty">
 *             &lt;xs:unique name="allianceMembershipLevelVendorUniqueness">
 *               &lt;xs:selector xpath="./p3:AllianceMembershipLevel"/>
 *               &lt;xs:field xpath="@VendorCode"/>
 *             &lt;/xs:unique>
 *             &lt;xs:complexType>
 *               &lt;xs:sequence>
 *                 &lt;xs:element type="ns:AllianceMembershipLevelType" name="AllianceMembershipLevel" maxOccurs="50"/>
 *               &lt;/xs:sequence>
 *             &lt;/xs:complexType>
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AllianceProfileType implements Serializable
{
    private PersonName personName;
    private List<AllianceMembershipLevelType> travelerCustLoyaltyList = new ArrayList<AllianceMembershipLevelType>();

    /** 
     * Get the 'PersonName' element value. ***SABRE ADDED*** To hold Traveler Alliance Profile Information
     * 
     * @return value
     */
    public PersonName getPersonName() {
        return personName;
    }

    /** 
     * Set the 'PersonName' element value. ***SABRE ADDED*** To hold Traveler Alliance Profile Information
     * 
     * @param personName
     */
    public void setPersonName(PersonName personName) {
        this.personName = personName;
    }

    /** 
     * Get the list of 'AllianceMembershipLevel' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @return list
     */
    public List<AllianceMembershipLevelType> getTravelerCustLoyaltyList() {
        return travelerCustLoyaltyList;
    }

    /** 
     * Set the list of 'AllianceMembershipLevel' element items. ***OTA Based *** Customer Loyalty (Frequent Flyer, Prefered Vendor etc.) Information 
     * 
     * @param list
     */
    public void setTravelerCustLoyaltyList(
            List<AllianceMembershipLevelType> list) {
        travelerCustLoyaltyList = list;
    }
    /** 
     * ***SABRE ADDED*** To hold Traveler Name
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PersonName" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element type="xs:string" name="NamePrefix" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="GivenName"/>
     *       &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
     *       &lt;xs:element type="xs:string" name="SurName"/>
     *       &lt;xs:element type="xs:string" name="NameSuffix" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PersonName implements Serializable
    {
        private String namePrefix;
        private String givenName;
        private String middleName;
        private String surName;
        private String nameSuffix;

        /** 
         * Get the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
         * 
         * @return value
         */
        public String getNamePrefix() {
            return namePrefix;
        }

        /** 
         * Set the 'NamePrefix' element value. Salutation of honorific. (e.g., Mr. Mrs., Ms., Miss, Dr.) 
         * 
         * @param namePrefix
         */
        public void setNamePrefix(String namePrefix) {
            this.namePrefix = namePrefix;
        }

        /** 
         * Get the 'GivenName' element value. Given name, first name or names
         * 
         * @return value
         */
        public String getGivenName() {
            return givenName;
        }

        /** 
         * Set the 'GivenName' element value. Given name, first name or names
         * 
         * @param givenName
         */
        public void setGivenName(String givenName) {
            this.givenName = givenName;
        }

        /** 
         * Get the 'MiddleName' element value. The middle name of the person name
         * 
         * @return value
         */
        public String getMiddleName() {
            return middleName;
        }

        /** 
         * Set the 'MiddleName' element value. The middle name of the person name
         * 
         * @param middleName
         */
        public void setMiddleName(String middleName) {
            this.middleName = middleName;
        }

        /** 
         * Get the 'SurName' element value. Family name, last name.
         * 
         * @return value
         */
        public String getSurName() {
            return surName;
        }

        /** 
         * Set the 'SurName' element value. Family name, last name.
         * 
         * @param surName
         */
        public void setSurName(String surName) {
            this.surName = surName;
        }

        /** 
         * Get the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
         * 
         * @return value
         */
        public String getNameSuffix() {
            return nameSuffix;
        }

        /** 
         * Set the 'NameSuffix' element value. Hold various name suffixes and letters (e.g. Jr., Sr., III, Ret., Esq.).
         * 
         * @param nameSuffix
         */
        public void setNameSuffix(String nameSuffix) {
            this.nameSuffix = nameSuffix;
        }
    }
}
