
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationSearchCriteriaType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:SearchAssociationType" name="Association"/>
 *     &lt;xs:element type="ns:SearchAssociatedProfilesType" name="Profile" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedFilterCriteriaType" name="Filter" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedFormatCriteriaType" name="Format" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedMetadataCriteriaType" name="Metadata" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedValidatorCriteriaType" name="Validator" minOccurs="0"/>
 *     &lt;xs:element type="ns:SearchAssociatedAssociationType" name="ParentAssociation" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PageNumber"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="ReturnCount"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="CountAll"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationSearchCriteriaType implements Serializable
{
    private SearchAssociationType association;
    private SearchAssociatedProfilesType profile;
    private SearchAssociatedFilterCriteriaType filter;
    private SearchAssociatedFormatCriteriaType format;
    private SearchAssociatedMetadataCriteriaType metadata;
    private SearchAssociatedValidatorCriteriaType validator;
    private SearchAssociatedAssociationType parentAssociation;
    private String pageNumber;
    private BigInteger returnCount;
    private YesNoType countAll;

    /** 
     * Get the 'Association' element value.
     * 
     * @return value
     */
    public SearchAssociationType getAssociation() {
        return association;
    }

    /** 
     * Set the 'Association' element value.
     * 
     * @param association
     */
    public void setAssociation(SearchAssociationType association) {
        this.association = association;
    }

    /** 
     * Get the 'Profile' element value.
     * 
     * @return value
     */
    public SearchAssociatedProfilesType getProfile() {
        return profile;
    }

    /** 
     * Set the 'Profile' element value.
     * 
     * @param profile
     */
    public void setProfile(SearchAssociatedProfilesType profile) {
        this.profile = profile;
    }

    /** 
     * Get the 'Filter' element value.
     * 
     * @return value
     */
    public SearchAssociatedFilterCriteriaType getFilter() {
        return filter;
    }

    /** 
     * Set the 'Filter' element value.
     * 
     * @param filter
     */
    public void setFilter(SearchAssociatedFilterCriteriaType filter) {
        this.filter = filter;
    }

    /** 
     * Get the 'Format' element value.
     * 
     * @return value
     */
    public SearchAssociatedFormatCriteriaType getFormat() {
        return format;
    }

    /** 
     * Set the 'Format' element value.
     * 
     * @param format
     */
    public void setFormat(SearchAssociatedFormatCriteriaType format) {
        this.format = format;
    }

    /** 
     * Get the 'Metadata' element value.
     * 
     * @return value
     */
    public SearchAssociatedMetadataCriteriaType getMetadata() {
        return metadata;
    }

    /** 
     * Set the 'Metadata' element value.
     * 
     * @param metadata
     */
    public void setMetadata(SearchAssociatedMetadataCriteriaType metadata) {
        this.metadata = metadata;
    }

    /** 
     * Get the 'Validator' element value.
     * 
     * @return value
     */
    public SearchAssociatedValidatorCriteriaType getValidator() {
        return validator;
    }

    /** 
     * Set the 'Validator' element value.
     * 
     * @param validator
     */
    public void setValidator(SearchAssociatedValidatorCriteriaType validator) {
        this.validator = validator;
    }

    /** 
     * Get the 'ParentAssociation' element value.
     * 
     * @return value
     */
    public SearchAssociatedAssociationType getParentAssociation() {
        return parentAssociation;
    }

    /** 
     * Set the 'ParentAssociation' element value.
     * 
     * @param parentAssociation
     */
    public void setParentAssociation(
            SearchAssociatedAssociationType parentAssociation) {
        this.parentAssociation = parentAssociation;
    }

    /** 
     * Get the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @return value
     */
    public String getPageNumber() {
        return pageNumber;
    }

    /** 
     * Set the 'PageNumber' attribute value. 
     *** SABRE ADDED *** Needed for repetitive search, if
    				not populated then it is considered first search
    			
     * 
     * @param pageNumber
     */
    public void setPageNumber(String pageNumber) {
        this.pageNumber = pageNumber;
    }

    /** 
     * Get the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Association to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @return value
     */
    public BigInteger getReturnCount() {
        return returnCount;
    }

    /** 
     * Set the 'ReturnCount' attribute value. 
     *** SABRE ADDED *** Association to be returned in
    				response, if not populated then we will return
    				default count
    			
     * 
     * @param returnCount
     */
    public void setReturnCount(BigInteger returnCount) {
        this.returnCount = returnCount;
    }

    /** 
     * Get the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @return value
     */
    public YesNoType getCountAll() {
        return countAll;
    }

    /** 
     * Set the 'CountAll' attribute value. 
     *** SABRE ADDED *** Default NO. If total count will be returnted in the response. Works for first page only
    					
     * 
     * @param countAll
     */
    public void setCountAll(YesNoType countAll) {
        this.countAll = countAll;
    }
}
