
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Root element for Association content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AssociationType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:AssociationHeaderType">
 *       &lt;xs:sequence>
 *         &lt;xs:element type="ns:ProfileAssociationType" name="ParentAssociation" minOccurs="0"/>
 *         &lt;xs:element type="ns:AssociatedProfilesType" name="AssociatedProfiles" minOccurs="0" maxOccurs="500"/>
 *         &lt;xs:element type="ns:TemplateAssociatedFiltersType" name="AssociatedFilters" minOccurs="0" maxOccurs="100"/>
 *         &lt;xs:element type="ns:TemplateAssociatedFormatsType" name="AssociatedFormats" minOccurs="0" maxOccurs="500"/>
 *         &lt;xs:element type="ns:AssociatedMetadataType" name="AssociatedMetadata" minOccurs="0" maxOccurs="25"/>
 *         &lt;xs:element type="ns:AssociatedValidatorType" name="AssociatedValidators" minOccurs="0" maxOccurs="25"/>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class AssociationType extends AssociationHeaderType implements
    Serializable
{
    private ProfileAssociationType parentAssociation;
    private List<AssociatedProfilesType> associatedProfileList = new ArrayList<AssociatedProfilesType>();
    private List<TemplateAssociatedFiltersType> associatedFilterList = new ArrayList<TemplateAssociatedFiltersType>();
    private List<TemplateAssociatedFormatsType> associatedFormatList = new ArrayList<TemplateAssociatedFormatsType>();
    private List<AssociatedMetadataType> associatedMetadataList = new ArrayList<AssociatedMetadataType>();
    private List<AssociatedValidatorType> associatedValidatorList = new ArrayList<AssociatedValidatorType>();

    /** 
     * Get the 'ParentAssociation' element value. ***SABRE ADDED*** To hold associated data identity information
     * 
     * @return value
     */
    public ProfileAssociationType getParentAssociation() {
        return parentAssociation;
    }

    /** 
     * Set the 'ParentAssociation' element value. ***SABRE ADDED*** To hold associated data identity information
     * 
     * @param parentAssociation
     */
    public void setParentAssociation(ProfileAssociationType parentAssociation) {
        this.parentAssociation = parentAssociation;
    }

    /** 
     * Get the list of 'AssociatedProfiles' element items. Information about profiles associated with Association
     * 
     * @return list
     */
    public List<AssociatedProfilesType> getAssociatedProfileList() {
        return associatedProfileList;
    }

    /** 
     * Set the list of 'AssociatedProfiles' element items. Information about profiles associated with Association
     * 
     * @param list
     */
    public void setAssociatedProfileList(List<AssociatedProfilesType> list) {
        associatedProfileList = list;
    }

    /** 
     * Get the list of 'AssociatedFilters' element items. Information about Filters associated with Association
     * 
     * @return list
     */
    public List<TemplateAssociatedFiltersType> getAssociatedFilterList() {
        return associatedFilterList;
    }

    /** 
     * Set the list of 'AssociatedFilters' element items. Information about Filters associated with Association
     * 
     * @param list
     */
    public void setAssociatedFilterList(List<TemplateAssociatedFiltersType> list) {
        associatedFilterList = list;
    }

    /** 
     * Get the list of 'AssociatedFormats' element items. Information about Formats associated with Association
     * 
     * @return list
     */
    public List<TemplateAssociatedFormatsType> getAssociatedFormatList() {
        return associatedFormatList;
    }

    /** 
     * Set the list of 'AssociatedFormats' element items. Information about Formats associated with Association
     * 
     * @param list
     */
    public void setAssociatedFormatList(List<TemplateAssociatedFormatsType> list) {
        associatedFormatList = list;
    }

    /** 
     * Get the list of 'AssociatedMetadata' element items. Information about Metadata associated with Association
     * 
     * @return list
     */
    public List<AssociatedMetadataType> getAssociatedMetadataList() {
        return associatedMetadataList;
    }

    /** 
     * Set the list of 'AssociatedMetadata' element items. Information about Metadata associated with Association
     * 
     * @param list
     */
    public void setAssociatedMetadataList(List<AssociatedMetadataType> list) {
        associatedMetadataList = list;
    }

    /** 
     * Get the list of 'AssociatedValidators' element items. Information about Profile validators associated with Association
     * 
     * @return list
     */
    public List<AssociatedValidatorType> getAssociatedValidatorList() {
        return associatedValidatorList;
    }

    /** 
     * Set the list of 'AssociatedValidators' element items. Information about Profile validators associated with Association
     * 
     * @param list
     */
    public void setAssociatedValidatorList(List<AssociatedValidatorType> list) {
        associatedValidatorList = list;
    }
}
