
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Create Customer Defined data type data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CategoryCodeType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="CustomFieldCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CustomFieldCodeDescription"/>
 *   &lt;xs:attribute type="ns:FieldCodeDataType" use="optional" name="CustomFieldDataType"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="CustomFieldMinSize"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="CustomFieldMaxSize"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DomainID"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CategoryCodeType implements Serializable
{
    private DataSourceInfoType dataSource;
    private String customFieldCode;
    private String customFieldCodeDescription;
    private FieldCodeDataType customFieldDataType;
    private BigInteger customFieldMinSize;
    private BigInteger customFieldMaxSize;
    private String domainID;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'CustomFieldCode' attribute value.
     * 
     * @return value
     */
    public String getCustomFieldCode() {
        return customFieldCode;
    }

    /** 
     * Set the 'CustomFieldCode' attribute value.
     * 
     * @param customFieldCode
     */
    public void setCustomFieldCode(String customFieldCode) {
        this.customFieldCode = customFieldCode;
    }

    /** 
     * Get the 'CustomFieldCodeDescription' attribute value.
     * 
     * @return value
     */
    public String getCustomFieldCodeDescription() {
        return customFieldCodeDescription;
    }

    /** 
     * Set the 'CustomFieldCodeDescription' attribute value.
     * 
     * @param customFieldCodeDescription
     */
    public void setCustomFieldCodeDescription(String customFieldCodeDescription) {
        this.customFieldCodeDescription = customFieldCodeDescription;
    }

    /** 
     * Get the 'CustomFieldDataType' attribute value. 
    	
     * 
     * @return value
     */
    public FieldCodeDataType getCustomFieldDataType() {
        return customFieldDataType;
    }

    /** 
     * Set the 'CustomFieldDataType' attribute value. 
    	
     * 
     * @param customFieldDataType
     */
    public void setCustomFieldDataType(FieldCodeDataType customFieldDataType) {
        this.customFieldDataType = customFieldDataType;
    }

    /** 
     * Get the 'CustomFieldMinSize' attribute value. 
    	
     * 
     * @return value
     */
    public BigInteger getCustomFieldMinSize() {
        return customFieldMinSize;
    }

    /** 
     * Set the 'CustomFieldMinSize' attribute value. 
    	
     * 
     * @param customFieldMinSize
     */
    public void setCustomFieldMinSize(BigInteger customFieldMinSize) {
        this.customFieldMinSize = customFieldMinSize;
    }

    /** 
     * Get the 'CustomFieldMaxSize' attribute value. 
    	
     * 
     * @return value
     */
    public BigInteger getCustomFieldMaxSize() {
        return customFieldMaxSize;
    }

    /** 
     * Set the 'CustomFieldMaxSize' attribute value. 
    	
     * 
     * @param customFieldMaxSize
     */
    public void setCustomFieldMaxSize(BigInteger customFieldMaxSize) {
        this.customFieldMaxSize = customFieldMaxSize;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }
}
