
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Commissions Type 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CommissionMeasureTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CommissionValue"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ServiceTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="TripTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="SupplierCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CommissionDescription"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="EffectiveDate"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="DiscontinueDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoOriginCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoDestinationCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GeoRegionCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CommissionsType implements Serializable
{
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String commissionMeasureTypeCode;
    private String commissionValue;
    private String serviceTypeCode;
    private String tripTypeCode;
    private String supplierCode;
    private String commissionDescription;
    private Date effectiveDate;
    private Date discontinueDate;
    private String informationText;
    private String geoOriginCode;
    private String geoDestinationCode;
    private String geoRegionCode;
    private String displaySequenceNo;
    private String orderSequenceNo;

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'CommissionMeasureTypeCode' attribute value. ***SABRE ADDED*** Commission Amount
     * 
     * @return value
     */
    public String getCommissionMeasureTypeCode() {
        return commissionMeasureTypeCode;
    }

    /** 
     * Set the 'CommissionMeasureTypeCode' attribute value. ***SABRE ADDED*** Commission Amount
     * 
     * @param commissionMeasureTypeCode
     */
    public void setCommissionMeasureTypeCode(String commissionMeasureTypeCode) {
        this.commissionMeasureTypeCode = commissionMeasureTypeCode;
    }

    /** 
     * Get the 'CommissionValue' attribute value. ***SABRE ADDED*** Commission Amount
     * 
     * @return value
     */
    public String getCommissionValue() {
        return commissionValue;
    }

    /** 
     * Set the 'CommissionValue' attribute value. ***SABRE ADDED*** Commission Amount
     * 
     * @param commissionValue
     */
    public void setCommissionValue(String commissionValue) {
        this.commissionValue = commissionValue;
    }

    /** 
     * Get the 'ServiceTypeCode' attribute value. ***SABRE ADDED*** Service Type Code
     * 
     * @return value
     */
    public String getServiceTypeCode() {
        return serviceTypeCode;
    }

    /** 
     * Set the 'ServiceTypeCode' attribute value. ***SABRE ADDED*** Service Type Code
     * 
     * @param serviceTypeCode
     */
    public void setServiceTypeCode(String serviceTypeCode) {
        this.serviceTypeCode = serviceTypeCode;
    }

    /** 
     * Get the 'TripTypeCode' attribute value. ***SABRE ADDED*** Commission Trip Type Code
     * 
     * @return value
     */
    public String getTripTypeCode() {
        return tripTypeCode;
    }

    /** 
     * Set the 'TripTypeCode' attribute value. ***SABRE ADDED*** Commission Trip Type Code
     * 
     * @param tripTypeCode
     */
    public void setTripTypeCode(String tripTypeCode) {
        this.tripTypeCode = tripTypeCode;
    }

    /** 
     * Get the 'SupplierCode' attribute value. Commission Supplier Code
     * 
     * @return value
     */
    public String getSupplierCode() {
        return supplierCode;
    }

    /** 
     * Set the 'SupplierCode' attribute value. Commission Supplier Code
     * 
     * @param supplierCode
     */
    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode;
    }

    /** 
     * Get the 'CommissionDescription' attribute value. ***SABRE ADDED*** Commission Description
     * 
     * @return value
     */
    public String getCommissionDescription() {
        return commissionDescription;
    }

    /** 
     * Set the 'CommissionDescription' attribute value. ***SABRE ADDED*** Commission Description
     * 
     * @param commissionDescription
     */
    public void setCommissionDescription(String commissionDescription) {
        this.commissionDescription = commissionDescription;
    }

    /** 
     * Get the 'EffectiveDate' attribute value. ***SABRE ADDED*** Commission Effective Date
     * 
     * @return value
     */
    public Date getEffectiveDate() {
        return effectiveDate;
    }

    /** 
     * Set the 'EffectiveDate' attribute value. ***SABRE ADDED*** Commission Effective Date
     * 
     * @param effectiveDate
     */
    public void setEffectiveDate(Date effectiveDate) {
        this.effectiveDate = effectiveDate;
    }

    /** 
     * Get the 'DiscontinueDate' attribute value. ***SABRE ADDED*** Commission Discontinue Date
     * 
     * @return value
     */
    public Date getDiscontinueDate() {
        return discontinueDate;
    }

    /** 
     * Set the 'DiscontinueDate' attribute value. ***SABRE ADDED*** Commission Discontinue Date
     * 
     * @param discontinueDate
     */
    public void setDiscontinueDate(Date discontinueDate) {
        this.discontinueDate = discontinueDate;
    }

    /** 
     * Get the 'InformationText' attribute value. Information Text
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information Text
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }

    /** 
     * Get the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @return value
     */
    public String getGeoOriginCode() {
        return geoOriginCode;
    }

    /** 
     * Set the 'GeoOriginCode' attribute value. Origin Code	
     * 
     * @param geoOriginCode
     */
    public void setGeoOriginCode(String geoOriginCode) {
        this.geoOriginCode = geoOriginCode;
    }

    /** 
     * Get the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @return value
     */
    public String getGeoDestinationCode() {
        return geoDestinationCode;
    }

    /** 
     * Set the 'GeoDestinationCode' attribute value. Des type Code	
     * 
     * @param geoDestinationCode
     */
    public void setGeoDestinationCode(String geoDestinationCode) {
        this.geoDestinationCode = geoDestinationCode;
    }

    /** 
     * Get the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @return value
     */
    public String getGeoRegionCode() {
        return geoRegionCode;
    }

    /** 
     * Set the 'GeoRegionCode' attribute value. Trip type Code	
     * 
     * @param geoRegionCode
     */
    public void setGeoRegionCode(String geoRegionCode) {
        this.geoRegionCode = geoRegionCode;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }
}
