
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Configuration Data Store
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConfigurationType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:FormatConfigurationType" name="FormatConfiguration" minOccurs="0" maxOccurs="20"/>
 *     &lt;xs:element type="ns:DataConfigurationType" name="DataConfiguration" minOccurs="0"/>
 *     &lt;xs:element type="ns:AccessConfigurationType" name="AccessConfiguration" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="ConfigurationID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="DomainLevelConfig"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ConfigurationType implements Serializable
{
    private List<FormatConfigurationType> formatConfigurationList = new ArrayList<FormatConfigurationType>();
    private DataConfigurationType dataConfiguration;
    private AccessConfigurationType accessConfiguration;
    private String configurationID;
    private String domainID;
    private String clientCode;
    private String clientContextCode;
    private YesNoType domainLevelConfig;

    /** 
     * Get the list of 'FormatConfiguration' element items. *** SABRE ADDED *** Configuration Options on Formats
     * 
     * @return list
     */
    public List<FormatConfigurationType> getFormatConfigurationList() {
        return formatConfigurationList;
    }

    /** 
     * Set the list of 'FormatConfiguration' element items. *** SABRE ADDED *** Configuration Options on Formats
     * 
     * @param list
     */
    public void setFormatConfigurationList(List<FormatConfigurationType> list) {
        formatConfigurationList = list;
    }

    /** 
     * Get the 'DataConfiguration' element value. *** SABRE ADDED *** Configuration Options on Data
     * 
     * @return value
     */
    public DataConfigurationType getDataConfiguration() {
        return dataConfiguration;
    }

    /** 
     * Set the 'DataConfiguration' element value. *** SABRE ADDED *** Configuration Options on Data
     * 
     * @param dataConfiguration
     */
    public void setDataConfiguration(DataConfigurationType dataConfiguration) {
        this.dataConfiguration = dataConfiguration;
    }

    /** 
     * Get the 'AccessConfiguration' element value. *** SABRE ADDED *** Configuration Options on Access
     * 
     * @return value
     */
    public AccessConfigurationType getAccessConfiguration() {
        return accessConfiguration;
    }

    /** 
     * Set the 'AccessConfiguration' element value. *** SABRE ADDED *** Configuration Options on Access
     * 
     * @param accessConfiguration
     */
    public void setAccessConfiguration(
            AccessConfigurationType accessConfiguration) {
        this.accessConfiguration = accessConfiguration;
    }

    /** 
     * Get the 'ConfigurationID' attribute value. *** SABRE ADDED *** ID of the Configuration in the database
     * 
     * @return value
     */
    public String getConfigurationID() {
        return configurationID;
    }

    /** 
     * Set the 'ConfigurationID' attribute value. *** SABRE ADDED *** ID of the Configuration in the database
     * 
     * @param configurationID
     */
    public void setConfigurationID(String configurationID) {
        this.configurationID = configurationID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'DomainLevelConfig' attribute value. Indicates if the configuration is applied at Domain Level or Profile level
     * 
     * @return value
     */
    public YesNoType getDomainLevelConfig() {
        return domainLevelConfig;
    }

    /** 
     * Set the 'DomainLevelConfig' attribute value. Indicates if the configuration is applied at Domain Level or Profile level
     * 
     * @param domainLevelConfig
     */
    public void setDomainLevelConfig(YesNoType domainLevelConfig) {
        this.domainLevelConfig = domainLevelConfig;
    }
}
