
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * *** SABRE ADDED *** Used to copy entries from Source Dictionary to Destination Dictionary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CopyDictionaryType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="SourceDictionary"/>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="DestinationDictionary" maxOccurs="50"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CopyDictionaryType implements Serializable
{
    private DictionaryIdentityType sourceDictionary;
    private List<DictionaryIdentityType> destinationDictionaryList = new ArrayList<DictionaryIdentityType>();

    /** 
     * Get the 'SourceDictionary' element value. *** SABRE ADDED *** Defines the Source Dictionary
     * 
     * @return value
     */
    public DictionaryIdentityType getSourceDictionary() {
        return sourceDictionary;
    }

    /** 
     * Set the 'SourceDictionary' element value. *** SABRE ADDED *** Defines the Source Dictionary
     * 
     * @param sourceDictionary
     */
    public void setSourceDictionary(DictionaryIdentityType sourceDictionary) {
        this.sourceDictionary = sourceDictionary;
    }

    /** 
     * Get the list of 'DestinationDictionary' element items. *** SABRE ADDED *** Defines the Destination Dictionary
     * 
     * @return list
     */
    public List<DictionaryIdentityType> getDestinationDictionaryList() {
        return destinationDictionaryList;
    }

    /** 
     * Set the list of 'DestinationDictionary' element items. *** SABRE ADDED *** Defines the Destination Dictionary
     * 
     * @param list
     */
    public void setDestinationDictionaryList(List<DictionaryIdentityType> list) {
        destinationDictionaryList = list;
    }
}
