
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Loyalty data
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyaltyTotalsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="MilesToExpireOnDate" minOccurs="0" maxOccurs="25">
 *       &lt;!-- Reference to inner class MilesToExpireOnDate -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AdditionalInfo" minOccurs="0" maxOccurs="25">
 *       &lt;!-- Reference to inner class AdditionalInfo -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="AccountBalance"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="MembershipStartDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MilesToExpire"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="MilesExpireDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LatestAwardAmount"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="LatestAwardDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PrizeEligibleAmount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreferenceRank"/>
 *   &lt;xs:attribute type="xs:date" use="optional" name="StatusDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="YearToDateAmount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreviousYearAmount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="LifetimeAmount"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RewardSubscriptionLevelText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustLoyaltyTotalsType implements Serializable
{
    private List<MilesToExpireOnDate> milesToExpireOnDateList = new ArrayList<MilesToExpireOnDate>();
    private List<AdditionalInfo> additionalInfoList = new ArrayList<AdditionalInfo>();
    private String accountBalance;
    private Date membershipStartDate;
    private String milesToExpire;
    private Date milesExpireDate;
    private String latestAwardAmount;
    private Date latestAwardDate;
    private String prizeEligibleAmount;
    private String preferenceRank;
    private Date statusDate;
    private String yearToDateAmount;
    private String previousYearAmount;
    private String lifetimeAmount;
    private String rewardSubscriptionLevelText;

    /** 
     * Get the list of 'MilesToExpireOnDate' element items.
     * 
     * @return list
     */
    public List<MilesToExpireOnDate> getMilesToExpireOnDateList() {
        return milesToExpireOnDateList;
    }

    /** 
     * Set the list of 'MilesToExpireOnDate' element items.
     * 
     * @param list
     */
    public void setMilesToExpireOnDateList(List<MilesToExpireOnDate> list) {
        milesToExpireOnDateList = list;
    }

    /** 
     * Get the list of 'AdditionalInfo' element items.
     * 
     * @return list
     */
    public List<AdditionalInfo> getAdditionalInfoList() {
        return additionalInfoList;
    }

    /** 
     * Set the list of 'AdditionalInfo' element items.
     * 
     * @param list
     */
    public void setAdditionalInfoList(List<AdditionalInfo> list) {
        additionalInfoList = list;
    }

    /** 
     * Get the 'AccountBalance' attribute value.
     * 
     * @return value
     */
    public String getAccountBalance() {
        return accountBalance;
    }

    /** 
     * Set the 'AccountBalance' attribute value.
     * 
     * @param accountBalance
     */
    public void setAccountBalance(String accountBalance) {
        this.accountBalance = accountBalance;
    }

    /** 
     * Get the 'MembershipStartDate' attribute value.
     * 
     * @return value
     */
    public Date getMembershipStartDate() {
        return membershipStartDate;
    }

    /** 
     * Set the 'MembershipStartDate' attribute value.
     * 
     * @param membershipStartDate
     */
    public void setMembershipStartDate(Date membershipStartDate) {
        this.membershipStartDate = membershipStartDate;
    }

    /** 
     * Get the 'MilesToExpire' attribute value.
     * 
     * @return value
     */
    public String getMilesToExpire() {
        return milesToExpire;
    }

    /** 
     * Set the 'MilesToExpire' attribute value.
     * 
     * @param milesToExpire
     */
    public void setMilesToExpire(String milesToExpire) {
        this.milesToExpire = milesToExpire;
    }

    /** 
     * Get the 'MilesExpireDate' attribute value.
     * 
     * @return value
     */
    public Date getMilesExpireDate() {
        return milesExpireDate;
    }

    /** 
     * Set the 'MilesExpireDate' attribute value.
     * 
     * @param milesExpireDate
     */
    public void setMilesExpireDate(Date milesExpireDate) {
        this.milesExpireDate = milesExpireDate;
    }

    /** 
     * Get the 'LatestAwardAmount' attribute value.
     * 
     * @return value
     */
    public String getLatestAwardAmount() {
        return latestAwardAmount;
    }

    /** 
     * Set the 'LatestAwardAmount' attribute value.
     * 
     * @param latestAwardAmount
     */
    public void setLatestAwardAmount(String latestAwardAmount) {
        this.latestAwardAmount = latestAwardAmount;
    }

    /** 
     * Get the 'LatestAwardDate' attribute value.
     * 
     * @return value
     */
    public Date getLatestAwardDate() {
        return latestAwardDate;
    }

    /** 
     * Set the 'LatestAwardDate' attribute value.
     * 
     * @param latestAwardDate
     */
    public void setLatestAwardDate(Date latestAwardDate) {
        this.latestAwardDate = latestAwardDate;
    }

    /** 
     * Get the 'PrizeEligibleAmount' attribute value.
     * 
     * @return value
     */
    public String getPrizeEligibleAmount() {
        return prizeEligibleAmount;
    }

    /** 
     * Set the 'PrizeEligibleAmount' attribute value.
     * 
     * @param prizeEligibleAmount
     */
    public void setPrizeEligibleAmount(String prizeEligibleAmount) {
        this.prizeEligibleAmount = prizeEligibleAmount;
    }

    /** 
     * Get the 'PreferenceRank' attribute value.
     * 
     * @return value
     */
    public String getPreferenceRank() {
        return preferenceRank;
    }

    /** 
     * Set the 'PreferenceRank' attribute value.
     * 
     * @param preferenceRank
     */
    public void setPreferenceRank(String preferenceRank) {
        this.preferenceRank = preferenceRank;
    }

    /** 
     * Get the 'StatusDate' attribute value.
     * 
     * @return value
     */
    public Date getStatusDate() {
        return statusDate;
    }

    /** 
     * Set the 'StatusDate' attribute value.
     * 
     * @param statusDate
     */
    public void setStatusDate(Date statusDate) {
        this.statusDate = statusDate;
    }

    /** 
     * Get the 'YearToDateAmount' attribute value.
     * 
     * @return value
     */
    public String getYearToDateAmount() {
        return yearToDateAmount;
    }

    /** 
     * Set the 'YearToDateAmount' attribute value.
     * 
     * @param yearToDateAmount
     */
    public void setYearToDateAmount(String yearToDateAmount) {
        this.yearToDateAmount = yearToDateAmount;
    }

    /** 
     * Get the 'PreviousYearAmount' attribute value.
     * 
     * @return value
     */
    public String getPreviousYearAmount() {
        return previousYearAmount;
    }

    /** 
     * Set the 'PreviousYearAmount' attribute value.
     * 
     * @param previousYearAmount
     */
    public void setPreviousYearAmount(String previousYearAmount) {
        this.previousYearAmount = previousYearAmount;
    }

    /** 
     * Get the 'LifetimeAmount' attribute value.
     * 
     * @return value
     */
    public String getLifetimeAmount() {
        return lifetimeAmount;
    }

    /** 
     * Set the 'LifetimeAmount' attribute value.
     * 
     * @param lifetimeAmount
     */
    public void setLifetimeAmount(String lifetimeAmount) {
        this.lifetimeAmount = lifetimeAmount;
    }

    /** 
     * Get the 'RewardSubscriptionLevelText' attribute value.
     * 
     * @return value
     */
    public String getRewardSubscriptionLevelText() {
        return rewardSubscriptionLevelText;
    }

    /** 
     * Set the 'RewardSubscriptionLevelText' attribute value.
     * 
     * @param rewardSubscriptionLevelText
     */
    public void setRewardSubscriptionLevelText(
            String rewardSubscriptionLevelText) {
        this.rewardSubscriptionLevelText = rewardSubscriptionLevelText;
    }
    /** 
     * Stores pairs of "Miles expring" and "Expire date". i.e.: X miles exping in 3/30/12, Y miles exping in 4/30/12  and Z miles expiring in 5/30/12 
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MilesToExpireOnDate" minOccurs="0" maxOccurs="25">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="MilesTypeCode"/>
     *     &lt;xs:attribute type="xs:date" use="required" name="MilesExpireDate"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="MilesToExpire"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class MilesToExpireOnDate implements Serializable
    {
        private String milesTypeCode;
        private Date milesExpireDate;
        private String milesToExpire;

        /** 
         * Get the 'MilesTypeCode' attribute value. The type of the miles
         * 
         * @return value
         */
        public String getMilesTypeCode() {
            return milesTypeCode;
        }

        /** 
         * Set the 'MilesTypeCode' attribute value. The type of the miles
         * 
         * @param milesTypeCode
         */
        public void setMilesTypeCode(String milesTypeCode) {
            this.milesTypeCode = milesTypeCode;
        }

        /** 
         * Get the 'MilesExpireDate' attribute value. The date when given amount of the miles will expire
         * 
         * @return value
         */
        public Date getMilesExpireDate() {
            return milesExpireDate;
        }

        /** 
         * Set the 'MilesExpireDate' attribute value. The date when given amount of the miles will expire
         * 
         * @param milesExpireDate
         */
        public void setMilesExpireDate(Date milesExpireDate) {
            this.milesExpireDate = milesExpireDate;
        }

        /** 
         * Get the 'MilesToExpire' attribute value. The amount of miles that will expire on given date
         * 
         * @return value
         */
        public String getMilesToExpire() {
            return milesToExpire;
        }

        /** 
         * Set the 'MilesToExpire' attribute value. The amount of miles that will expire on given date
         * 
         * @param milesToExpire
         */
        public void setMilesToExpire(String milesToExpire) {
            this.milesToExpire = milesToExpire;
        }
    }
    /** 
     * Contains additional information about cutomer loyalty, for example tier miles and segments. Tier level miles are gained only when flying qualifying segment these count to allow user to reach "tier level".
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalInfo" minOccurs="0" maxOccurs="25">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:string" use="required" name="TypeCode"/>
     *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AdditionalInfo implements Serializable
    {
        private String typeCode;
        private String value;

        /** 
         * Get the 'TypeCode' attribute value. The name of the type of additonal info value, like: 
        TIEXD	TierExpireDate
        TIMIL	TierMiles	
        TIM12 TierMiliesForLast12Months	
        TIMQP	TierMiliesForQualificationPeriod	
        TISEG	TierSegments	
        TIS12	TierSegmentsForLast12Months	
        TISQP	TierSegmentsForQualificationPeriod
         * 
         * @return value
         */
        public String getTypeCode() {
            return typeCode;
        }

        /** 
         * Set the 'TypeCode' attribute value. The name of the type of additonal info value, like: 
        TIEXD	TierExpireDate
        TIMIL	TierMiles	
        TIM12 TierMiliesForLast12Months	
        TIMQP	TierMiliesForQualificationPeriod	
        TISEG	TierSegments	
        TIS12	TierSegmentsForLast12Months	
        TISQP	TierSegmentsForQualificationPeriod
         * 
         * @param typeCode
         */
        public void setTypeCode(String typeCode) {
            this.typeCode = typeCode;
        }

        /** 
         * Get the 'Value' attribute value. The value of the additional info
         * 
         * @return value
         */
        public String getValue() {
            return value;
        }

        /** 
         * Set the 'Value' attribute value. The value of the additional info
         * 
         * @param value
         */
        public void setValue(String value) {
            this.value = value;
        }
    }
}
