
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustLoyaltyType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="GivenName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="MiddleName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="SurName" minOccurs="0"/>
 *     &lt;xs:element type="ns:MembershipLevelType" name="MembershipLevel" minOccurs="0"/>
 *     &lt;xs:element type="ns:AssociatedVendorsType" name="AssociatedVendors" minOccurs="0" maxOccurs="500"/>
 *     &lt;xs:element type="ns:CustLoyaltyTotalsType" name="CustLoyaltyTotals" minOccurs="0">
 *       &lt;xs:unique name="MilesToExpireOnDateUniqueness">
 *         &lt;xs:selector xpath="./p3:MilesToExpireOnDate"/>
 *         &lt;xs:field xpath="@MilesTypeCode"/>
 *         &lt;xs:field xpath="@MilesExpireDate"/>
 *       &lt;/xs:unique>
 *       &lt;xs:unique name="CustLoyaltyAdditionalInfoUniqueness">
 *         &lt;xs:selector xpath="./p3:AdditionalInfo"/>
 *         &lt;xs:field xpath="@TypeCode"/>
 *       &lt;/xs:unique>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:DataSourceInfoType" name="DataSource" minOccurs="0"/>
 *     &lt;xs:element type="ns:TransactionalDataType" name="TransactionalData" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="VendorCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ProgramTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="MembershipID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DisplaySequenceNo"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="OrderSequenceNo"/>
 *   &lt;xs:attribute type="ns:VIT_StarLineType" use="optional" name="VIT_LineType"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_SecondaryQualifier"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="VIT_OrderNmbr"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="InformationText"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustLoyaltyType implements Serializable
{
    private String givenName;
    private String middleName;
    private String surName;
    private MembershipLevelType membershipLevel;
    private List<AssociatedVendorsType> associatedVendorList = new ArrayList<AssociatedVendorsType>();
    private CustLoyaltyTotalsType custLoyaltyTotals;
    private DataSourceInfoType dataSource;
    private TransactionalDataType transactionalData;
    private String vendorTypeCode;
    private String vendorCode;
    private String programTypeCode;
    private String membershipID;
    private String displaySequenceNo;
    private String orderSequenceNo;
    private VITStarLineType VITLineType;
    private String VITSecondaryQualifier;
    private String VITOrderNmbr;
    private String informationText;

    /** 
     * Get the 'GivenName' element value. Given name, first name or names
     * 
     * @return value
     */
    public String getGivenName() {
        return givenName;
    }

    /** 
     * Set the 'GivenName' element value. Given name, first name or names
     * 
     * @param givenName
     */
    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    /** 
     * Get the 'MiddleName' element value. The middle name of the person name
     * 
     * @return value
     */
    public String getMiddleName() {
        return middleName;
    }

    /** 
     * Set the 'MiddleName' element value. The middle name of the person name
     * 
     * @param middleName
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    /** 
     * Get the 'SurName' element value. Family name, last name.
     * 
     * @return value
     */
    public String getSurName() {
        return surName;
    }

    /** 
     * Set the 'SurName' element value. Family name, last name.
     * 
     * @param surName
     */
    public void setSurName(String surName) {
        this.surName = surName;
    }

    /** 
     * Get the 'MembershipLevel' element value. Membership Level Info Type
     * 
     * @return value
     */
    public MembershipLevelType getMembershipLevel() {
        return membershipLevel;
    }

    /** 
     * Set the 'MembershipLevel' element value. Membership Level Info Type
     * 
     * @param membershipLevel
     */
    public void setMembershipLevel(MembershipLevelType membershipLevel) {
        this.membershipLevel = membershipLevel;
    }

    /** 
     * Get the list of 'AssociatedVendors' element items. Associated vendors
     * 
     * @return list
     */
    public List<AssociatedVendorsType> getAssociatedVendorList() {
        return associatedVendorList;
    }

    /** 
     * Set the list of 'AssociatedVendors' element items. Associated vendors
     * 
     * @param list
     */
    public void setAssociatedVendorList(List<AssociatedVendorsType> list) {
        associatedVendorList = list;
    }

    /** 
     * Get the 'CustLoyaltyTotals' element value. VIT Customer Profiles Only
     * 
     * @return value
     */
    public CustLoyaltyTotalsType getCustLoyaltyTotals() {
        return custLoyaltyTotals;
    }

    /** 
     * Set the 'CustLoyaltyTotals' element value. VIT Customer Profiles Only
     * 
     * @param custLoyaltyTotals
     */
    public void setCustLoyaltyTotals(CustLoyaltyTotalsType custLoyaltyTotals) {
        this.custLoyaltyTotals = custLoyaltyTotals;
    }

    /** 
     * Get the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @return value
     */
    public DataSourceInfoType getDataSource() {
        return dataSource;
    }

    /** 
     * Set the 'DataSource' element value. *** SABRE ADDED ***  Deprecated, will be removed in 7.0 release
     * 
     * @param dataSource
     */
    public void setDataSource(DataSourceInfoType dataSource) {
        this.dataSource = dataSource;
    }

    /** 
     * Get the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @return value
     */
    public TransactionalDataType getTransactionalData() {
        return transactionalData;
    }

    /** 
     * Set the 'TransactionalData' element value. *** SABRE ADDED *** Transactional Data only , This data will not be stored with a profile, this will be stored only in templates if needed and should be used with Templates only
     * 
     * @param transactionalData
     */
    public void setTransactionalData(TransactionalDataType transactionalData) {
        this.transactionalData = transactionalData;
    }

    /** 
     * Get the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorTypeCode() {
        return vendorTypeCode;
    }

    /** 
     * Set the 'VendorTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorTypeCode
     */
    public void setVendorTypeCode(String vendorTypeCode) {
        this.vendorTypeCode = vendorTypeCode;
    }

    /** 
     * Get the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getVendorCode() {
        return vendorCode;
    }

    /** 
     * Set the 'VendorCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param vendorCode
     */
    public void setVendorCode(String vendorCode) {
        this.vendorCode = vendorCode;
    }

    /** 
     * Get the 'ProgramTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @return value
     */
    public String getProgramTypeCode() {
        return programTypeCode;
    }

    /** 
     * Set the 'ProgramTypeCode' attribute value. Identifier to indicate the company owner of the loyalty program.
     * 
     * @param programTypeCode
     */
    public void setProgramTypeCode(String programTypeCode) {
        this.programTypeCode = programTypeCode;
    }

    /** 
     * Get the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @return value
     */
    public String getMembershipID() {
        return membershipID;
    }

    /** 
     * Set the 'MembershipID' attribute value. Unique identifier of the member in the program (membership number, account number, etc.).
     * 
     * @param membershipID
     */
    public void setMembershipID(String membershipID) {
        this.membershipID = membershipID;
    }

    /** 
     * Get the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @return value
     */
    public String getDisplaySequenceNo() {
        return displaySequenceNo;
    }

    /** 
     * Set the 'DisplaySequenceNo' attribute value. Defines sorting order for collection elements, numbers have to be unique within collection
     * 
     * @param displaySequenceNo
     */
    public void setDisplaySequenceNo(String displaySequenceNo) {
        this.displaySequenceNo = displaySequenceNo;
    }

    /** 
     * Get the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @return value
     */
    public String getOrderSequenceNo() {
        return orderSequenceNo;
    }

    /** 
     * Set the 'OrderSequenceNo' attribute value. Sequence Number with 1 being primary	
     * 
     * @param orderSequenceNo
     */
    public void setOrderSequenceNo(String orderSequenceNo) {
        this.orderSequenceNo = orderSequenceNo;
    }

    /** 
     * Get the 'VIT_LineType' attribute value.
     * 
     * @return value
     */
    public VITStarLineType getVITLineType() {
        return VITLineType;
    }

    /** 
     * Set the 'VIT_LineType' attribute value.
     * 
     * @param VITLineType
     */
    public void setVITLineType(VITStarLineType VITLineType) {
        this.VITLineType = VITLineType;
    }

    /** 
     * Get the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @return value
     */
    public String getVITSecondaryQualifier() {
        return VITSecondaryQualifier;
    }

    /** 
     * Set the 'VIT_SecondaryQualifier' attribute value.
     * 
     * @param VITSecondaryQualifier
     */
    public void setVITSecondaryQualifier(String VITSecondaryQualifier) {
        this.VITSecondaryQualifier = VITSecondaryQualifier;
    }

    /** 
     * Get the 'VIT_OrderNmbr' attribute value.
     * 
     * @return value
     */
    public String getVITOrderNmbr() {
        return VITOrderNmbr;
    }

    /** 
     * Set the 'VIT_OrderNmbr' attribute value.
     * 
     * @param VITOrderNmbr
     */
    public void setVITOrderNmbr(String VITOrderNmbr) {
        this.VITOrderNmbr = VITOrderNmbr;
    }

    /** 
     * Get the 'InformationText' attribute value. Information about a Customer Loyalty
     * 
     * @return value
     */
    public String getInformationText() {
        return informationText;
    }

    /** 
     * Set the 'InformationText' attribute value. Information about a Customer Loyalty
     * 
     * @param informationText
     */
    public void setInformationText(String informationText) {
        this.informationText = informationText;
    }
}
