
package com.sabre.eps.schemas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CustomerAttributesType">
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="MaritalStatusCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="GenderCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="AgeRange"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="RedressNumber"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="KnownTravelerNumber"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="ChildIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" name="SeniorIndicator"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CitizenCountryCode"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CurrencyCode"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="LapInfantIndicator"/>
 *   &lt;xs:attribute type="ns:YesNoType" use="optional" default="N" name="IsSubjectToSecureFlightRule"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Nationality"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CountryOfResidence"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class CustomerAttributesType implements Serializable
{
    private Date birthDate;
    private String maritalStatusCode;
    private String genderCode;
    private String ageRange;
    private String redressNumber;
    private String knownTravelerNumber;
    private YesNoType childIndicator;
    private YesNoType seniorIndicator;
    private String citizenCountryCode;
    private String currencyCode;
    private YesNoType lapInfantIndicator;
    private YesNoType isSubjectToSecureFlightRule;
    private String nationality;
    private String countryOfResidence;

    /** 
     * Get the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @return value
     */
    public String getMaritalStatusCode() {
        return maritalStatusCode;
    }

    /** 
     * Set the 'MaritalStatusCode' attribute value. ***SABRE ADDED*** Marital status of a person
     * 
     * @param maritalStatusCode
     */
    public void setMaritalStatusCode(String maritalStatusCode) {
        this.maritalStatusCode = maritalStatusCode;
    }

    /** 
     * Get the 'GenderCode' attribute value.
     * 
     * @return value
     */
    public String getGenderCode() {
        return genderCode;
    }

    /** 
     * Set the 'GenderCode' attribute value.
     * 
     * @param genderCode
     */
    public void setGenderCode(String genderCode) {
        this.genderCode = genderCode;
    }

    /** 
     * Get the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @return value
     */
    public String getAgeRange() {
        return ageRange;
    }

    /** 
     * Set the 'AgeRange' attribute value. ***SABRE ADDED*** Age Range of a person customizable by a client
     * 
     * @param ageRange
     */
    public void setAgeRange(String ageRange) {
        this.ageRange = ageRange;
    }

    /** 
     * Get the 'RedressNumber' attribute value.
     * 
     * @return value
     */
    public String getRedressNumber() {
        return redressNumber;
    }

    /** 
     * Set the 'RedressNumber' attribute value.
     * 
     * @param redressNumber
     */
    public void setRedressNumber(String redressNumber) {
        this.redressNumber = redressNumber;
    }

    /** 
     * Get the 'KnownTravelerNumber' attribute value.
     * 
     * @return value
     */
    public String getKnownTravelerNumber() {
        return knownTravelerNumber;
    }

    /** 
     * Set the 'KnownTravelerNumber' attribute value.
     * 
     * @param knownTravelerNumber
     */
    public void setKnownTravelerNumber(String knownTravelerNumber) {
        this.knownTravelerNumber = knownTravelerNumber;
    }

    /** 
     * Get the 'ChildIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getChildIndicator() {
        return childIndicator;
    }

    /** 
     * Set the 'ChildIndicator' attribute value.
     * 
     * @param childIndicator
     */
    public void setChildIndicator(YesNoType childIndicator) {
        this.childIndicator = childIndicator;
    }

    /** 
     * Get the 'SeniorIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getSeniorIndicator() {
        return seniorIndicator;
    }

    /** 
     * Set the 'SeniorIndicator' attribute value.
     * 
     * @param seniorIndicator
     */
    public void setSeniorIndicator(YesNoType seniorIndicator) {
        this.seniorIndicator = seniorIndicator;
    }

    /** 
     * Get the 'CitizenCountryCode' attribute value.
     * 
     * @return value
     */
    public String getCitizenCountryCode() {
        return citizenCountryCode;
    }

    /** 
     * Set the 'CitizenCountryCode' attribute value.
     * 
     * @param citizenCountryCode
     */
    public void setCitizenCountryCode(String citizenCountryCode) {
        this.citizenCountryCode = citizenCountryCode;
    }

    /** 
     * Get the 'CurrencyCode' attribute value. Currency Code
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' attribute value. Currency Code
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'LapInfantIndicator' attribute value.
     * 
     * @return value
     */
    public YesNoType getLapInfantIndicator() {
        return lapInfantIndicator;
    }

    /** 
     * Set the 'LapInfantIndicator' attribute value.
     * 
     * @param lapInfantIndicator
     */
    public void setLapInfantIndicator(YesNoType lapInfantIndicator) {
        this.lapInfantIndicator = lapInfantIndicator;
    }

    /** 
     * Get the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @return value
     */
    public YesNoType getIsSubjectToSecureFlightRule() {
        return isSubjectToSecureFlightRule;
    }

    /** 
     * Set the 'IsSubjectToSecureFlightRule' attribute value.
     * 
     * @param isSubjectToSecureFlightRule
     */
    public void setIsSubjectToSecureFlightRule(
            YesNoType isSubjectToSecureFlightRule) {
        this.isSubjectToSecureFlightRule = isSubjectToSecureFlightRule;
    }

    /** 
     * Get the 'Nationality' attribute value.
     * 
     * @return value
     */
    public String getNationality() {
        return nationality;
    }

    /** 
     * Set the 'Nationality' attribute value.
     * 
     * @param nationality
     */
    public void setNationality(String nationality) {
        this.nationality = nationality;
    }

    /** 
     * Get the 'CountryOfResidence' attribute value.
     * 
     * @return value
     */
    public String getCountryOfResidence() {
        return countryOfResidence;
    }

    /** 
     * Set the 'CountryOfResidence' attribute value.
     * 
     * @param countryOfResidence
     */
    public void setCountryOfResidence(String countryOfResidence) {
        this.countryOfResidence = countryOfResidence;
    }
}
