
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * *** SABRE ADDED *** Used to delete entries from the Dictionary
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteDictionaryType">
 *   &lt;xs:choice>
 *     &lt;xs:element type="ns:DictionaryIdentityType" name="FullDelete"/>
 *     &lt;xs:element type="ns:PartialDeleteDictionaryType" name="PartialDelete"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteDictionaryType implements Serializable
{
    private int choiceSelect = -1;
    private static final int FULL_DELETE_CHOICE = 0;
    private static final int PARTIAL_DELETE_CHOICE = 1;
    private DictionaryIdentityType fullDelete;
    private PartialDeleteDictionaryType partialDelete;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if FullDelete is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifFullDelete() {
        return choiceSelect == FULL_DELETE_CHOICE;
    }

    /** 
     * Get the 'FullDelete' element value. *** SABRE ADDED *** Used to delete all entries from the Dictionary
     * 
     * @return value
     */
    public DictionaryIdentityType getFullDelete() {
        return fullDelete;
    }

    /** 
     * Set the 'FullDelete' element value. *** SABRE ADDED *** Used to delete all entries from the Dictionary
     * 
     * @param fullDelete
     */
    public void setFullDelete(DictionaryIdentityType fullDelete) {
        setChoiceSelect(FULL_DELETE_CHOICE);
        this.fullDelete = fullDelete;
    }

    /** 
     * Check if PartialDelete is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifPartialDelete() {
        return choiceSelect == PARTIAL_DELETE_CHOICE;
    }

    /** 
     * Get the 'PartialDelete' element value. *** SABRE ADDED *** Used to delete subset of Dictionary entries
     * 
     * @return value
     */
    public PartialDeleteDictionaryType getPartialDelete() {
        return partialDelete;
    }

    /** 
     * Set the 'PartialDelete' element value. *** SABRE ADDED *** Used to delete subset of Dictionary entries
     * 
     * @param partialDelete
     */
    public void setPartialDelete(PartialDeleteDictionaryType partialDelete) {
        setChoiceSelect(PARTIAL_DELETE_CHOICE);
        this.partialDelete = partialDelete;
    }
}
