
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Root element for profile content.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteDomainProfilesType">
 *   &lt;xs:attribute type="ns:SearchProfileTypeInfo" use="required" name="ProfileTypeCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PurgeDays"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteDomainProfilesType implements Serializable
{
    private SearchProfileTypeInfo profileTypeCode;
    private String domainID;
    private String purgeDays;
    private String clientCode;
    private String clientContextCode;

    /** 
     * Get the 'ProfileTypeCode' attribute value.
     * 
     * @return value
     */
    public SearchProfileTypeInfo getProfileTypeCode() {
        return profileTypeCode;
    }

    /** 
     * Set the 'ProfileTypeCode' attribute value.
     * 
     * @param profileTypeCode
     */
    public void setProfileTypeCode(SearchProfileTypeInfo profileTypeCode) {
        this.profileTypeCode = profileTypeCode;
    }

    /** 
     * Get the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value. DomainID will be PCC for Agency Profiles, SVT for SVT/Inform Profiles
    	
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'PurgeDays' attribute value. Number of days after which the profile needs to be purged, if the value is 0 then it is an immediate Delete if not it is a flag for future delete
     * 
     * @return value
     */
    public String getPurgeDays() {
        return purgeDays;
    }

    /** 
     * Set the 'PurgeDays' attribute value. Number of days after which the profile needs to be purged, if the value is 0 then it is an immediate Delete if not it is a flag for future delete
     * 
     * @param purgeDays
     */
    public void setPurgeDays(String purgeDays) {
        this.purgeDays = purgeDays;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }
}
