
package com.sabre.eps.schemas;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/eps/schemas" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DeleteFormatType">
 *   &lt;xs:attribute type="xs:string" use="required" name="FormatID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="DomainID"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="PurgeDays"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientCode"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="ClientContextCode"/>
 *   &lt;xs:attribute type="ns:StatusType" use="optional" default="DL" name="StatusCode"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DeleteFormatType implements Serializable
{
    private String formatID;
    private String domainID;
    private String purgeDays;
    private String clientCode;
    private String clientContextCode;
    private StatusType statusCode;

    /** 
     * Get the 'FormatID' attribute value. *** SABRE ADDED *** ID of the Format in the database
     * 
     * @return value
     */
    public String getFormatID() {
        return formatID;
    }

    /** 
     * Set the 'FormatID' attribute value. *** SABRE ADDED *** ID of the Format in the database
     * 
     * @param formatID
     */
    public void setFormatID(String formatID) {
        this.formatID = formatID;
    }

    /** 
     * Get the 'DomainID' attribute value.
     * 
     * @return value
     */
    public String getDomainID() {
        return domainID;
    }

    /** 
     * Set the 'DomainID' attribute value.
     * 
     * @param domainID
     */
    public void setDomainID(String domainID) {
        this.domainID = domainID;
    }

    /** 
     * Get the 'PurgeDays' attribute value. Number of days after which the Format needs to be purged
     * 
     * @return value
     */
    public String getPurgeDays() {
        return purgeDays;
    }

    /** 
     * Set the 'PurgeDays' attribute value. Number of days after which the Format needs to be purged
     * 
     * @param purgeDays
     */
    public void setPurgeDays(String purgeDays) {
        this.purgeDays = purgeDays;
    }

    /** 
     * Get the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @return value
     */
    public String getClientCode() {
        return clientCode;
    }

    /** 
     * Set the 'ClientCode' attribute value. ClientCode indicated the code that is associated with the profile that is shared between calling applications
    	
     * 
     * @param clientCode
     */
    public void setClientCode(String clientCode) {
        this.clientCode = clientCode;
    }

    /** 
     * Get the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @return value
     */
    public String getClientContextCode() {
        return clientContextCode;
    }

    /** 
     * Set the 'ClientContextCode' attribute value. CLientContextCode is the calling application code
    	
     * 
     * @param clientContextCode
     */
    public void setClientContextCode(String clientContextCode) {
        this.clientContextCode = clientContextCode;
    }

    /** 
     * Get the 'StatusCode' attribute value.
     * 
     * @return value
     */
    public StatusType getStatusCode() {
        return statusCode;
    }

    /** 
     * Set the 'StatusCode' attribute value.
     * 
     * @param statusCode
     */
    public void setStatusCode(StatusType statusCode) {
        this.statusCode = statusCode;
    }
}
